/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.reflect;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Iterator;
import org.apache.avro.AvroTestUtil;
import org.apache.avro.Schema;
import org.apache.avro.file.DataFileReader;
import org.apache.avro.file.DataFileWriter;
import org.apache.avro.file.FileReader;
import org.apache.avro.file.SeekableByteArrayInput;
import org.apache.avro.file.SeekableInput;
import org.apache.avro.io.DatumReader;
import org.apache.avro.io.DatumWriter;
import org.apache.avro.reflect.ReflectData;
import org.apache.avro.reflect.ReflectDatumReader;
import org.apache.avro.reflect.ReflectDatumWriter;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestByteBuffer {
    File content;
    public static final String __PARANAMER_DATA = "getmd5 java.nio.ByteBuffer buffer \n";

    @Before
    public void before() throws IOException {
        File tmpdir = AvroTestUtil.tempDirectory(this.getClass(), "content");
        this.content = new File(tmpdir, "test-content");
        FileOutputStream out = new FileOutputStream(this.content);
        for (int i = 0; i < 100000; ++i) {
            out.write("hello world\n".getBytes());
        }
        out.close();
    }

    @Test
    public void test() throws Exception {
        Schema schema = ReflectData.get().getSchema(X.class);
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        this.writeOneXAsAvro(schema, bout);
        X record = this.readOneXFromAvro(schema, bout);
        String expected = this.getmd5(this.content);
        String actual = this.getmd5(record.content);
        Assert.assertEquals((String)"md5 for result differed from input", (Object)expected, (Object)actual);
    }

    private X readOneXFromAvro(Schema schema, ByteArrayOutputStream bout) throws IOException {
        SeekableByteArrayInput input = new SeekableByteArrayInput(bout.toByteArray());
        ReflectDatumReader datumReader = new ReflectDatumReader(schema);
        FileReader reader = DataFileReader.openReader((SeekableInput)input, (DatumReader)datumReader);
        Iterator it = reader.iterator();
        Assert.assertTrue((String)"missing first record", (boolean)it.hasNext());
        X record = (X)it.next();
        Assert.assertFalse((String)"should be no more records - only wrote one out", (boolean)it.hasNext());
        return record;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeOneXAsAvro(Schema schema, ByteArrayOutputStream bout) throws IOException, FileNotFoundException {
        ReflectDatumWriter datumWriter = new ReflectDatumWriter(schema);
        DataFileWriter writer = new DataFileWriter((DatumWriter)datumWriter);
        writer.create(schema, (OutputStream)bout);
        X x = new X();
        x.name = "xxx";
        FileInputStream fis = new FileInputStream(this.content);
        try {
            FileChannel channel = fis.getChannel();
            try {
                long contentLength = this.content.length();
                MappedByteBuffer buffer = channel.map(FileChannel.MapMode.READ_ONLY, 0L, contentLength);
                x.content = buffer;
                writer.append((Object)x);
            }
            finally {
                channel.close();
            }
        }
        finally {
            fis.close();
        }
        writer.flush();
        writer.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getmd5(File file) throws Exception {
        FileInputStream fis = new FileInputStream(this.content);
        try {
            String string;
            FileChannel channel = fis.getChannel();
            try {
                long contentLength = this.content.length();
                MappedByteBuffer buffer = channel.map(FileChannel.MapMode.READ_ONLY, 0L, contentLength);
                string = this.getmd5(buffer);
            }
            catch (Throwable throwable) {
                channel.close();
                throw throwable;
            }
            channel.close();
            return string;
        }
        finally {
            fis.close();
        }
    }

    String getmd5(ByteBuffer buffer) throws NoSuchAlgorithmException {
        MessageDigest mdEnc = MessageDigest.getInstance("MD5");
        mdEnc.reset();
        mdEnc.update(buffer);
        return new BigInteger(1, mdEnc.digest()).toString(16);
    }

    static class X {
        String name = "";
        ByteBuffer content;
        public static final String __PARANAMER_DATA = "";

        X() {
        }
    }
}

