/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.reflect;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Array;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URI;
import java.net.URL;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.apache.avro.AvroRuntimeException;
import org.apache.avro.AvroTypeException;
import org.apache.avro.Protocol;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.avro.io.BinaryDecoder;
import org.apache.avro.io.BinaryEncoder;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.DecoderFactory;
import org.apache.avro.io.Encoder;
import org.apache.avro.io.EncoderFactory;
import org.apache.avro.reflect.AvroAlias;
import org.apache.avro.reflect.AvroDefault;
import org.apache.avro.reflect.AvroEncode;
import org.apache.avro.reflect.AvroIgnore;
import org.apache.avro.reflect.AvroMeta;
import org.apache.avro.reflect.AvroName;
import org.apache.avro.reflect.AvroSchema;
import org.apache.avro.reflect.DateAsLongEncoding;
import org.apache.avro.reflect.Nullable;
import org.apache.avro.reflect.ReflectData;
import org.apache.avro.reflect.ReflectDatumReader;
import org.apache.avro.reflect.ReflectDatumWriter;
import org.apache.avro.reflect.ReflectionUtil;
import org.apache.avro.reflect.Stringable;
import org.apache.avro.reflect.Union;
import org.codehaus.jackson.node.NullNode;
import org.junit.Assert;
import org.junit.Test;

public class TestReflect {
    EncoderFactory factory = new EncoderFactory();
    public static final String __PARANAMER_DATA = "checkBinary ReflectData,org.apache.avro.Schema,java.lang.Object,boolean reflectData,schema,datum,equals \ncheckBinary org.apache.avro.Schema,java.lang.Object schema,datum \ncheckReadWrite java.lang.Object object \ncheckReadWrite java.lang.Object,org.apache.avro.Schema object,s \ncheckStringable java.lang.Class,java.lang.String c,value \n";

    @Test
    public void testVoid() {
        this.check(Void.TYPE, "\"null\"");
        this.check((Type)((Object)Void.class), "\"null\"");
    }

    @Test
    public void testBoolean() {
        this.check(Boolean.TYPE, "\"boolean\"");
        this.check((Type)((Object)Boolean.class), "\"boolean\"");
    }

    @Test
    public void testInt() {
        this.check(Integer.TYPE, "\"int\"");
        this.check((Type)((Object)Integer.class), "\"int\"");
    }

    @Test
    public void testByte() {
        this.check(Byte.TYPE, "{\"type\":\"int\",\"java-class\":\"java.lang.Byte\"}");
        this.check((Type)((Object)Byte.class), "{\"type\":\"int\",\"java-class\":\"java.lang.Byte\"}");
    }

    @Test
    public void testShort() {
        this.check(Short.TYPE, "{\"type\":\"int\",\"java-class\":\"java.lang.Short\"}");
        this.check((Type)((Object)Short.class), "{\"type\":\"int\",\"java-class\":\"java.lang.Short\"}");
    }

    @Test
    public void testChar() {
        this.check(Character.TYPE, "{\"type\":\"int\",\"java-class\":\"java.lang.Character\"}");
        this.check((Type)((Object)Character.class), "{\"type\":\"int\",\"java-class\":\"java.lang.Character\"}");
    }

    @Test
    public void testLong() {
        this.check(Long.TYPE, "\"long\"");
        this.check((Type)((Object)Long.class), "\"long\"");
    }

    @Test
    public void testFloat() {
        this.check(Float.TYPE, "\"float\"");
        this.check((Type)((Object)Float.class), "\"float\"");
    }

    @Test
    public void testDouble() {
        this.check(Double.TYPE, "\"double\"");
        this.check((Type)((Object)Double.class), "\"double\"");
    }

    @Test
    public void testString() {
        this.check("Foo", "\"string\"");
    }

    @Test
    public void testBytes() {
        this.check(ByteBuffer.allocate(0), "\"bytes\"");
        this.check(new byte[0], "{\"type\":\"bytes\",\"java-class\":\"[B\"}");
    }

    @Test
    public void testUnionWithCollection() {
        Schema s = new Schema.Parser().parse("[\"null\", {\"type\":\"array\",\"items\":\"float\"}]");
        ReflectData data = ReflectData.get();
        Assert.assertEquals((long)1L, (long)data.resolveUnion(s, new ArrayList()));
    }

    @Test
    public void testUnionWithMap() {
        Schema s = new Schema.Parser().parse("[\"null\", {\"type\":\"map\",\"values\":\"float\"}]");
        ReflectData data = ReflectData.get();
        Assert.assertEquals((long)1L, (long)data.resolveUnion(s, new HashMap()));
    }

    @Test
    public void testUnionWithFixed() {
        Schema s = new Schema.Parser().parse("[\"null\", {\"type\":\"fixed\",\"name\":\"f\",\"size\":1}]");
        Schema f = new Schema.Parser().parse("{\"type\":\"fixed\",\"name\":\"f\",\"size\":1}");
        ReflectData data = ReflectData.get();
        Assert.assertEquals((long)1L, (long)data.resolveUnion(s, (Object)new GenericData.Fixed(f)));
    }

    @Test
    public void testUnionWithEnum() {
        Schema s = new Schema.Parser().parse("[\"null\", {\"type\":\"enum\",\"name\":\"E\",\"namespace\":\"org.apache.avro.reflect.TestReflect$\",\"symbols\":[\"A\",\"B\"]}]");
        ReflectData data = ReflectData.get();
        Assert.assertEquals((long)1L, (long)data.resolveUnion(s, (Object)E.A));
    }

    @Test
    public void testUnionWithBytes() {
        Schema s = new Schema.Parser().parse("[\"null\", \"bytes\"]");
        ReflectData data = ReflectData.get();
        Assert.assertEquals((long)1L, (long)data.resolveUnion(s, (Object)ByteBuffer.wrap(new byte[]{1})));
    }

    @Test
    public void testMap() throws Exception {
        this.check(R1.class.getDeclaredField("mapField").getGenericType(), "{\"type\":\"map\",\"values\":\"string\"}");
    }

    @Test
    public void testArray() throws Exception {
        this.check(R1.class.getDeclaredField("arrayField").getGenericType(), "{\"type\":\"array\",\"items\":\"string\",\"java-class\":\"[Ljava.lang.String;\"}");
    }

    @Test
    public void testList() throws Exception {
        this.check(R1.class.getDeclaredField("listField").getGenericType(), "{\"type\":\"array\",\"items\":\"string\",\"java-class\":\"java.util.List\"}");
    }

    @Test
    public void testR1() throws Exception {
        this.checkReadWrite(new R1());
    }

    @Test
    public void testR2() throws Exception {
        R2 r2 = new R2();
        R2.access$002(r2, new String[]{"foo"});
        r2.collectionField = new ArrayList();
        r2.collectionField.add("foo");
        this.checkReadWrite(r2);
    }

    @Test
    public void testR3() throws Exception {
        R3 r3 = new R3();
        R3.access$202(r3, new int[]{1});
        this.checkReadWrite(r3);
    }

    @Test
    public void testR5() throws Exception {
        R5 r5 = new R5();
        r5.value = 1;
        r5.shorts = new short[]{3, 255, 256, Short.MAX_VALUE, Short.MIN_VALUE};
        r5.b = (byte)99;
        r5.c = (char)97;
        this.checkReadWrite(r5);
    }

    @Test
    public void testR6() throws Exception {
        R7 r7 = new R7();
        r7.value = 1;
        this.checkReadWrite(r7, ReflectData.get().getSchema(R6.class));
        R8 r8 = new R8();
        r8.value = 1.0f;
        this.checkReadWrite(r8, ReflectData.get().getSchema(R6.class));
        R9 r9 = new R9();
        r9.r6s = new R6[]{r7, r8};
        this.checkReadWrite(r9, ReflectData.get().getSchema(R9.class));
    }

    @Test
    public void testP0() throws Exception {
        Protocol p0 = ReflectData.get().getProtocol(P0.class);
        Protocol.Message message = (Protocol.Message)p0.getMessages().get("foo");
        Schema response = message.getResponse();
        Assert.assertEquals((Object)Schema.Type.UNION, (Object)response.getType());
        Assert.assertEquals((Object)Schema.Type.NULL, (Object)((Schema)response.getTypes().get(0)).getType());
        Assert.assertEquals((Object)Schema.Type.STRING, (Object)((Schema)response.getTypes().get(1)).getType());
        Schema request = message.getRequest();
        Schema.Field field = request.getField("s");
        Assert.assertNotNull((String)"field 's' should not be null", (Object)field);
        Schema param = field.schema();
        Assert.assertEquals((Object)Schema.Type.UNION, (Object)param.getType());
        Assert.assertEquals((Object)Schema.Type.NULL, (Object)((Schema)param.getTypes().get(0)).getType());
        Assert.assertEquals((Object)Schema.Type.STRING, (Object)((Schema)param.getTypes().get(1)).getType());
        Assert.assertEquals(String.class, (Object)ReflectData.get().getClass(response));
        Assert.assertEquals(String.class, (Object)ReflectData.get().getClass(param));
    }

    @Test
    public void testR10() throws Exception {
        Schema r10Schema = ReflectData.get().getSchema(R10.class);
        Assert.assertEquals((Object)Schema.Type.STRING, (Object)r10Schema.getType());
        Assert.assertEquals((Object)R10.class.getName(), (Object)r10Schema.getProp("java-class"));
        this.checkReadWrite(new R10("foo"), r10Schema);
    }

    @Test
    public void testR11() throws Exception {
        Schema r11Record = ReflectData.get().getSchema(R11.class);
        Assert.assertEquals((Object)Schema.Type.RECORD, (Object)r11Record.getType());
        Schema.Field r11Field = r11Record.getField("text");
        Assert.assertEquals((Object)NullNode.getInstance(), (Object)r11Field.defaultValue());
        Schema r11FieldSchema = r11Field.schema();
        Assert.assertEquals((Object)Schema.Type.UNION, (Object)r11FieldSchema.getType());
        Assert.assertEquals((Object)Schema.Type.NULL, (Object)((Schema)r11FieldSchema.getTypes().get(0)).getType());
        Schema r11String = (Schema)r11FieldSchema.getTypes().get(1);
        Assert.assertEquals((Object)Schema.Type.STRING, (Object)r11String.getType());
        R11 r11 = new R11();
        this.checkReadWrite(r11, r11Record);
        r11.text = "foo";
        this.checkReadWrite(r11, r11Record);
    }

    @Test
    public void testP1() throws Exception {
        Protocol p1 = ReflectData.get().getProtocol(P1.class);
        Protocol.Message message = (Protocol.Message)p1.getMessages().get("foo");
        Schema response = message.getResponse();
        Assert.assertEquals((Object)Schema.Type.UNION, (Object)response.getType());
        Assert.assertEquals((Object)Schema.Type.NULL, (Object)((Schema)response.getTypes().get(0)).getType());
        Assert.assertEquals((Object)Schema.Type.STRING, (Object)((Schema)response.getTypes().get(1)).getType());
        Schema request = message.getRequest();
        Schema.Field field = request.getField("s");
        Assert.assertNotNull((String)"field 's' should not be null", (Object)field);
        Schema param = field.schema();
        Assert.assertEquals((Object)Schema.Type.UNION, (Object)param.getType());
        Assert.assertEquals((Object)Schema.Type.NULL, (Object)((Schema)param.getTypes().get(0)).getType());
        Assert.assertEquals((Object)Schema.Type.STRING, (Object)((Schema)param.getTypes().get(1)).getType());
        Assert.assertEquals(String.class, (Object)ReflectData.get().getClass(response));
        Assert.assertEquals(String.class, (Object)ReflectData.get().getClass(param));
    }

    @Test
    public void testR12() throws Exception {
        Schema s = ReflectData.get().getSchema(R12.class);
        Assert.assertEquals((Object)Schema.Type.INT, (Object)s.getField("x").schema().getType());
        Assert.assertEquals((Object)Schema.parse((String)"{\"type\":\"array\",\"items\":[\"null\",\"string\"]}"), (Object)s.getField("strings").schema());
    }

    @Test
    public void testR13() throws Exception {
        Schema s = ReflectData.get().getSchema(R13.class);
        Assert.assertEquals((Object)Schema.Type.NULL, (Object)s.getType());
    }

    @Test
    public void testP4() throws Exception {
        Protocol p = ReflectData.get().getProtocol(P4.class);
        Protocol.Message message = (Protocol.Message)p.getMessages().get("foo");
        Assert.assertEquals((Object)Schema.Type.INT, (Object)message.getResponse().getType());
        Schema.Field field = message.getRequest().getField("x");
        Assert.assertEquals((Object)Schema.Type.INT, (Object)field.schema().getType());
    }

    @Test
    public void testP2() throws Exception {
        Schema e1 = ReflectData.get().getSchema(E1.class);
        Assert.assertEquals((Object)Schema.Type.RECORD, (Object)e1.getType());
        Assert.assertTrue((boolean)e1.isError());
        Schema.Field message = e1.getField("detailMessage");
        Assert.assertNotNull((String)"field 'detailMessage' should not be null", (Object)message);
        Schema messageSchema = message.schema();
        Assert.assertEquals((Object)Schema.Type.UNION, (Object)messageSchema.getType());
        Assert.assertEquals((Object)Schema.Type.NULL, (Object)((Schema)messageSchema.getTypes().get(0)).getType());
        Assert.assertEquals((Object)Schema.Type.STRING, (Object)((Schema)messageSchema.getTypes().get(1)).getType());
        Protocol p2 = ReflectData.get().getProtocol(P2.class);
        Protocol.Message m = (Protocol.Message)p2.getMessages().get("error");
        Schema response = m.getErrors();
        Assert.assertEquals((Object)Schema.Type.UNION, (Object)response.getType());
        Assert.assertEquals((Object)Schema.Type.STRING, (Object)((Schema)response.getTypes().get(0)).getType());
        Assert.assertEquals((Object)e1, response.getTypes().get(1));
    }

    @Test
    public void testNoPackage() throws Exception {
        Class<?> noPackage = Class.forName("NoPackage");
        Schema s = ReflectData.get().getSchema(noPackage);
        Assert.assertEquals((Object)noPackage.getName(), (Object)ReflectData.getClassName((Schema)s));
    }

    void checkReadWrite(Object object) throws Exception {
        this.checkReadWrite(object, ReflectData.get().getSchema(object.getClass()));
    }

    void checkReadWrite(Object object, Schema s) throws Exception {
        ReflectDatumWriter writer = new ReflectDatumWriter(s);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        writer.write(object, (Encoder)this.factory.directBinaryEncoder((OutputStream)out, null));
        ReflectDatumReader reader = new ReflectDatumReader(s);
        Object after = reader.read(null, (Decoder)DecoderFactory.get().binaryDecoder(out.toByteArray(), null));
        Assert.assertEquals((Object)object, (Object)after);
        if (s.getType().equals((Object)Schema.Type.RECORD)) {
            Object copy = object.getClass().newInstance();
            for (Schema.Field f : s.getFields()) {
                Object val = ReflectData.get().getField(object, f.name(), f.pos());
                ReflectData.get().setField(copy, f.name(), f.pos(), val);
            }
            Assert.assertEquals((String)"setField", (Object)object, copy);
        }
    }

    @Test
    public void testEnum() throws Exception {
        this.check((Type)((Object)E.class), "{\"type\":\"enum\",\"name\":\"E\",\"namespace\":\"org.apache.avro.reflect.TestReflect$\",\"symbols\":[\"A\",\"B\"]}");
    }

    @Test
    public void testRecord() throws Exception {
        this.check((Type)((Object)R.class), "{\"type\":\"record\",\"name\":\"R\",\"namespace\":\"org.apache.avro.reflect.TestReflect$\",\"fields\":[{\"name\":\"a\",\"type\":\"int\"},{\"name\":\"b\",\"type\":\"long\"}]}");
    }

    @Test
    public void testAnnotationAvroIgnore() throws Exception {
        this.check((Type)((Object)RAvroIgnore.class), "{\"type\":\"record\",\"name\":\"RAvroIgnore\",\"namespace\":\"org.apache.avro.reflect.TestReflect$\",\"fields\":[]}");
    }

    @Test
    public void testAnnotationAvroMeta() throws Exception {
        this.check((Type)((Object)RAvroMeta.class), "{\"type\":\"record\",\"name\":\"RAvroMeta\",\"namespace\":\"org.apache.avro.reflect.TestReflect$\",\"fields\":[{\"name\":\"a\",\"type\":\"int\",\"K\":\"V\"}]}");
    }

    @Test
    public void testAnnotationAvroName() throws Exception {
        this.check((Type)((Object)RAvroName.class), "{\"type\":\"record\",\"name\":\"RAvroName\",\"namespace\":\"org.apache.avro.reflect.TestReflect$\",\"fields\":[{\"name\":\"b\",\"type\":\"int\"}]}");
    }

    @Test(expected=Exception.class)
    public void testAnnotationAvroNameCollide() throws Exception {
        this.check((Type)((Object)RAvroNameCollide.class), "{\"type\":\"record\",\"name\":\"RAvroNameCollide\",\"namespace\":\"org.apache.avro.reflect.TestReflect$\",\"fields\":[{\"name\":\"b\",\"type\":\"int\"},{\"name\":\"b\",\"type\":\"int\"}]}");
    }

    public void testAnnotationAvroStringableFields() throws Exception {
        this.check((Type)((Object)RAvroStringableField.class), "{\"type\":\"record\",\"name\":\"RAvroNameCollide\",\"namespace\":\"org.apache.avro.reflect.TestReflect$\",\"fields\":[{\"name\":\"a\",\"type\":\"String\"}]}");
    }

    private void check(Object o, String schemaJson) {
        this.check(o.getClass(), schemaJson);
    }

    private void check(Type type, String schemaJson) {
        Assert.assertEquals((Object)schemaJson, (Object)ReflectData.get().getSchema(type).toString());
    }

    @Test
    public void testRecordIO() throws IOException {
        Schema schm = ReflectData.get().getSchema(SampleRecord.class);
        ReflectDatumWriter writer = new ReflectDatumWriter(schm);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        SampleRecord record = new SampleRecord();
        record.x = 5;
        record.y = 10;
        writer.write((Object)record, (Encoder)this.factory.directBinaryEncoder((OutputStream)out, null));
        ReflectDatumReader reader = new ReflectDatumReader(schm);
        SampleRecord decoded = (SampleRecord)reader.read(null, (Decoder)DecoderFactory.get().binaryDecoder(out.toByteArray(), null));
        Assert.assertEquals((Object)record, (Object)decoded);
    }

    @Test
    public void testMultipleAnnotations() throws IOException {
        Schema schm = ReflectData.get().getSchema(multipleAnnotationRecord.class);
        ReflectDatumWriter writer = new ReflectDatumWriter(schm);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        multipleAnnotationRecord record = new multipleAnnotationRecord();
        record.i1 = 1;
        record.i2 = 2;
        record.i3 = 3;
        record.i4 = new Date(4L);
        record.i5 = 5;
        record.i6 = 6;
        record.i7 = new Date(7L);
        record.i8 = 8;
        record.i9 = new Date(9L);
        record.i10 = new Date(10L);
        record.i11 = new Date(11L);
        writer.write((Object)record, (Encoder)this.factory.directBinaryEncoder((OutputStream)out, null));
        ReflectDatumReader reader = new ReflectDatumReader(schm);
        multipleAnnotationRecord decoded = (multipleAnnotationRecord)reader.read((Object)new multipleAnnotationRecord(), (Decoder)DecoderFactory.get().binaryDecoder(out.toByteArray(), null));
        Assert.assertTrue((decoded.i1 == null ? 1 : 0) != 0);
        Assert.assertTrue((decoded.i2 == null ? 1 : 0) != 0);
        Assert.assertTrue((decoded.i3 == null ? 1 : 0) != 0);
        Assert.assertTrue((decoded.i4 == null ? 1 : 0) != 0);
        Assert.assertTrue((decoded.i5 == 5 ? 1 : 0) != 0);
        Assert.assertTrue((decoded.i6 == 6 ? 1 : 0) != 0);
        Assert.assertTrue((decoded.i7.getTime() == 7L ? 1 : 0) != 0);
        Assert.assertTrue((decoded.i8 == 8 ? 1 : 0) != 0);
        Assert.assertTrue((decoded.i9.getTime() == 9L ? 1 : 0) != 0);
        Assert.assertTrue((decoded.i10.getTime() == 10L ? 1 : 0) != 0);
        Assert.assertTrue((decoded.i11.getTime() == 11L ? 1 : 0) != 0);
    }

    @Test
    public void testAvroEncodeInducing() throws IOException {
        Schema schm = ReflectData.get().getSchema(AvroEncRecord.class);
        Assert.assertEquals((Object)schm.toString(), (Object)"{\"type\":\"record\",\"name\":\"AvroEncRecord\",\"namespace\":\"org.apache.avro.reflect.TestReflect$\",\"fields\":[{\"name\":\"date\",\"type\":{\"type\":\"long\",\"CustomEncoding\":\"DateAsLongEncoding\"}}]}");
    }

    @Test
    public void testAvroEncodeIO() throws IOException {
        Schema schm = ReflectData.get().getSchema(AvroEncRecord.class);
        ReflectDatumWriter writer = new ReflectDatumWriter(schm);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        AvroEncRecord record = new AvroEncRecord();
        record.date = new Date(948833323L);
        writer.write((Object)record, (Encoder)this.factory.directBinaryEncoder((OutputStream)out, null));
        ReflectDatumReader reader = new ReflectDatumReader(schm);
        AvroEncRecord decoded = (AvroEncRecord)reader.read((Object)new AvroEncRecord(), (Decoder)DecoderFactory.get().binaryDecoder(out.toByteArray(), null));
        Assert.assertEquals((Object)record, (Object)decoded);
    }

    @Test
    public void testRecordWithNullIO() throws IOException {
        ReflectData.AllowNull reflectData = ReflectData.AllowNull.get();
        Schema schm = reflectData.getSchema(SampleRecord.AnotherSampleRecord.class);
        ReflectDatumWriter writer = new ReflectDatumWriter(schm);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        BinaryEncoder e = this.factory.directBinaryEncoder((OutputStream)out, null);
        SampleRecord.AnotherSampleRecord a = new SampleRecord.AnotherSampleRecord();
        writer.write((Object)a, (Encoder)e);
        SampleRecord.AnotherSampleRecord b = new SampleRecord.AnotherSampleRecord(10);
        writer.write((Object)b, (Encoder)e);
        e.flush();
        ReflectDatumReader reader = new ReflectDatumReader(schm);
        ByteArrayInputStream in = new ByteArrayInputStream(out.toByteArray());
        BinaryDecoder d = DecoderFactory.get().binaryDecoder((InputStream)in, null);
        SampleRecord.AnotherSampleRecord decoded = (SampleRecord.AnotherSampleRecord)reader.read(null, (Decoder)d);
        Assert.assertEquals((Object)a, (Object)decoded);
        decoded = (SampleRecord.AnotherSampleRecord)reader.read(null, (Decoder)d);
        Assert.assertEquals((Object)b, (Object)decoded);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDisableUnsafe() throws Exception {
        String saved = System.getProperty("avro.disable.unsafe");
        try {
            System.setProperty("avro.disable.unsafe", "true");
            ReflectData.ACCESSOR_CACHE.clear();
            ReflectionUtil.resetFieldAccess();
            this.testMultipleAnnotations();
            this.testRecordWithNullIO();
        }
        finally {
            if (saved == null) {
                System.clearProperty("avro.disable.unsafe");
            } else {
                System.setProperty("avro.disable.unsafe", saved);
            }
            ReflectData.ACCESSOR_CACHE.clear();
            ReflectionUtil.resetFieldAccess();
        }
    }

    @Test
    public void testForwardReference() {
        ReflectData data = ReflectData.get();
        Protocol reflected = data.getProtocol(C.class);
        Protocol reparsed = Protocol.parse((String)reflected.toString());
        Assert.assertEquals((Object)reflected, (Object)reparsed);
        assert (reparsed.getTypes().contains(data.getSchema(A.class)));
        assert (reparsed.getTypes().contains(data.getSchema(B1.class)));
        assert (reparsed.getTypes().contains(data.getSchema(B2.class)));
        assert (reparsed.getTypes().contains(data.getSchema(X.class)));
    }

    @Test(expected=AvroTypeException.class)
    public void testOverloadedMethod() {
        ReflectData.get().getProtocol(P3.class);
    }

    @Test
    public void testNoPackageSchema() throws Exception {
        ReflectData.get().getSchema(Class.forName("NoPackage"));
    }

    @Test
    public void testNoPackageProtocol() throws Exception {
        ReflectData.get().getProtocol(Class.forName("NoPackage"));
    }

    @Test
    public void testReflectWithinGeneric() throws Exception {
        ReflectData data = ReflectData.get();
        Schema schema = Schema.createRecord((String)"Foo", (String)"", (String)"x.y.z", (boolean)false);
        ArrayList<Schema.Field> fields = new ArrayList<Schema.Field>();
        fields.add(new Schema.Field("f", data.getSchema(Y.class), "", null));
        schema.setFields(fields);
        Y y = new Y();
        y.i = 1;
        GenericData.Record record = new GenericData.Record(schema);
        record.put("f", (Object)y);
        TestReflect.checkBinary(schema, record);
    }

    @Test
    public void testPrimitiveArray() throws Exception {
        this.testPrimitiveArrays(false);
    }

    @Test
    public void testPrimitiveArrayBlocking() throws Exception {
        this.testPrimitiveArrays(true);
    }

    private void testPrimitiveArrays(boolean blocking) throws Exception {
        this.testPrimitiveArray(Boolean.TYPE, blocking);
        this.testPrimitiveArray(Byte.TYPE, blocking);
        this.testPrimitiveArray(Short.TYPE, blocking);
        this.testPrimitiveArray(Character.TYPE, blocking);
        this.testPrimitiveArray(Integer.TYPE, blocking);
        this.testPrimitiveArray(Long.TYPE, blocking);
        this.testPrimitiveArray(Float.TYPE, blocking);
        this.testPrimitiveArray(Double.TYPE, blocking);
    }

    private void testPrimitiveArray(Class<?> c, boolean blocking) throws Exception {
        ReflectData data = new ReflectData();
        Random r = new Random();
        int size = 200;
        Object array = Array.newInstance(c, size);
        Schema s = data.getSchema(array.getClass());
        for (int i = 0; i < size; ++i) {
            Array.set(array, i, this.randomFor(c, r));
        }
        TestReflect.checkBinary(data, s, array, false, blocking);
    }

    private Object randomFor(Class<?> c, Random r) {
        if (c == Boolean.TYPE) {
            return r.nextBoolean();
        }
        if (c == Integer.TYPE) {
            return r.nextInt();
        }
        if (c == Long.TYPE) {
            return r.nextLong();
        }
        if (c == Byte.TYPE) {
            return (byte)r.nextInt();
        }
        if (c == Float.TYPE) {
            return Float.valueOf(r.nextFloat());
        }
        if (c == Double.TYPE) {
            return r.nextDouble();
        }
        if (c == Character.TYPE) {
            return Character.valueOf((char)r.nextInt());
        }
        if (c == Short.TYPE) {
            return (short)r.nextInt();
        }
        return null;
    }

    @Test
    public void testNullArray() throws Exception {
        String json = "[{\"type\":\"array\", \"items\": \"long\"}, \"null\"]";
        Schema schema = new Schema.Parser().parse(json);
        TestReflect.checkBinary(schema, null);
    }

    @Test
    public void testStringables() throws Exception {
        this.checkStringable(BigDecimal.class, "10");
        this.checkStringable(BigInteger.class, "20");
        this.checkStringable(URI.class, "foo://bar:9000/baz");
        this.checkStringable(URL.class, "http://bar:9000/baz");
        this.checkStringable(File.class, "foo.bar");
    }

    public void checkStringable(Class c, String value) throws Exception {
        ReflectData data = new ReflectData();
        Schema schema = data.getSchema((Type)c);
        Assert.assertEquals((Object)("{\"type\":\"string\",\"java-class\":\"" + c.getName() + "\"}"), (Object)schema.toString());
        TestReflect.checkBinary(schema, c.getConstructor(String.class).newInstance(value));
    }

    @Test
    public void testStringableMapKeys() throws Exception {
        M1 record = new M1();
        record.integerKeyMap = new HashMap<Integer, String>(1);
        record.integerKeyMap.put(10, "foo");
        record.bigIntegerKeyMap = new HashMap<BigInteger, String>(1);
        record.bigIntegerKeyMap.put(BigInteger.TEN, "bar");
        record.bigDecimalKeyMap = new HashMap<BigDecimal, String>(1);
        record.bigDecimalKeyMap.put(BigDecimal.ONE, "bigDecimal");
        record.fileKeyMap = new HashMap<File, String>(1);
        record.fileKeyMap.put(new File("foo.bar"), "file");
        ReflectData data = new ReflectData().addStringable(Integer.class);
        TestReflect.checkBinary(data, data.getSchema(M1.class), record, true);
    }

    @Test
    public void testNullableStringableField() throws Exception {
        NullableStringable datum = new NullableStringable();
        datum.number = BigDecimal.TEN;
        Schema schema = ReflectData.AllowNull.get().getSchema(NullableStringable.class);
        TestReflect.checkBinary(schema, datum);
    }

    public static void checkBinary(ReflectData reflectData, Schema schema, Object datum, boolean equals) throws IOException {
        TestReflect.checkBinary(reflectData, schema, datum, equals, false);
    }

    private static void checkBinary(ReflectData reflectData, Schema schema, Object datum, boolean equals, boolean blocking) throws IOException {
        ReflectDatumWriter writer = new ReflectDatumWriter(schema);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        if (!blocking) {
            writer.write(datum, (Encoder)EncoderFactory.get().directBinaryEncoder((OutputStream)out, null));
        } else {
            writer.write(datum, (Encoder)new EncoderFactory().configureBlockSize(64).blockingBinaryEncoder((OutputStream)out, null));
        }
        writer.write(datum, (Encoder)EncoderFactory.get().directBinaryEncoder((OutputStream)out, null));
        byte[] data = out.toByteArray();
        ReflectDatumReader reader = new ReflectDatumReader(schema);
        Object decoded = reader.read(null, (Decoder)DecoderFactory.get().binaryDecoder(data, null));
        Assert.assertEquals((long)0L, (long)reflectData.compare(datum, decoded, schema, equals));
    }

    public static void checkBinary(Schema schema, Object datum) throws IOException {
        TestReflect.checkBinary(ReflectData.get(), schema, datum, false);
    }

    @Test
    public void testReflectFieldError() throws Exception {
        String datum = "";
        try {
            ReflectData.get().getField((Object)datum, "notAFieldOfString", 0);
        }
        catch (AvroRuntimeException e) {
            Assert.assertTrue((boolean)e.getMessage().contains(datum.getClass().getName()));
        }
    }

    @Test
    public void testAvroAlias() {
        this.check((Type)((Object)AliasA.class), "{\"type\":\"record\",\"name\":\"AliasA\",\"namespace\":\"org.apache.avro.reflect.TestReflect$\",\"fields\":[],\"aliases\":[\"b.a\"]}");
        this.check((Type)((Object)AliasB.class), "{\"type\":\"record\",\"name\":\"AliasB\",\"namespace\":\"org.apache.avro.reflect.TestReflect$\",\"fields\":[],\"aliases\":[\"a\"]}");
        this.check((Type)((Object)AliasC.class), "{\"type\":\"record\",\"name\":\"AliasC\",\"namespace\":\"org.apache.avro.reflect.TestReflect$\",\"fields\":[],\"aliases\":[\"a\"]}");
    }

    @Test
    public void testAvroDefault() {
        this.check((Type)((Object)DefaultTest.class), "{\"type\":\"record\",\"name\":\"DefaultTest\",\"namespace\":\"org.apache.avro.reflect.TestReflect$\",\"fields\":[{\"name\":\"foo\",\"type\":\"int\",\"default\":1}]}");
    }

    private static class DefaultTest {
        @AvroDefault(value="1")
        int foo;
        public static final String __PARANAMER_DATA = "";

        private DefaultTest() {
        }
    }

    @AvroAlias(alias="a")
    private static class AliasC {
        public static final String __PARANAMER_DATA = "";

        private AliasC() {
        }
    }

    @AvroAlias(alias="a", space="")
    private static class AliasB {
        public static final String __PARANAMER_DATA = "";

        private AliasB() {
        }
    }

    @AvroAlias(alias="a", space="b")
    private static class AliasA {
        public static final String __PARANAMER_DATA = "";

        private AliasA() {
        }
    }

    public static class NullableStringable {
        BigDecimal number;
        public static final String __PARANAMER_DATA = "";
    }

    public static class M1 {
        Map<Integer, String> integerKeyMap;
        Map<BigInteger, String> bigIntegerKeyMap;
        Map<BigDecimal, String> bigDecimalKeyMap;
        Map<File, String> fileKeyMap;
        public static final String __PARANAMER_DATA = "";
    }

    public static class Y {
        int i;
        public static final String __PARANAMER_DATA = "";
    }

    public static interface P3 {
        public static final String __PARANAMER_DATA = "m1 int x \n";

        public void m1();

        public void m1(int var1);
    }

    public static interface C {
        public static final String __PARANAMER_DATA = "foo org.apache.avro.reflect.TestReflect$A a \n";

        public void foo(A var1);
    }

    public static class A {
        B1 b1;
        B2 b2;
        public static final String __PARANAMER_DATA = "";
    }

    public static class B2 {
        X x;
        public static final String __PARANAMER_DATA = "";
    }

    public static class B1 {
        X x;
        public static final String __PARANAMER_DATA = "";
    }

    public static class X {
        int i;
        public static final String __PARANAMER_DATA = "";
    }

    public static class SampleRecord {
        public int x = 1;
        private int y = 2;
        public static final String __PARANAMER_DATA = "equals java.lang.Object obj \n";

        public int hashCode() {
            return this.x + this.y;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            SampleRecord other = (SampleRecord)obj;
            if (this.x != other.x) {
                return false;
            }
            return this.y == other.y;
        }

        public static class AnotherSampleRecord {
            private Integer a = null;
            private SampleRecord s = null;
            public static final String __PARANAMER_DATA = "<init> java.lang.Integer a \nequals java.lang.Object other \n";

            public AnotherSampleRecord() {
            }

            AnotherSampleRecord(Integer a) {
                this.a = a;
                this.s = new SampleRecord();
            }

            public int hashCode() {
                int hash = this.a != null ? this.a.hashCode() : 0;
                return hash += this.s != null ? this.s.hashCode() : 0;
            }

            public boolean equals(Object other) {
                if (other instanceof AnotherSampleRecord) {
                    AnotherSampleRecord o = (AnotherSampleRecord)other;
                    return !(this.a == null && o.a != null || this.a != null && !this.a.equals(o.a) || this.s == null && o.s != null) && (this.s == null || this.s.equals(o.s));
                }
                return false;
            }
        }
    }

    public static class multipleAnnotationRecord {
        @AvroIgnore
        @Stringable
        Integer i1;
        @AvroIgnore
        @Nullable
        Integer i2;
        @AvroIgnore
        @AvroName(value="j")
        Integer i3;
        @AvroIgnore
        @AvroEncode(using=DateAsLongEncoding.class)
        Date i4;
        @Stringable
        @Nullable
        Integer i5;
        @Stringable
        @AvroName(value="j6")
        Integer i6 = 6;
        @Stringable
        @AvroEncode(using=DateAsLongEncoding.class)
        Date i7 = new Date(7L);
        @Nullable
        @AvroName(value="j8")
        Integer i8;
        @Nullable
        @AvroEncode(using=DateAsLongEncoding.class)
        Date i9;
        @AvroName(value="j10")
        @AvroEncode(using=DateAsLongEncoding.class)
        Date i10 = new Date(10L);
        @Stringable
        @Nullable
        @AvroName(value="j11")
        @AvroEncode(using=DateAsLongEncoding.class)
        Date i11;
        public static final String __PARANAMER_DATA = "";
    }

    public static class AvroEncRecord {
        @AvroEncode(using=DateAsLongEncoding.class)
        Date date;
        public static final String __PARANAMER_DATA = "equals java.lang.Object o \n";

        public boolean equals(Object o) {
            if (!(o instanceof AvroEncRecord)) {
                return false;
            }
            return this.date.equals(((AvroEncRecord)o).date);
        }
    }

    public static class RAvroStringableField {
        @Stringable
        int a;
        public static final String __PARANAMER_DATA = "";
    }

    public static class RAvroNameCollide {
        @AvroName(value="b")
        int a;
        int b;
        public static final String __PARANAMER_DATA = "";
    }

    public static class RAvroName {
        @AvroName(value="b")
        int a;
        public static final String __PARANAMER_DATA = "";
    }

    public static class RAvroMeta {
        @AvroMeta(key="K", value="V")
        int a;
        public static final String __PARANAMER_DATA = "";
    }

    public static class RAvroIgnore {
        @AvroIgnore
        int a;
        public static final String __PARANAMER_DATA = "";
    }

    public static class R {
        int a;
        long b;
        public static final String __PARANAMER_DATA = "";
    }

    public static enum E {
        A,
        B;

        public static final String __PARANAMER_DATA = "";
    }

    public static interface P2 {
        public static final String __PARANAMER_DATA = "";

        public void error() throws E1;
    }

    public static class E1
    extends Exception {
        public static final String __PARANAMER_DATA = "";
    }

    public static interface P4 {
        public static final String __PARANAMER_DATA = "foo java.lang.Object x \n";

        @AvroSchema(value="\"int\"")
        public Object foo(@AvroSchema(value="\"int\"") Object var1);
    }

    @AvroSchema(value="\"null\"")
    public class R13 {
        public static final String __PARANAMER_DATA = "";
    }

    public static class R12 {
        @AvroSchema(value="\"int\"")
        Object x;
        @AvroSchema(value="{\"type\":\"array\",\"items\":[\"null\",\"string\"]}")
        List<String> strings;
        public static final String __PARANAMER_DATA = "";
    }

    public static interface P1 {
        public static final String __PARANAMER_DATA = "foo java.lang.String s \n";

        @Nullable
        public String foo(@Nullable String var1);
    }

    public static class R11 {
        @Nullable
        private String text;
        public static final String __PARANAMER_DATA = "equals java.lang.Object o \n";

        public boolean equals(Object o) {
            if (!(o instanceof R11)) {
                return false;
            }
            R11 that = (R11)o;
            if (this.text == null) {
                return that.text == null;
            }
            return this.text.equals(that.text);
        }
    }

    @Stringable
    public static class R10 {
        private String text;
        public static final String __PARANAMER_DATA = "<init> java.lang.String text \nequals java.lang.Object o \n";

        public R10(String text) {
            this.text = text;
        }

        public String toString() {
            return this.text;
        }

        public boolean equals(Object o) {
            if (!(o instanceof R10)) {
                return false;
            }
            return this.text.equals(((R10)o).text);
        }
    }

    public static interface P0 {
        public static final String __PARANAMER_DATA = "foo java.lang.String s \n";

        @Union(value={Void.class, String.class})
        public String foo(@Union(value={Void.class, String.class}) String var1);
    }

    public static class R9 {
        public R6[] r6s;
        public static final String __PARANAMER_DATA = "equals java.lang.Object o \n";

        public boolean equals(Object o) {
            if (!(o instanceof R9)) {
                return false;
            }
            return Arrays.equals(this.r6s, ((R9)o).r6s);
        }
    }

    public static class R8
    extends R6 {
        public float value;
        public static final String __PARANAMER_DATA = "equals java.lang.Object o \n";

        public boolean equals(Object o) {
            if (!(o instanceof R8)) {
                return false;
            }
            return this.value == ((R8)o).value;
        }
    }

    public static class R7
    extends R6 {
        public int value;
        public static final String __PARANAMER_DATA = "equals java.lang.Object o \n";

        public boolean equals(Object o) {
            if (!(o instanceof R7)) {
                return false;
            }
            return this.value == ((R7)o).value;
        }
    }

    @Union(value={R7.class, R8.class})
    public static class R6 {
        public static final String __PARANAMER_DATA = "";
    }

    public static class R5
    extends R4 {
        public static final String __PARANAMER_DATA = "";
    }

    public static class R4 {
        public short value;
        public short[] shorts;
        public byte b;
        public char c;
        public static final String __PARANAMER_DATA = "equals java.lang.Object o \n";

        public boolean equals(Object o) {
            if (!(o instanceof R4)) {
                return false;
            }
            R4 that = (R4)o;
            return this.value == that.value && Arrays.equals(this.shorts, that.shorts) && this.b == that.b && this.c == that.c;
        }
    }

    public static class R3 {
        private int[] intArray;
        public static final String __PARANAMER_DATA = "equals java.lang.Object o \n";

        public boolean equals(Object o) {
            if (!(o instanceof R3)) {
                return false;
            }
            R3 that = (R3)o;
            return Arrays.equals(this.intArray, that.intArray);
        }

        static /* synthetic */ int[] access$202(R3 x0, int[] x1) {
            x0.intArray = x1;
            return x1;
        }
    }

    public static class R2 {
        private String[] arrayField;
        private Collection<String> collectionField;
        public static final String __PARANAMER_DATA = "equals java.lang.Object o \n";

        public boolean equals(Object o) {
            if (!(o instanceof R2)) {
                return false;
            }
            R2 that = (R2)o;
            return Arrays.equals(this.arrayField, that.arrayField) && this.collectionField.equals(that.collectionField);
        }

        static /* synthetic */ String[] access$002(R2 x0, String[] x1) {
            x0.arrayField = x1;
            return x1;
        }
    }

    public static class R1 {
        private Map<String, String> mapField = new HashMap<String, String>();
        private String[] arrayField = new String[]{"foo"};
        private List<String> listField = new ArrayList<String>();
        public static final String __PARANAMER_DATA = "equals java.lang.Object o \n";

        public R1() {
            this.mapField.put("foo", "bar");
            this.listField.add("foo");
        }

        public boolean equals(Object o) {
            if (!(o instanceof R1)) {
                return false;
            }
            R1 that = (R1)o;
            return this.mapField.equals(that.mapField) && Arrays.equals(this.arrayField, that.arrayField) && this.listField.equals(that.listField);
        }
    }
}

