/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.reflect;

import java.util.Arrays;
import org.apache.avro.Schema;
import org.apache.avro.reflect.AvroSchema;
import org.apache.avro.reflect.Nullable;
import org.apache.avro.reflect.ReflectData;
import org.junit.Assert;
import org.junit.Test;

public class TestReflectAllowNulls {
    public static final String __PARANAMER_DATA = "";

    @Test
    public void testPrimitives() {
        Schema primitives = ReflectData.AllowNull.get().getSchema(Primitives.class);
        Assert.assertEquals((Object)this.requiredSchema(Boolean.TYPE), (Object)primitives.getField("aBoolean").schema());
        Assert.assertEquals((Object)this.requiredSchema(Byte.TYPE), (Object)primitives.getField("aByte").schema());
        Assert.assertEquals((Object)this.requiredSchema(Short.TYPE), (Object)primitives.getField("aShort").schema());
        Assert.assertEquals((Object)this.requiredSchema(Integer.TYPE), (Object)primitives.getField("anInt").schema());
        Assert.assertEquals((Object)this.requiredSchema(Long.TYPE), (Object)primitives.getField("aLong").schema());
        Assert.assertEquals((Object)this.requiredSchema(Float.TYPE), (Object)primitives.getField("aFloat").schema());
        Assert.assertEquals((Object)this.requiredSchema(Double.TYPE), (Object)primitives.getField("aDouble").schema());
    }

    @Test
    public void testWrappers() {
        Schema wrappers = ReflectData.AllowNull.get().getSchema(Wrappers.class);
        Assert.assertEquals((Object)this.nullableSchema(Boolean.TYPE), (Object)wrappers.getField("aBoolean").schema());
        Assert.assertEquals((Object)this.nullableSchema(Byte.TYPE), (Object)wrappers.getField("aByte").schema());
        Assert.assertEquals((Object)this.nullableSchema(Short.TYPE), (Object)wrappers.getField("aShort").schema());
        Assert.assertEquals((Object)this.nullableSchema(Integer.TYPE), (Object)wrappers.getField("anInt").schema());
        Assert.assertEquals((Object)this.nullableSchema(Long.TYPE), (Object)wrappers.getField("aLong").schema());
        Assert.assertEquals((Object)this.nullableSchema(Float.TYPE), (Object)wrappers.getField("aFloat").schema());
        Assert.assertEquals((Object)this.nullableSchema(Double.TYPE), (Object)wrappers.getField("aDouble").schema());
        Assert.assertEquals((Object)this.nullableSchema(Primitives.class), (Object)wrappers.getField("anObject").schema());
    }

    @Test
    public void testAllowNullWithNullableAnnotation() {
        Schema withNullable = ReflectData.AllowNull.get().getSchema(AllowNullWithNullable.class);
        Assert.assertEquals((String)"Should produce a nullable double", (Object)this.nullableSchema(Double.TYPE), (Object)withNullable.getField("aDouble").schema());
        Schema nullableDoubleOrLong = Schema.createUnion(Arrays.asList(Schema.create((Schema.Type)Schema.Type.NULL), Schema.create((Schema.Type)Schema.Type.DOUBLE), Schema.create((Schema.Type)Schema.Type.LONG)));
        Assert.assertEquals((String)"Should add null to a non-null union", (Object)nullableDoubleOrLong, (Object)withNullable.getField("doubleOrLong").schema());
        Assert.assertEquals((String)"Should add null to a non-null union", (Object)nullableDoubleOrLong, (Object)withNullable.getField("doubleOrLongOrNull1").schema());
        Schema doubleOrLongOrNull = Schema.createUnion(Arrays.asList(Schema.create((Schema.Type)Schema.Type.DOUBLE), Schema.create((Schema.Type)Schema.Type.LONG), Schema.create((Schema.Type)Schema.Type.NULL)));
        Assert.assertEquals((String)"Should add null to a non-null union", (Object)doubleOrLongOrNull, (Object)withNullable.getField("doubleOrLongOrNull2").schema());
        Assert.assertEquals((String)"Should add null to a non-null union", (Object)doubleOrLongOrNull, (Object)withNullable.getField("doubleOrLongOrNull3").schema());
    }

    private Schema requiredSchema(Class<?> type) {
        return ReflectData.get().getSchema(type);
    }

    private Schema nullableSchema(Class<?> type) {
        return Schema.createUnion(Arrays.asList(Schema.create((Schema.Type)Schema.Type.NULL), ReflectData.get().getSchema(type)));
    }

    private static class AllowNullWithNullable {
        @Nullable
        Double aDouble;
        @AvroSchema(value="[\"double\", \"long\"]")
        Object doubleOrLong;
        @Nullable
        @AvroSchema(value="[\"double\", \"long\"]")
        Object doubleOrLongOrNull1;
        @AvroSchema(value="[\"double\", \"long\", \"null\"]")
        Object doubleOrLongOrNull2;
        @Nullable
        @AvroSchema(value="[\"double\", \"long\", \"null\"]")
        Object doubleOrLongOrNull3;
        public static final String __PARANAMER_DATA = "";

        private AllowNullWithNullable() {
        }
    }

    private static class Wrappers {
        Boolean aBoolean;
        Byte aByte;
        Short aShort;
        Integer anInt;
        Long aLong;
        Float aFloat;
        Double aDouble;
        Primitives anObject;
        public static final String __PARANAMER_DATA = "";

        private Wrappers() {
        }
    }

    private static class Primitives {
        boolean aBoolean;
        byte aByte;
        short aShort;
        int anInt;
        long aLong;
        float aFloat;
        double aDouble;
        public static final String __PARANAMER_DATA = "";

        private Primitives() {
        }
    }
}

