/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.reflect;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.List;
import org.apache.avro.io.BinaryDecoder;
import org.apache.avro.io.BinaryEncoder;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.DecoderFactory;
import org.apache.avro.io.Encoder;
import org.apache.avro.io.EncoderFactory;
import org.apache.avro.reflect.ReflectDatumReader;
import org.apache.avro.reflect.ReflectDatumWriter;
import org.junit.Assert;
import org.junit.Test;

public class TestReflectDatumReader {
    public static final String __PARANAMER_DATA = "";

    private static <T> byte[] serializeWithReflectDatumWriter(T toSerialize, Class<T> toSerializeClass) throws IOException {
        ReflectDatumWriter datumWriter = new ReflectDatumWriter(toSerializeClass);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        BinaryEncoder encoder = EncoderFactory.get().binaryEncoder((OutputStream)byteArrayOutputStream, null);
        datumWriter.write(toSerialize, (Encoder)encoder);
        encoder.flush();
        return byteArrayOutputStream.toByteArray();
    }

    @Test
    public void testRead_PojoWithList() throws IOException {
        PojoWithList pojoWithList = new PojoWithList();
        pojoWithList.setId(42);
        pojoWithList.setRelatedIds(Arrays.asList(1, 2, 3));
        byte[] serializedBytes = TestReflectDatumReader.serializeWithReflectDatumWriter(pojoWithList, PojoWithList.class);
        BinaryDecoder decoder = DecoderFactory.get().binaryDecoder(serializedBytes, null);
        ReflectDatumReader reflectDatumReader = new ReflectDatumReader(PojoWithList.class);
        PojoWithList deserialized = new PojoWithList();
        reflectDatumReader.read((Object)deserialized, (Decoder)decoder);
        Assert.assertEquals((Object)pojoWithList, (Object)deserialized);
    }

    @Test
    public void testRead_PojoWithArray() throws IOException {
        PojoWithArray pojoWithArray = new PojoWithArray();
        pojoWithArray.setId(42);
        pojoWithArray.setRelatedIds(new int[]{1, 2, 3});
        byte[] serializedBytes = TestReflectDatumReader.serializeWithReflectDatumWriter(pojoWithArray, PojoWithArray.class);
        BinaryDecoder decoder = DecoderFactory.get().binaryDecoder(serializedBytes, null);
        ReflectDatumReader reflectDatumReader = new ReflectDatumReader(PojoWithArray.class);
        PojoWithArray deserialized = new PojoWithArray();
        reflectDatumReader.read((Object)deserialized, (Decoder)decoder);
        Assert.assertEquals((Object)pojoWithArray, (Object)deserialized);
    }

    public static class PojoWithArray {
        private int id;
        private int[] relatedIds;
        public static final String __PARANAMER_DATA = "equals java.lang.Object obj \nsetId int id \nsetRelatedIds int[] relatedIds \n";

        public int getId() {
            return this.id;
        }

        public void setId(int id) {
            this.id = id;
        }

        public int[] getRelatedIds() {
            return this.relatedIds;
        }

        public void setRelatedIds(int[] relatedIds) {
            this.relatedIds = relatedIds;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.id;
            result = 31 * result + Arrays.hashCode(this.relatedIds);
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            PojoWithArray other = (PojoWithArray)obj;
            if (this.id != other.id) {
                return false;
            }
            return Arrays.equals(this.relatedIds, other.relatedIds);
        }
    }

    public static class PojoWithList {
        private int id;
        private List<Integer> relatedIds;
        public static final String __PARANAMER_DATA = "equals java.lang.Object obj \nsetId int id \nsetRelatedIds java.util.List relatedIds \n";

        public int getId() {
            return this.id;
        }

        public void setId(int id) {
            this.id = id;
        }

        public List<Integer> getRelatedIds() {
            return this.relatedIds;
        }

        public void setRelatedIds(List<Integer> relatedIds) {
            this.relatedIds = relatedIds;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.id;
            result = 31 * result + (this.relatedIds == null ? 0 : this.relatedIds.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            PojoWithList other = (PojoWithList)obj;
            if (this.id != other.id) {
                return false;
            }
            return !(this.relatedIds == null ? other.relatedIds != null : !this.relatedIds.equals(other.relatedIds));
        }
    }
}

