/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.reflect;

import java.io.IOException;
import java.io.InputStream;
import org.apache.avro.reflect.ReflectionUtil;
import org.junit.Test;

public class TestReflectionUtil {
    public static final String __PARANAMER_DATA = "";

    @Test
    public void testUnsafeUtil() {
        new Tester().checkUnsafe();
    }

    @Test
    public void testUnsafeWhenNotExists() throws Exception {
        NoUnsafe cl = new NoUnsafe();
        Class<?> testerClass = ((ClassLoader)cl).loadClass(Tester.class.getName());
        testerClass.getDeclaredMethod("checkUnsafe", new Class[0]).invoke(testerClass.newInstance(), new Object[0]);
    }

    private static final class NoUnsafe
    extends ClassLoader {
        private ClassLoader parent = TestReflectionUtil.class.getClassLoader();
        public static final String __PARANAMER_DATA = "loadClass java.lang.String name \n";

        private NoUnsafe() {
        }

        @Override
        public Class<?> loadClass(String name) throws ClassNotFoundException {
            int size;
            Class<?> clazz = this.findLoadedClass(name);
            if (clazz != null) {
                return clazz;
            }
            if ("sun.misc.Unsafe".equals(name)) {
                throw new ClassNotFoundException(name);
            }
            if (!name.startsWith("org.apache.avro.")) {
                return this.parent.loadClass(name);
            }
            InputStream data = this.parent.getResourceAsStream(name.replace('.', '/') + ".class");
            byte[] buf = new byte[10240];
            try {
                size = data.read(buf);
            }
            catch (IOException e) {
                throw new ClassNotFoundException();
            }
            clazz = this.defineClass(name, buf, 0, size);
            this.resolveClass(clazz);
            return clazz;
        }
    }

    public static final class Tester {
        public static final String __PARANAMER_DATA = "";

        public void checkUnsafe() {
            ReflectionUtil.getFieldAccess();
        }
    }
}

