/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.specific;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.avro.io.BinaryEncoder;
import org.apache.avro.io.Encoder;
import org.apache.avro.io.EncoderFactory;
import org.apache.avro.specific.SpecificData;
import org.apache.avro.specific.SpecificDatumWriter;
import org.apache.avro.specific.SpecificRecordBase;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestSpecificData {
    private Class<?> intClass;
    private Class<?> integerClass;
    public static final String __PARANAMER_DATA = "";

    @Before
    public void setUp() {
        Schema intSchema = Schema.create((Schema.Type)Schema.Type.INT);
        this.intClass = SpecificData.get().getClass(intSchema);
        Schema nullSchema = Schema.create((Schema.Type)Schema.Type.NULL);
        Schema nullIntUnionSchema = Schema.createUnion(Arrays.asList(nullSchema, intSchema));
        this.integerClass = SpecificData.get().getClass(nullIntUnionSchema);
    }

    @Test
    public void testClassTypes() {
        Assert.assertTrue((boolean)this.intClass.isPrimitive());
        Assert.assertFalse((boolean)this.integerClass.isPrimitive());
    }

    @Test
    public void testPrimitiveParam() throws Exception {
        Assert.assertNotNull((Object)Reflection.class.getMethod("primitive", this.intClass));
    }

    @Test(expected=NoSuchMethodException.class)
    public void testPrimitiveParamError() throws Exception {
        Reflection.class.getMethod("primitiveWrapper", this.intClass);
    }

    @Test
    public void testPrimitiveWrapperParam() throws Exception {
        Assert.assertNotNull((Object)Reflection.class.getMethod("primitiveWrapper", this.integerClass));
    }

    @Test(expected=NoSuchMethodException.class)
    public void testPrimitiveWrapperParamError() throws Exception {
        Reflection.class.getMethod("primitive", this.integerClass);
    }

    @Test
    public void testSpecificRecordBase() {
        TestRecord record = new TestRecord();
        record.put("x", 1);
        record.put("y", "str");
        Assert.assertEquals((Object)1, (Object)record.get("x"));
        Assert.assertEquals((Object)"str", (Object)record.get("y"));
    }

    @Test
    public void testExternalizeable() throws Exception {
        TestRecord before = new TestRecord();
        before.put("x", 1);
        before.put("y", "str");
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        ObjectOutputStream out = new ObjectOutputStream(bytes);
        out.writeObject((Object)before);
        out.close();
        ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(bytes.toByteArray()));
        TestRecord after = (TestRecord)((Object)in.readObject());
        Assert.assertEquals((Object)((Object)before), (Object)((Object)after));
    }

    @Test
    public void testNonStringable() throws Exception {
        Schema string = Schema.create((Schema.Type)Schema.Type.STRING);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        BinaryEncoder encoder = EncoderFactory.get().directBinaryEncoder((OutputStream)baos, null);
        SpecificDatumWriter writer = new SpecificDatumWriter(string);
        try {
            writer.write(new Object(), (Encoder)encoder);
            Assert.fail((String)"Non stringable object should be rejected.");
        }
        catch (ClassCastException cce) {
            // empty catch block
        }
    }

    public static class TestRecord
    extends SpecificRecordBase {
        private static final Schema SCHEMA = Schema.createRecord((String)"TestRecord", null, null, (boolean)false);
        private int x;
        private String y;
        public static final String __PARANAMER_DATA = "get int i \nput int,java.lang.Object i,v \n";

        public void put(int i, Object v) {
            switch (i) {
                case 0: {
                    this.x = (Integer)v;
                    break;
                }
                case 1: {
                    this.y = (String)v;
                    break;
                }
                default: {
                    throw new RuntimeException();
                }
            }
        }

        public Object get(int i) {
            switch (i) {
                case 0: {
                    return this.x;
                }
                case 1: {
                    return this.y;
                }
            }
            throw new RuntimeException();
        }

        public Schema getSchema() {
            return SCHEMA;
        }

        static {
            ArrayList<Schema.Field> fields = new ArrayList<Schema.Field>();
            fields.add(new Schema.Field("x", Schema.create((Schema.Type)Schema.Type.INT), null, null));
            Schema stringSchema = Schema.create((Schema.Type)Schema.Type.STRING);
            GenericData.setStringType((Schema)stringSchema, (GenericData.StringType)GenericData.StringType.String);
            fields.add(new Schema.Field("y", stringSchema, null, null));
            SCHEMA.setFields(fields);
        }
    }

    static class Reflection {
        public static final String __PARANAMER_DATA = "primitive int i \nprimitiveWrapper java.lang.Integer i \n";

        Reflection() {
        }

        public void primitive(int i) {
        }

        public void primitiveWrapper(Integer i) {
        }
    }
}

