/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.specific;

import java.io.File;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.apache.avro.Conversions;
import org.apache.avro.LogicalType;
import org.apache.avro.LogicalTypes;
import org.apache.avro.Schema;
import org.apache.avro.data.TimeConversions;
import org.apache.avro.file.DataFileReader;
import org.apache.avro.file.DataFileWriter;
import org.apache.avro.io.DatumReader;
import org.apache.avro.io.DatumWriter;
import org.apache.avro.specific.SpecificData;
import org.apache.avro.specific.SpecificRecord;
import org.apache.avro.specific.TestRecordWithLogicalTypes;
import org.apache.avro.specific.TestRecordWithoutLogicalTypes;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.LocalDate;
import org.joda.time.LocalTime;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class TestSpecificLogicalTypes {
    @Rule
    public final TemporaryFolder temp = new TemporaryFolder();
    public static final String __PARANAMER_DATA = "";

    @Test
    public void testRecordWithLogicalTypes() throws IOException {
        TestRecordWithLogicalTypes record = new TestRecordWithLogicalTypes(true, 34, 35L, Float.valueOf(3.14f), 3019.34, null, LocalDate.now(), LocalTime.now(), DateTime.now().withZone(DateTimeZone.UTC), new BigDecimal(123.45f).setScale(2, 5));
        File data = this.write(TestRecordWithLogicalTypes.getClassSchema(), new TestRecordWithLogicalTypes[]{record});
        List actual = this.read(TestRecordWithLogicalTypes.getClassSchema(), data);
        Assert.assertEquals((String)"Should match written record", (Object)((Object)record), actual.get(0));
    }

    @Test
    public void testRecordWithoutLogicalTypes() throws IOException {
        TestRecordWithoutLogicalTypes record = new TestRecordWithoutLogicalTypes(true, 34, 35L, Float.valueOf(3.14f), 3019.34, null, new TimeConversions.DateConversion().toInt(LocalDate.now(), null, null), new TimeConversions.TimeConversion().toInt(LocalTime.now(), null, null), new TimeConversions.TimestampConversion().toLong(DateTime.now().withZone(DateTimeZone.UTC), null, null), new Conversions.DecimalConversion().toBytes(new BigDecimal(123.45f).setScale(2, 5), null, (LogicalType)LogicalTypes.decimal((int)9, (int)2)));
        File data = this.write(TestRecordWithoutLogicalTypes.getClassSchema(), new TestRecordWithoutLogicalTypes[]{record});
        List actual = this.read(TestRecordWithoutLogicalTypes.getClassSchema(), data);
        Assert.assertEquals((String)"Should match written record", (Object)((Object)record), actual.get(0));
    }

    @Test
    public void testRecordWritePrimitivesReadLogicalTypes() throws IOException {
        LocalDate date = LocalDate.now();
        LocalTime time = LocalTime.now();
        DateTime timestamp = DateTime.now().withZone(DateTimeZone.UTC);
        BigDecimal decimal = new BigDecimal(123.45f).setScale(2, 5);
        TestRecordWithoutLogicalTypes record = new TestRecordWithoutLogicalTypes(true, 34, 35L, Float.valueOf(3.14f), 3019.34, null, new TimeConversions.DateConversion().toInt(date, null, null), new TimeConversions.TimeConversion().toInt(time, null, null), new TimeConversions.TimestampConversion().toLong(timestamp, null, null), new Conversions.DecimalConversion().toBytes(decimal, null, (LogicalType)LogicalTypes.decimal((int)9, (int)2)));
        File data = this.write(TestRecordWithoutLogicalTypes.getClassSchema(), new TestRecordWithoutLogicalTypes[]{record});
        List actual = this.read(TestRecordWithLogicalTypes.getClassSchema(), data);
        TestRecordWithLogicalTypes expected = new TestRecordWithLogicalTypes(true, 34, 35L, Float.valueOf(3.14f), 3019.34, null, date, time, timestamp, decimal);
        Assert.assertEquals((String)"Should match written record", (Object)((Object)expected), actual.get(0));
    }

    @Test
    public void testRecordWriteLogicalTypesReadPrimitives() throws IOException {
        LocalDate date = LocalDate.now();
        LocalTime time = LocalTime.now();
        DateTime timestamp = DateTime.now().withZone(DateTimeZone.UTC);
        BigDecimal decimal = new BigDecimal(123.45f).setScale(2, 5);
        TestRecordWithLogicalTypes record = new TestRecordWithLogicalTypes(true, 34, 35L, Float.valueOf(3.14f), 3019.34, null, date, time, timestamp, decimal);
        File data = this.write(TestRecordWithLogicalTypes.getClassSchema(), new TestRecordWithLogicalTypes[]{record});
        List actual = this.read(TestRecordWithoutLogicalTypes.getClassSchema(), data);
        TestRecordWithoutLogicalTypes expected = new TestRecordWithoutLogicalTypes(true, 34, 35L, Float.valueOf(3.14f), 3019.34, null, new TimeConversions.DateConversion().toInt(date, null, null), new TimeConversions.TimeConversion().toInt(time, null, null), new TimeConversions.TimestampConversion().toLong(timestamp, null, null), new Conversions.DecimalConversion().toBytes(decimal, null, (LogicalType)LogicalTypes.decimal((int)9, (int)2)));
        Assert.assertEquals((String)"Should match written record", (Object)((Object)expected), actual.get(0));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <D> List<D> read(Schema schema, File file) throws IOException {
        DatumReader<D> reader = this.newReader(schema);
        ArrayList data = new ArrayList();
        DataFileReader fileReader = null;
        try {
            fileReader = new DataFileReader(file, reader);
            for (Object datum : fileReader) {
                data.add(datum);
            }
        }
        finally {
            if (fileReader != null) {
                fileReader.close();
            }
        }
        return data;
    }

    private <D> DatumReader<D> newReader(Schema schema) {
        return SpecificData.get().createDatumReader(schema);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <D extends SpecificRecord> File write(Schema schema, D ... data) throws IOException {
        File file = this.temp.newFile();
        DatumWriter writer = SpecificData.get().createDatumWriter(schema);
        DataFileWriter fileWriter = new DataFileWriter(writer);
        try {
            fileWriter.create(schema, file);
            for (D datum : data) {
                fileWriter.append(datum);
            }
        }
        finally {
            fileWriter.close();
        }
        return file;
    }
}

