/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CaseFinder {
    private static final String NEW_CASE_NAME = "INPUT";
    private static final String NEW_CASE_MARKER = "<<INPUT";
    private static final String LABEL_REGEX = "[a-zA-Z][_a-zA-Z0-9]*";
    private static final Pattern START_LINE_PATTERN = Pattern.compile("^<<([a-zA-Z][_a-zA-Z0-9]*)(.*)$");
    public static final String __PARANAMER_DATA = "find java.io.BufferedReader,java.lang.String,java.util.List in,label,cases \n";

    public static List<Object[]> find(BufferedReader in, String label, List<Object[]> cases) throws IOException {
        if (!Pattern.matches(LABEL_REGEX, label)) {
            throw new IllegalArgumentException("Bad case subcase label: " + label);
        }
        String subcaseMarker = "<<" + label;
        String line = in.readLine();
        while (true) {
            if (line != null && !line.startsWith(NEW_CASE_MARKER)) {
                line = in.readLine();
                continue;
            }
            if (line == null) break;
            String input = CaseFinder.processHereDoc(in, line);
            if (label.equals(NEW_CASE_NAME)) {
                cases.add(new Object[]{input, null});
                line = in.readLine();
                continue;
            }
            while ((line = in.readLine()) != null && !line.startsWith(NEW_CASE_MARKER) && !line.startsWith(subcaseMarker)) {
            }
            if (line == null || line.startsWith(NEW_CASE_MARKER)) continue;
            String expectedOutput = CaseFinder.processHereDoc(in, line);
            cases.add(new Object[]{input, expectedOutput});
        }
        in.close();
        return cases;
    }

    private static String processHereDoc(BufferedReader in, String docStart) throws IOException {
        Matcher m = START_LINE_PATTERN.matcher(docStart);
        if (!m.matches()) {
            throw new IllegalArgumentException("Wasn't given the start of a heredoc (\"" + docStart + "\")");
        }
        String docName = m.group(1);
        String singleLineText = m.group(2);
        if (singleLineText.length() != 0) {
            if (!singleLineText.startsWith(" ")) {
                throw new IOException("Single-line heredoc missing initial space (\"" + docStart + "\")");
            }
            return singleLineText.substring(1);
        }
        StringBuilder result = new StringBuilder();
        String line = in.readLine();
        String prevLine = "";
        boolean firstTime = true;
        while (line != null && !line.equals(docName)) {
            if (!firstTime) {
                result.append(prevLine).append('\n');
            } else {
                firstTime = false;
            }
            prevLine = line;
            line = in.readLine();
        }
        if (line == null) {
            throw new IOException("Here document (" + docName + ") terminated by end-of-file.");
        }
        return result.append(prevLine).toString();
    }
}

