/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.avro.util.CaseFinder;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.runners.Enclosed;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Enclosed.class)
public class TestCaseFinder {
    public static final String __PARANAMER_DATA = "";

    private static BufferedReader mk(String s) {
        return new BufferedReader(new StringReader(s));
    }

    private static String pr(List<Object[]> t) {
        StringBuilder b = new StringBuilder();
        b.append("{ ");
        boolean firstTime = true;
        for (Object[] p : t) {
            if (!firstTime) {
                b.append(", ");
            } else {
                firstTime = false;
            }
            b.append("{ \"").append(p[0]).append("\", \"").append(p[1]).append("\" }");
        }
        b.append("}");
        return b.toString();
    }

    private static boolean eq(List<Object[]> l1, List<Object[]> l2) {
        if (l1 == null || l2 == null) {
            return l1 == l2;
        }
        if (l1.size() != l2.size()) {
            return false;
        }
        for (int i = 0; i < l1.size(); ++i) {
            if (Arrays.equals(l1.get(i), l2.get(i))) continue;
            return false;
        }
        return true;
    }

    public static class NonParameterized {
        public static final String __PARANAMER_DATA = "";

        @Test(expected=IllegalArgumentException.class)
        public void testBadDocLabel1() throws Exception {
            ArrayList<Object[]> result = new ArrayList<Object[]>();
            CaseFinder.find(TestCaseFinder.mk("<<INPUT blah"), "", result);
        }

        public void testBadDocLabel2() throws Exception {
            ArrayList<Object[]> result = new ArrayList<Object[]>();
            CaseFinder.find(TestCaseFinder.mk("<<INPUT blah"), "kill-er", result);
        }

        @Test(expected=IOException.class)
        public void testBadSingleLineHeredoc() throws Exception {
            ArrayList<Object[]> result = new ArrayList<Object[]>();
            CaseFinder.find(TestCaseFinder.mk("<<INPUTblah"), "foo", result);
        }

        @Test(expected=IOException.class)
        public void testUnterminatedHeredoc() throws Exception {
            ArrayList<Object[]> result = new ArrayList<Object[]>();
            CaseFinder.find(TestCaseFinder.mk("<<INPUT"), "foo", result);
        }
    }

    @RunWith(value=Parameterized.class)
    public static class SimpleCases {
        String input;
        String label;
        List<Object[]> expectedOutput;
        public static final String __PARANAMER_DATA = "<init> java.lang.String,java.lang.String,java.lang.Object[][] input,label,ex \n";

        public SimpleCases(String input, String label, Object[][] ex) {
            this.input = input;
            this.label = label;
            this.expectedOutput = Arrays.asList(ex);
        }

        @Parameterized.Parameters
        public static List<Object[]> cases() {
            ArrayList<Object[]> result = new ArrayList<Object[]>();
            result.add(new Object[]{TestCaseFinder.__PARANAMER_DATA, "foo", new Object[0][]});
            result.add(new Object[]{"<<INPUT a\n<<OUTPUT b", "OUTPUT", new Object[][]{{"a", "b"}}});
            result.add(new Object[]{"<<INPUT a\n<<OUTPUT b\n", "OUTPUT", new Object[][]{{"a", "b"}}});
            result.add(new Object[]{"<<INPUT a\n<<OUTPUT b\n\n", "OUTPUT", new Object[][]{{"a", "b"}}});
            result.add(new Object[]{"<<INPUT a\r<<OUTPUT b", "OUTPUT", new Object[][]{{"a", "b"}}});
            result.add(new Object[]{"// This is a test\n<<INPUT a\n\n\n<<OUTPUT b", "OUTPUT", new Object[][]{{"a", "b"}}});
            result.add(new Object[]{"<<INPUT a\n<<OUTPUT\nb\nOUTPUT", "OUTPUT", new Object[][]{{"a", "b"}}});
            result.add(new Object[]{"<<INPUT a\n<<OUTPUT\nb\nOUTPUT", "OUTPUT", new Object[][]{{"a", "b"}}});
            result.add(new Object[]{"<<INPUT a\n<<OUTPUT\nb\n\nOUTPUT", "OUTPUT", new Object[][]{{"a", "b\n"}}});
            result.add(new Object[]{"<<INPUT a\n<<OUTPUT\n\n  b  \n\nOUTPUT", "OUTPUT", new Object[][]{{"a", "\n  b  \n"}}});
            result.add(new Object[]{"<<INPUT a\n<<O b\n<<INPUT c\n<<O d", "O", new Object[][]{{"a", "b"}, {"c", "d"}}});
            result.add(new Object[]{"<<INPUT a\n<<O b\n<<F z\n<<INPUT c\n<<O d", "O", new Object[][]{{"a", "b"}, {"c", "d"}}});
            result.add(new Object[]{"<<INPUT a\n<<O b\n<<F z\n<<INPUT c\n<<O d", "F", new Object[][]{{"a", "z"}}});
            result.add(new Object[]{"<<INPUT a\n<<O b\n<<F z\n<<INPUT\nc\nINPUT\n<<O d\n<<INPUT e", "INPUT", new Object[][]{{"a", null}, {"c", null}, {"e", null}}});
            return result;
        }

        @Test
        public void testOutput() throws Exception {
            ArrayList<Object[]> result = new ArrayList<Object[]>();
            CaseFinder.find(TestCaseFinder.mk(this.input), this.label, result);
            Assert.assertTrue((String)TestCaseFinder.pr(result), (boolean)TestCaseFinder.eq(result, this.expectedOutput));
        }
    }
}

