/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.util.internal;

import java.util.Collections;
import org.apache.avro.JsonProperties;
import org.apache.avro.Schema;
import org.apache.avro.SchemaBuilder;
import org.apache.avro.util.internal.JacksonUtils;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.node.ArrayNode;
import org.codehaus.jackson.node.BooleanNode;
import org.codehaus.jackson.node.DoubleNode;
import org.codehaus.jackson.node.IntNode;
import org.codehaus.jackson.node.JsonNodeFactory;
import org.codehaus.jackson.node.LongNode;
import org.codehaus.jackson.node.NullNode;
import org.codehaus.jackson.node.ObjectNode;
import org.codehaus.jackson.node.TextNode;
import org.junit.Assert;
import org.junit.Test;

public class TestJacksonUtils {
    public static final String __PARANAMER_DATA = "";

    @Test
    public void testToJsonNode() {
        Assert.assertEquals(null, (Object)JacksonUtils.toJsonNode(null));
        Assert.assertEquals((Object)NullNode.getInstance(), (Object)JacksonUtils.toJsonNode((Object)JsonProperties.NULL_VALUE));
        Assert.assertEquals((Object)BooleanNode.TRUE, (Object)JacksonUtils.toJsonNode((Object)true));
        Assert.assertEquals((Object)IntNode.valueOf((int)1), (Object)JacksonUtils.toJsonNode((Object)1));
        Assert.assertEquals((Object)LongNode.valueOf((long)2L), (Object)JacksonUtils.toJsonNode((Object)2L));
        Assert.assertEquals((Object)DoubleNode.valueOf((double)1.0), (Object)JacksonUtils.toJsonNode((Object)Float.valueOf(1.0f)));
        Assert.assertEquals((Object)DoubleNode.valueOf((double)2.0), (Object)JacksonUtils.toJsonNode((Object)2.0));
        Assert.assertEquals((Object)TextNode.valueOf((String)"\u0001\u0002"), (Object)JacksonUtils.toJsonNode((Object)new byte[]{1, 2}));
        Assert.assertEquals((Object)TextNode.valueOf((String)"a"), (Object)JacksonUtils.toJsonNode((Object)"a"));
        Assert.assertEquals((Object)TextNode.valueOf((String)"UP"), (Object)JacksonUtils.toJsonNode((Object)((Object)Direction.UP)));
        ArrayNode an = JsonNodeFactory.instance.arrayNode();
        an.add(1);
        Assert.assertEquals((Object)an, (Object)JacksonUtils.toJsonNode(Collections.singletonList(1)));
        ObjectNode on = JsonNodeFactory.instance.objectNode();
        on.put("a", 1);
        Assert.assertEquals((Object)on, (Object)JacksonUtils.toJsonNode(Collections.singletonMap("a", 1)));
    }

    @Test
    public void testToObject() {
        Assert.assertEquals(null, (Object)JacksonUtils.toObject(null));
        Assert.assertEquals((Object)JsonProperties.NULL_VALUE, (Object)JacksonUtils.toObject((JsonNode)NullNode.getInstance()));
        Assert.assertEquals((Object)true, (Object)JacksonUtils.toObject((JsonNode)BooleanNode.TRUE));
        Assert.assertEquals((Object)1, (Object)JacksonUtils.toObject((JsonNode)IntNode.valueOf((int)1)));
        Assert.assertEquals((Object)2L, (Object)JacksonUtils.toObject((JsonNode)IntNode.valueOf((int)2), (Schema)Schema.create((Schema.Type)Schema.Type.LONG)));
        Assert.assertEquals((Object)Float.valueOf(1.0f), (Object)JacksonUtils.toObject((JsonNode)DoubleNode.valueOf((double)1.0), (Schema)Schema.create((Schema.Type)Schema.Type.FLOAT)));
        Assert.assertEquals((Object)2.0, (Object)JacksonUtils.toObject((JsonNode)DoubleNode.valueOf((double)2.0)));
        Assert.assertEquals((Object)TextNode.valueOf((String)"\u0001\u0002"), (Object)JacksonUtils.toJsonNode((Object)new byte[]{1, 2}));
        Assert.assertArrayEquals((byte[])new byte[]{1, 2}, (byte[])((byte[])JacksonUtils.toObject((JsonNode)TextNode.valueOf((String)"\u0001\u0002"), (Schema)Schema.create((Schema.Type)Schema.Type.BYTES))));
        Assert.assertEquals((Object)"a", (Object)JacksonUtils.toObject((JsonNode)TextNode.valueOf((String)"a")));
        Assert.assertEquals((Object)"UP", (Object)JacksonUtils.toObject((JsonNode)TextNode.valueOf((String)"UP"), (Schema)((Schema)SchemaBuilder.enumeration((String)"Direction").symbols(new String[]{"UP", "DOWN"}))));
        ArrayNode an = JsonNodeFactory.instance.arrayNode();
        an.add(1);
        Assert.assertEquals(Collections.singletonList(1), (Object)JacksonUtils.toObject((JsonNode)an));
        ObjectNode on = JsonNodeFactory.instance.objectNode();
        on.put("a", 1);
        Assert.assertEquals(Collections.singletonMap("a", 1), (Object)JacksonUtils.toObject((JsonNode)on));
        Assert.assertEquals(Collections.singletonMap("a", 1L), (Object)JacksonUtils.toObject((JsonNode)on, (Schema)((Schema)SchemaBuilder.record((String)"r").fields().requiredLong("a").endRecord())));
        Assert.assertEquals((Object)JsonProperties.NULL_VALUE, (Object)JacksonUtils.toObject((JsonNode)NullNode.getInstance(), (Schema)((Schema)((SchemaBuilder.UnionAccumulator)((SchemaBuilder.UnionAccumulator)SchemaBuilder.unionOf().nullType()).and().intType()).endUnion())));
        Assert.assertEquals((Object)"a", (Object)JacksonUtils.toObject((JsonNode)TextNode.valueOf((String)"a"), (Schema)((Schema)((SchemaBuilder.UnionAccumulator)((SchemaBuilder.UnionAccumulator)SchemaBuilder.unionOf().stringType()).and().intType()).endUnion())));
    }

    static enum Direction {
        UP,
        DOWN;

        public static final String __PARANAMER_DATA = "";
    }
}

