/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.codec.digest;

import java.nio.charset.StandardCharsets;
import org.apache.commons.codec.digest.Crypt;
import org.apache.commons.codec.digest.UnixCrypt;
import org.junit.Assert;
import org.junit.Test;

public class UnixCryptTest {
    @Test
    public void testCtor() {
        Assert.assertNotNull((Object)new UnixCrypt());
    }

    @Test
    public void testUnixCryptStrings() {
        Assert.assertEquals((Object)"xxWAum7tHdIUw", (Object)Crypt.crypt((String)"secret", (String)"xx"));
        Assert.assertEquals((Object)"12UFlHxel6uMM", (Object)Crypt.crypt((String)"", (String)"12"));
        Assert.assertEquals((Object)"12FJgqDtVOg7Q", (Object)Crypt.crypt((String)"secret", (String)"12"));
        Assert.assertEquals((Object)"12FJgqDtVOg7Q", (Object)Crypt.crypt((String)"secret", (String)"12345678"));
    }

    @Test
    public void testUnixCryptBytes() {
        Assert.assertEquals((Object)"12UFlHxel6uMM", (Object)Crypt.crypt((byte[])new byte[0], (String)"12"));
        Assert.assertEquals((Object)"./287bds2PjVw", (Object)Crypt.crypt((String)"t\u00e4st", (String)"./"));
        Assert.assertEquals((Object)"./bLIFNqo9XKQ", (Object)Crypt.crypt((byte[])"t\u00e4st".getBytes(StandardCharsets.ISO_8859_1), (String)"./"));
        Assert.assertEquals((Object)"./bLIFNqo9XKQ", (Object)Crypt.crypt((byte[])new byte[]{116, -28, 115, 116}, (String)"./"));
    }

    @Test
    public void testUnixCryptExplicitCall() {
        Assert.assertTrue((boolean)UnixCrypt.crypt((byte[])"secret".getBytes()).matches("^[a-zA-Z0-9./]{13}$"));
        Assert.assertTrue((boolean)UnixCrypt.crypt((byte[])"secret".getBytes(), null).matches("^[a-zA-Z0-9./]{13}$"));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testUnixCryptWithHalfSalt() {
        UnixCrypt.crypt((String)"secret", (String)"x");
    }

    @Test(expected=IllegalArgumentException.class)
    public void testUnicCryptInvalidSalt() {
        UnixCrypt.crypt((String)"secret", (String)"$a");
    }

    @Test(expected=NullPointerException.class)
    public void testUnixCryptNullData() {
        UnixCrypt.crypt((byte[])null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testUnixCryptWithEmptySalt() {
        UnixCrypt.crypt((String)"secret", (String)"");
    }

    @Test
    public void testUnixCryptWithoutSalt() {
        String hash = UnixCrypt.crypt((String)"foo");
        Assert.assertTrue((boolean)hash.matches("^[a-zA-Z0-9./]{13}$"));
        String hash2 = UnixCrypt.crypt((String)"foo");
        Assert.assertNotSame((Object)hash, (Object)hash2);
    }
}

