/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.codec.language;

import org.apache.commons.codec.StringEncoderAbstractTest;
import org.apache.commons.codec.language.Metaphone;
import org.junit.Assert;
import org.junit.Test;

public class MetaphoneTest
extends StringEncoderAbstractTest<Metaphone> {
    public void assertIsMetaphoneEqual(String source, String[] matches) {
        for (String matche : matches) {
            Assert.assertTrue((String)("Source: " + source + ", should have same Metaphone as: " + matche), (boolean)((Metaphone)this.getStringEncoder()).isMetaphoneEqual(source, matche));
        }
        for (String matche : matches) {
            for (String matche2 : matches) {
                Assert.assertTrue((boolean)((Metaphone)this.getStringEncoder()).isMetaphoneEqual(matche, matche2));
            }
        }
    }

    public void assertMetaphoneEqual(String[][] pairs) {
        this.validateFixture(pairs);
        for (String[] pair : pairs) {
            String name0 = pair[0];
            String name1 = pair[1];
            String failMsg = "Expected match between " + name0 + " and " + name1;
            Assert.assertTrue((String)failMsg, (boolean)((Metaphone)this.getStringEncoder()).isMetaphoneEqual(name0, name1));
            Assert.assertTrue((String)failMsg, (boolean)((Metaphone)this.getStringEncoder()).isMetaphoneEqual(name1, name0));
        }
    }

    @Override
    protected Metaphone createStringEncoder() {
        return new Metaphone();
    }

    @Test
    public void testIsMetaphoneEqual1() {
        this.assertMetaphoneEqual(new String[][]{{"Case", "case"}, {"CASE", "Case"}, {"caSe", "cAsE"}, {"quick", "cookie"}});
    }

    @Test
    public void testIsMetaphoneEqual2() {
        this.assertMetaphoneEqual(new String[][]{{"Lawrence", "Lorenza"}, {"Gary", "Cahra"}});
    }

    @Test
    public void testIsMetaphoneEqualAero() {
        this.assertIsMetaphoneEqual("Aero", new String[]{"Eure"});
    }

    @Test
    public void testIsMetaphoneEqualWhite() {
        this.assertIsMetaphoneEqual("White", new String[]{"Wade", "Wait", "Waite", "Wat", "Whit", "Wiatt", "Wit", "Wittie", "Witty", "Wood", "Woodie", "Woody"});
    }

    @Test
    public void testIsMetaphoneEqualAlbert() {
        this.assertIsMetaphoneEqual("Albert", new String[]{"Ailbert", "Alberik", "Albert", "Alberto", "Albrecht"});
    }

    @Test
    public void testIsMetaphoneEqualGary() {
        this.assertIsMetaphoneEqual("Gary", new String[]{"Cahra", "Cara", "Carey", "Cari", "Caria", "Carie", "Caro", "Carree", "Carri", "Carrie", "Carry", "Cary", "Cora", "Corey", "Cori", "Corie", "Correy", "Corri", "Corrie", "Corry", "Cory", "Gray", "Kara", "Kare", "Karee", "Kari", "Karia", "Karie", "Karrah", "Karrie", "Karry", "Kary", "Keri", "Kerri", "Kerrie", "Kerry", "Kira", "Kiri", "Kora", "Kore", "Kori", "Korie", "Korrie", "Korry"});
    }

    @Test
    public void testIsMetaphoneEqualJohn() {
        this.assertIsMetaphoneEqual("John", new String[]{"Gena", "Gene", "Genia", "Genna", "Genni", "Gennie", "Genny", "Giana", "Gianna", "Gina", "Ginni", "Ginnie", "Ginny", "Jaine", "Jan", "Jana", "Jane", "Janey", "Jania", "Janie", "Janna", "Jany", "Jayne", "Jean", "Jeana", "Jeane", "Jeanie", "Jeanna", "Jeanne", "Jeannie", "Jen", "Jena", "Jeni", "Jenn", "Jenna", "Jennee", "Jenni", "Jennie", "Jenny", "Jinny", "Jo Ann", "Jo-Ann", "Jo-Anne", "Joan", "Joana", "Joane", "Joanie", "Joann", "Joanna", "Joanne", "Joeann", "Johna", "Johnna", "Joni", "Jonie", "Juana", "June", "Junia", "Junie"});
    }

    @Test
    public void testIsMetaphoneEqualKnight() {
        this.assertIsMetaphoneEqual("Knight", new String[]{"Hynda", "Nada", "Nadia", "Nady", "Nat", "Nata", "Natty", "Neda", "Nedda", "Nedi", "Netta", "Netti", "Nettie", "Netty", "Nita", "Nydia"});
    }

    @Test
    public void testIsMetaphoneEqualMary() {
        this.assertIsMetaphoneEqual("Mary", new String[]{"Mair", "Maire", "Mara", "Mareah", "Mari", "Maria", "Marie", "Mary", "Maura", "Maure", "Meara", "Merrie", "Merry", "Mira", "Moira", "Mora", "Moria", "Moyra", "Muire", "Myra", "Myrah"});
    }

    @Test
    public void testIsMetaphoneEqualParis() {
        this.assertIsMetaphoneEqual("Paris", new String[]{"Pearcy", "Perris", "Piercy", "Pierz", "Pryse"});
    }

    @Test
    public void testIsMetaphoneEqualPeter() {
        this.assertIsMetaphoneEqual("Peter", new String[]{"Peadar", "Peder", "Pedro", "Peter", "Petr", "Peyter", "Pieter", "Pietro", "Piotr"});
    }

    @Test
    public void testIsMetaphoneEqualRay() {
        this.assertIsMetaphoneEqual("Ray", new String[]{"Ray", "Rey", "Roi", "Roy", "Ruy"});
    }

    @Test
    public void testIsMetaphoneEqualSusan() {
        this.assertIsMetaphoneEqual("Susan", new String[]{"Siusan", "Sosanna", "Susan", "Susana", "Susann", "Susanna", "Susannah", "Susanne", "Suzann", "Suzanna", "Suzanne", "Zuzana"});
    }

    @Test
    public void testIsMetaphoneEqualWright() {
        this.assertIsMetaphoneEqual("Wright", new String[]{"Rota", "Rudd", "Ryde"});
    }

    @Test
    public void testIsMetaphoneEqualXalan() {
        this.assertIsMetaphoneEqual("Xalan", new String[]{"Celene", "Celina", "Celine", "Selena", "Selene", "Selina", "Seline", "Suellen", "Xylina"});
    }

    @Test
    public void testMetaphone() {
        Assert.assertEquals((Object)"HL", (Object)((Metaphone)this.getStringEncoder()).metaphone("howl"));
        Assert.assertEquals((Object)"TSTN", (Object)((Metaphone)this.getStringEncoder()).metaphone("testing"));
        Assert.assertEquals((Object)"0", (Object)((Metaphone)this.getStringEncoder()).metaphone("The"));
        Assert.assertEquals((Object)"KK", (Object)((Metaphone)this.getStringEncoder()).metaphone("quick"));
        Assert.assertEquals((Object)"BRN", (Object)((Metaphone)this.getStringEncoder()).metaphone("brown"));
        Assert.assertEquals((Object)"FKS", (Object)((Metaphone)this.getStringEncoder()).metaphone("fox"));
        Assert.assertEquals((Object)"JMPT", (Object)((Metaphone)this.getStringEncoder()).metaphone("jumped"));
        Assert.assertEquals((Object)"OFR", (Object)((Metaphone)this.getStringEncoder()).metaphone("over"));
        Assert.assertEquals((Object)"0", (Object)((Metaphone)this.getStringEncoder()).metaphone("the"));
        Assert.assertEquals((Object)"LS", (Object)((Metaphone)this.getStringEncoder()).metaphone("lazy"));
        Assert.assertEquals((Object)"TKS", (Object)((Metaphone)this.getStringEncoder()).metaphone("dogs"));
    }

    @Test
    public void testWordEndingInMB() {
        Assert.assertEquals((Object)"KM", (Object)((Metaphone)this.getStringEncoder()).metaphone("COMB"));
        Assert.assertEquals((Object)"TM", (Object)((Metaphone)this.getStringEncoder()).metaphone("TOMB"));
        Assert.assertEquals((Object)"WM", (Object)((Metaphone)this.getStringEncoder()).metaphone("WOMB"));
    }

    @Test
    public void testDiscardOfSCEOrSCIOrSCY() {
        Assert.assertEquals((Object)"SNS", (Object)((Metaphone)this.getStringEncoder()).metaphone("SCIENCE"));
        Assert.assertEquals((Object)"SN", (Object)((Metaphone)this.getStringEncoder()).metaphone("SCENE"));
        Assert.assertEquals((Object)"S", (Object)((Metaphone)this.getStringEncoder()).metaphone("SCY"));
    }

    @Test
    public void testWhy() {
        Assert.assertEquals((Object)"", (Object)((Metaphone)this.getStringEncoder()).metaphone("WHY"));
    }

    @Test
    public void testWordsWithCIA() {
        Assert.assertEquals((Object)"XP", (Object)((Metaphone)this.getStringEncoder()).metaphone("CIAPO"));
    }

    @Test
    public void testTranslateOfSCHAndCH() {
        Assert.assertEquals((Object)"SKTL", (Object)((Metaphone)this.getStringEncoder()).metaphone("SCHEDULE"));
        Assert.assertEquals((Object)"SKMT", (Object)((Metaphone)this.getStringEncoder()).metaphone("SCHEMATIC"));
        Assert.assertEquals((Object)"KRKT", (Object)((Metaphone)this.getStringEncoder()).metaphone("CHARACTER"));
        Assert.assertEquals((Object)"TX", (Object)((Metaphone)this.getStringEncoder()).metaphone("TEACH"));
    }

    @Test
    public void testTranslateToJOfDGEOrDGIOrDGY() {
        Assert.assertEquals((Object)"TJ", (Object)((Metaphone)this.getStringEncoder()).metaphone("DODGY"));
        Assert.assertEquals((Object)"TJ", (Object)((Metaphone)this.getStringEncoder()).metaphone("DODGE"));
        Assert.assertEquals((Object)"AJMT", (Object)((Metaphone)this.getStringEncoder()).metaphone("ADGIEMTI"));
    }

    @Test
    public void testDiscardOfSilentHAfterG() {
        Assert.assertEquals((Object)"KNT", (Object)((Metaphone)this.getStringEncoder()).metaphone("GHENT"));
        Assert.assertEquals((Object)"B", (Object)((Metaphone)this.getStringEncoder()).metaphone("BAUGH"));
    }

    @Test
    public void testDiscardOfSilentGN() {
        Assert.assertEquals((Object)"N", (Object)((Metaphone)this.getStringEncoder()).metaphone("GNU"));
        Assert.assertEquals((Object)"SNT", (Object)((Metaphone)this.getStringEncoder()).metaphone("SIGNED"));
    }

    @Test
    public void testPHTOF() {
        Assert.assertEquals((Object)"FX", (Object)((Metaphone)this.getStringEncoder()).metaphone("PHISH"));
    }

    @Test
    public void testSHAndSIOAndSIAToX() {
        Assert.assertEquals((Object)"XT", (Object)((Metaphone)this.getStringEncoder()).metaphone("SHOT"));
        Assert.assertEquals((Object)"OTXN", (Object)((Metaphone)this.getStringEncoder()).metaphone("ODSIAN"));
        Assert.assertEquals((Object)"PLXN", (Object)((Metaphone)this.getStringEncoder()).metaphone("PULSION"));
    }

    @Test
    public void testTIOAndTIAToX() {
        Assert.assertEquals((Object)"OX", (Object)((Metaphone)this.getStringEncoder()).metaphone("OTIA"));
        Assert.assertEquals((Object)"PRXN", (Object)((Metaphone)this.getStringEncoder()).metaphone("PORTION"));
    }

    @Test
    public void testTCH() {
        Assert.assertEquals((Object)"RX", (Object)((Metaphone)this.getStringEncoder()).metaphone("RETCH"));
        Assert.assertEquals((Object)"WX", (Object)((Metaphone)this.getStringEncoder()).metaphone("WATCH"));
    }

    @Test
    public void testExceedLength() {
        Assert.assertEquals((Object)"AKSK", (Object)((Metaphone)this.getStringEncoder()).metaphone("AXEAXE"));
    }

    @Test
    public void testSetMaxLengthWithTruncation() {
        ((Metaphone)this.getStringEncoder()).setMaxCodeLen(6);
        Assert.assertEquals((Object)"AKSKSK", (Object)((Metaphone)this.getStringEncoder()).metaphone("AXEAXEAXE"));
    }

    public void validateFixture(String[][] pairs) {
        if (pairs.length == 0) {
            Assert.fail((String)"Test fixture is empty");
        }
        for (int i = 0; i < pairs.length; ++i) {
            if (pairs[i].length == 2) continue;
            Assert.fail((String)("Error in test fixture in the data array at index " + i));
        }
    }
}

