/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.codec.net;

import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.EncoderException;
import org.apache.commons.codec.net.PercentCodec;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

public class PercentCodecTest {
    @Test
    public void testBasicEncodeDecode() throws Exception {
        PercentCodec percentCodec = new PercentCodec();
        String input = "abcdABCD";
        byte[] encoded = percentCodec.encode("abcdABCD".getBytes(StandardCharsets.UTF_8));
        String encodedS = new String(encoded, "UTF-8");
        byte[] decoded = percentCodec.decode(encoded);
        String decodedS = new String(decoded, "UTF-8");
        Assert.assertEquals((String)"Basic PercentCodec encoding test", (Object)"abcdABCD", (Object)encodedS);
        Assert.assertEquals((String)"Basic PercentCodec decoding test", (Object)"abcdABCD", (Object)decodedS);
    }

    @Test
    @Ignore
    public void testBasicSpace() throws Exception {
        PercentCodec percentCodec = new PercentCodec();
        String input = " ";
        byte[] encoded = percentCodec.encode(" ".getBytes(StandardCharsets.UTF_8));
        Assert.assertArrayEquals((byte[])"%20".getBytes(StandardCharsets.UTF_8), (byte[])encoded);
    }

    @Test
    public void testConfigurablePercentEncoder() throws Exception {
        String input = "abc123_-.*\u03b1\u03b2";
        PercentCodec percentCodec = new PercentCodec("abcdef".getBytes("UTF-8"), false);
        byte[] encoded = percentCodec.encode("abc123_-.*\u03b1\u03b2".getBytes(StandardCharsets.UTF_8));
        String encodedS = new String(encoded, "UTF-8");
        Assert.assertEquals((String)"Configurable PercentCodec encoding test", (Object)"%61%62%63123_-.*%CE%B1%CE%B2", (Object)encodedS);
        byte[] decoded = percentCodec.decode(encoded);
        Assert.assertEquals((String)"Configurable PercentCodec decoding test", (Object)new String(decoded, "UTF-8"), (Object)"abc123_-.*\u03b1\u03b2");
    }

    @Test
    public void testDecodeInvalidEncodedResultDecoding() throws Exception {
        String inputS = "\u03b1\u03b2";
        PercentCodec percentCodec = new PercentCodec();
        byte[] encoded = percentCodec.encode("\u03b1\u03b2".getBytes("UTF-8"));
        try {
            percentCodec.decode(Arrays.copyOf(encoded, encoded.length - 1));
        }
        catch (Exception e) {
            Assert.assertTrue((DecoderException.class.isInstance(e) && ArrayIndexOutOfBoundsException.class.isInstance(e.getCause()) ? 1 : 0) != 0);
        }
    }

    @Test
    public void testDecodeNullObject() throws Exception {
        PercentCodec percentCodec = new PercentCodec();
        Assert.assertEquals((Object)percentCodec.decode(null), null);
    }

    @Test(expected=DecoderException.class)
    public void testDecodeUnsupportedObject() throws Exception {
        PercentCodec percentCodec = new PercentCodec();
        percentCodec.decode((Object)"test");
    }

    @Test
    public void testEncodeNullObject() throws Exception {
        PercentCodec percentCodec = new PercentCodec();
        Assert.assertEquals((Object)percentCodec.encode(null), null);
    }

    @Test(expected=EncoderException.class)
    public void testEncodeUnsupportedObject() throws Exception {
        PercentCodec percentCodec = new PercentCodec();
        percentCodec.encode((Object)"test");
    }

    @Test
    public void testPercentEncoderDecoderWithNullOrEmptyInput() throws Exception {
        PercentCodec percentCodec = new PercentCodec(null, true);
        Assert.assertEquals((String)"Null input value encoding test", (Object)percentCodec.encode(null), null);
        Assert.assertEquals((String)"Null input value decoding test", (Object)percentCodec.decode(null), null);
        byte[] emptyInput = "".getBytes("UTF-8");
        Assert.assertEquals((String)"Empty input value encoding test", (Object)percentCodec.encode(emptyInput), (Object)emptyInput);
        Assert.assertTrue((String)"Empty input value decoding test", (boolean)Arrays.equals(percentCodec.decode(emptyInput), emptyInput));
    }

    @Test
    public void testPercentEncoderDecoderWithPlusForSpace() throws Exception {
        String input = "a b c d";
        PercentCodec percentCodec = new PercentCodec(null, true);
        byte[] encoded = percentCodec.encode("a b c d".getBytes(StandardCharsets.UTF_8));
        String encodedS = new String(encoded, "UTF-8");
        Assert.assertEquals((String)"PercentCodec plus for space encoding test", (Object)"a+b+c+d", (Object)encodedS);
        byte[] decode = percentCodec.decode(encoded);
        Assert.assertEquals((String)"PercentCodec plus for space decoding test", (Object)new String(decode, "UTF-8"), (Object)"a b c d");
    }

    @Test
    public void testSafeCharEncodeDecodeObject() throws Exception {
        PercentCodec percentCodec = new PercentCodec(null, true);
        String input = "abc123_-.*";
        Object encoded = percentCodec.encode((Object)"abc123_-.*".getBytes(StandardCharsets.UTF_8));
        String encodedS = new String((byte[])encoded, "UTF-8");
        Object decoded = percentCodec.decode(encoded);
        String decodedS = new String((byte[])decoded, "UTF-8");
        Assert.assertEquals((String)"Basic PercentCodec safe char encoding test", (Object)"abc123_-.*", (Object)encodedS);
        Assert.assertEquals((String)"Basic PercentCodec safe char decoding test", (Object)"abc123_-.*", (Object)decodedS);
    }

    @Test
    public void testUnsafeCharEncodeDecode() throws Exception {
        PercentCodec percentCodec = new PercentCodec();
        String input = "\u03b1\u03b2\u03b3\u03b4\u03b5\u03b6% ";
        byte[] encoded = percentCodec.encode("\u03b1\u03b2\u03b3\u03b4\u03b5\u03b6% ".getBytes(StandardCharsets.UTF_8));
        String encodedS = new String(encoded, "UTF-8");
        byte[] decoded = percentCodec.decode(encoded);
        String decodedS = new String(decoded, "UTF-8");
        Assert.assertEquals((String)"Basic PercentCodec unsafe char encoding test", (Object)"%CE%B1%CE%B2%CE%B3%CE%B4%CE%B5%CE%B6%25 ", (Object)encodedS);
        Assert.assertEquals((String)"Basic PercentCodec unsafe char decoding test", (Object)"\u03b1\u03b2\u03b3\u03b4\u03b5\u03b6% ", (Object)decodedS);
    }
}

