/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.apache.commons.compress.AbstractTestCase;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.ArchiveException;

public class ArchiveReadTests
extends AbstractTestCase {
    static final ClassLoader classLoader = ArchiveReadTests.class.getClassLoader();
    private File file;
    private static final ArrayList<String> fileList = new ArrayList();

    public ArchiveReadTests(String name) {
        super(name);
    }

    private ArchiveReadTests(String name, File file) {
        super(name);
        this.file = file;
    }

    public static TestSuite suite() throws IOException {
        File[] files;
        String line;
        TestSuite suite = new TestSuite("ArchiveReadTests");
        File arcdir = new File(classLoader.getResource("archives").getFile());
        ArchiveReadTests.assertTrue((boolean)arcdir.exists());
        File listing = new File(arcdir, "files.txt");
        ArchiveReadTests.assertTrue((String)"files.txt is readable", (boolean)listing.canRead());
        BufferedReader br = new BufferedReader(new FileReader(listing));
        while ((line = br.readLine()) != null) {
            if (line.startsWith("#")) continue;
            fileList.add(line);
        }
        br.close();
        for (File file : files = arcdir.listFiles()) {
            if (file.getName().endsWith(".txt")) continue;
            TestSuite namedSuite = new TestSuite(file.getName());
            ArchiveReadTests test = new ArchiveReadTests("testArchive", file);
            namedSuite.addTest((Test)test);
            suite.addTest((Test)namedSuite);
        }
        return suite;
    }

    protected String getExpectedString(ArchiveEntry entry) {
        return entry.getSize() + " " + entry.getName();
    }

    public void testArchive() throws Exception {
        ArrayList expected = (ArrayList)fileList.clone();
        try {
            this.checkArchiveContent(this.file, (List<String>)expected);
        }
        catch (ArchiveException e) {
            ArchiveReadTests.fail((String)("Problem checking " + this.file));
        }
    }
}

