/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress;

import org.apache.commons.compress.AbstractTestCase;
import org.apache.commons.compress.utils.ArchiveUtils;

public class ArchiveUtilsTest
extends AbstractTestCase {
    private static final int bytesToTest = 50;
    private static final byte[] byteTest = new byte[50];

    public void testCompareBA() {
        byte[] buffer1 = new byte[]{1, 2, 3};
        byte[] buffer2 = new byte[]{1, 2, 3, 0};
        byte[] buffer3 = new byte[]{1, 2, 3};
        ArchiveUtilsTest.assertTrue((boolean)ArchiveUtils.isEqual((byte[])buffer1, (byte[])buffer2, (boolean)true));
        ArchiveUtilsTest.assertFalse((boolean)ArchiveUtils.isEqual((byte[])buffer1, (byte[])buffer2, (boolean)false));
        ArchiveUtilsTest.assertFalse((boolean)ArchiveUtils.isEqual((byte[])buffer1, (byte[])buffer2));
        ArchiveUtilsTest.assertTrue((boolean)ArchiveUtils.isEqual((byte[])buffer2, (byte[])buffer1, (boolean)true));
        ArchiveUtilsTest.assertFalse((boolean)ArchiveUtils.isEqual((byte[])buffer2, (byte[])buffer1, (boolean)false));
        ArchiveUtilsTest.assertFalse((boolean)ArchiveUtils.isEqual((byte[])buffer2, (byte[])buffer1));
        ArchiveUtilsTest.assertTrue((boolean)ArchiveUtils.isEqual((byte[])buffer1, (byte[])buffer3));
        ArchiveUtilsTest.assertTrue((boolean)ArchiveUtils.isEqual((byte[])buffer3, (byte[])buffer1));
    }

    public void testCompareAscii() {
        byte[] buffer1 = new byte[]{97, 98, 99};
        byte[] buffer2 = new byte[]{100, 101, 102, 0};
        ArchiveUtilsTest.assertTrue((boolean)ArchiveUtils.matchAsciiBuffer((String)"abc", (byte[])buffer1));
        ArchiveUtilsTest.assertFalse((boolean)ArchiveUtils.matchAsciiBuffer((String)"abc\u0000", (byte[])buffer1));
        ArchiveUtilsTest.assertTrue((boolean)ArchiveUtils.matchAsciiBuffer((String)"def\u0000", (byte[])buffer2));
        ArchiveUtilsTest.assertFalse((boolean)ArchiveUtils.matchAsciiBuffer((String)"def", (byte[])buffer2));
    }

    public void testAsciiConversions() {
        this.asciiToByteAndBackOK("");
        this.asciiToByteAndBackOK("abcd");
        this.asciiToByteAndBackFail("\u8025");
    }

    private void asciiToByteAndBackOK(String inputString) {
        ArchiveUtilsTest.assertEquals((String)inputString, (String)ArchiveUtils.toAsciiString((byte[])ArchiveUtils.toAsciiBytes((String)inputString)));
    }

    private void asciiToByteAndBackFail(String inputString) {
        ArchiveUtilsTest.assertFalse((boolean)inputString.equals(ArchiveUtils.toAsciiString((byte[])ArchiveUtils.toAsciiBytes((String)inputString))));
    }

    static {
        for (int i = 0; i < byteTest.length; i += 2) {
            ArchiveUtilsTest.byteTest[i] = (byte)i;
            ArchiveUtilsTest.byteTest[i + 1] = (byte)(-i);
        }
    }
}

