/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.compress.AbstractTestCase;
import org.apache.commons.compress.archivers.ArchiveException;
import org.apache.commons.compress.archivers.ArchiveInputStream;
import org.apache.commons.compress.archivers.ar.ArArchiveInputStream;
import org.apache.commons.compress.archivers.arj.ArjArchiveInputStream;
import org.apache.commons.compress.archivers.cpio.CpioArchiveInputStream;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.archivers.zip.ZipArchiveInputStream;

public final class DetectArchiverTestCase
extends AbstractTestCase {
    final ClassLoader classLoader = ((Object)((Object)this)).getClass().getClassLoader();

    public DetectArchiverTestCase(String name) {
        super(name);
    }

    public void testDetectionNotArchive() throws IOException {
        try {
            this.getStreamFor("test.txt");
            DetectArchiverTestCase.fail((String)"Expected ArchiveException");
        }
        catch (ArchiveException archiveException) {
            // empty catch block
        }
    }

    public void testCOMPRESS117() throws Exception {
        ArchiveInputStream tar = this.getStreamFor("COMPRESS-117.tar");
        DetectArchiverTestCase.assertNotNull((Object)tar);
        DetectArchiverTestCase.assertTrue((boolean)(tar instanceof TarArchiveInputStream));
    }

    public void testDetection() throws Exception {
        ArchiveInputStream ar = this.getStreamFor("bla.ar");
        DetectArchiverTestCase.assertNotNull((Object)ar);
        DetectArchiverTestCase.assertTrue((boolean)(ar instanceof ArArchiveInputStream));
        ArchiveInputStream tar = this.getStreamFor("bla.tar");
        DetectArchiverTestCase.assertNotNull((Object)tar);
        DetectArchiverTestCase.assertTrue((boolean)(tar instanceof TarArchiveInputStream));
        ArchiveInputStream zip = this.getStreamFor("bla.zip");
        DetectArchiverTestCase.assertNotNull((Object)zip);
        DetectArchiverTestCase.assertTrue((boolean)(zip instanceof ZipArchiveInputStream));
        ArchiveInputStream jar = this.getStreamFor("bla.jar");
        DetectArchiverTestCase.assertNotNull((Object)jar);
        DetectArchiverTestCase.assertTrue((boolean)(jar instanceof ZipArchiveInputStream));
        ArchiveInputStream cpio = this.getStreamFor("bla.cpio");
        DetectArchiverTestCase.assertNotNull((Object)cpio);
        DetectArchiverTestCase.assertTrue((boolean)(cpio instanceof CpioArchiveInputStream));
        ArchiveInputStream arj = this.getStreamFor("bla.arj");
        DetectArchiverTestCase.assertNotNull((Object)arj);
        DetectArchiverTestCase.assertTrue((boolean)(arj instanceof ArjArchiveInputStream));
    }

    private ArchiveInputStream getStreamFor(String resource) throws ArchiveException, IOException {
        return this.factory.createArchiveInputStream((InputStream)new BufferedInputStream(new FileInputStream(DetectArchiverTestCase.getFile(resource))));
    }

    public void testEmptyCpioArchive() throws Exception {
        this.checkEmptyArchive("cpio");
    }

    public void testEmptyJarArchive() throws Exception {
        this.checkEmptyArchive("jar");
    }

    public void testEmptyZipArchive() throws Exception {
        this.checkEmptyArchive("zip");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkEmptyArchive(String type) throws Exception {
        File ar = this.createEmptyArchive(type);
        ar.deleteOnExit();
        ArchiveInputStream ais = null;
        BufferedInputStream in = null;
        try {
            in = new BufferedInputStream(new FileInputStream(ar));
            ais = this.factory.createArchiveInputStream((InputStream)in);
        }
        catch (ArchiveException ae) {
            DetectArchiverTestCase.fail((String)("Should have recognised empty archive for " + type));
        }
        finally {
            if (ais != null) {
                ais.close();
            } else if (in != null) {
                in.close();
            }
        }
    }
}

