/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import junit.framework.TestCase;
import org.apache.commons.compress.AbstractTestCase;
import org.apache.commons.compress.compressors.CompressorException;
import org.apache.commons.compress.compressors.CompressorInputStream;
import org.apache.commons.compress.compressors.CompressorStreamFactory;
import org.apache.commons.compress.compressors.bzip2.BZip2CompressorInputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorInputStream;
import org.apache.commons.compress.compressors.pack200.Pack200CompressorInputStream;
import org.apache.commons.compress.compressors.xz.XZCompressorInputStream;

public final class DetectCompressorTestCase
extends TestCase {
    final CompressorStreamFactory factory = new CompressorStreamFactory();

    public DetectCompressorTestCase(String name) {
        super(name);
    }

    public void testDetection() throws Exception {
        CompressorInputStream bzip2 = this.getStreamFor("bla.txt.bz2");
        DetectCompressorTestCase.assertNotNull((Object)bzip2);
        DetectCompressorTestCase.assertTrue((boolean)(bzip2 instanceof BZip2CompressorInputStream));
        CompressorInputStream gzip = this.getStreamFor("bla.tgz");
        DetectCompressorTestCase.assertNotNull((Object)gzip);
        DetectCompressorTestCase.assertTrue((boolean)(gzip instanceof GzipCompressorInputStream));
        CompressorInputStream pack200 = this.getStreamFor("bla.pack");
        DetectCompressorTestCase.assertNotNull((Object)pack200);
        DetectCompressorTestCase.assertTrue((boolean)(pack200 instanceof Pack200CompressorInputStream));
        CompressorInputStream xz = this.getStreamFor("bla.tar.xz");
        DetectCompressorTestCase.assertNotNull((Object)xz);
        DetectCompressorTestCase.assertTrue((boolean)(xz instanceof XZCompressorInputStream));
        try {
            this.factory.createCompressorInputStream((InputStream)new ByteArrayInputStream(new byte[0]));
            DetectCompressorTestCase.fail((String)"No exception thrown for an empty input stream");
        }
        catch (CompressorException e) {
            // empty catch block
        }
    }

    private CompressorInputStream getStreamFor(String resource) throws CompressorException, IOException {
        return this.factory.createCompressorInputStream((InputStream)new BufferedInputStream(new FileInputStream(AbstractTestCase.getFile(resource))));
    }
}

