/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.archivers;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.compress.AbstractTestCase;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.ArchiveInputStream;
import org.apache.commons.compress.archivers.ArchiveOutputStream;
import org.apache.commons.compress.archivers.ArchiveStreamFactory;
import org.apache.commons.compress.archivers.ar.ArArchiveEntry;
import org.apache.commons.compress.archivers.ar.ArArchiveInputStream;
import org.apache.commons.compress.archivers.ar.ArArchiveOutputStream;
import org.apache.commons.compress.utils.IOUtils;

public final class ArTestCase
extends AbstractTestCase {
    public void testArArchiveCreation() throws Exception {
        File output = new File(this.dir, "bla.ar");
        File file1 = ArTestCase.getFile("test1.xml");
        File file2 = ArTestCase.getFile("test2.xml");
        FileOutputStream out = new FileOutputStream(output);
        ArchiveOutputStream os = new ArchiveStreamFactory().createArchiveOutputStream("ar", (OutputStream)out);
        os.putArchiveEntry((ArchiveEntry)new ArArchiveEntry("test1.xml", file1.length()));
        IOUtils.copy((InputStream)new FileInputStream(file1), (OutputStream)os);
        os.closeArchiveEntry();
        os.putArchiveEntry((ArchiveEntry)new ArArchiveEntry("test2.xml", file2.length()));
        IOUtils.copy((InputStream)new FileInputStream(file2), (OutputStream)os);
        os.closeArchiveEntry();
        os.close();
    }

    public void testArUnarchive() throws Exception {
        File output = new File(this.dir, "bla.ar");
        File file1 = ArTestCase.getFile("test1.xml");
        File file2 = ArTestCase.getFile("test2.xml");
        FileOutputStream out = new FileOutputStream(output);
        ArchiveOutputStream os = new ArchiveStreamFactory().createArchiveOutputStream("ar", (OutputStream)out);
        os.putArchiveEntry((ArchiveEntry)new ArArchiveEntry("test1.xml", file1.length()));
        IOUtils.copy((InputStream)new FileInputStream(file1), (OutputStream)os);
        os.closeArchiveEntry();
        os.putArchiveEntry((ArchiveEntry)new ArArchiveEntry("test2.xml", file2.length()));
        IOUtils.copy((InputStream)new FileInputStream(file2), (OutputStream)os);
        os.closeArchiveEntry();
        os.close();
        ((OutputStream)out).close();
        File input = output;
        FileInputStream is = new FileInputStream(input);
        ArchiveInputStream in = new ArchiveStreamFactory().createArchiveInputStream((InputStream)new BufferedInputStream(is));
        ArArchiveEntry entry = (ArArchiveEntry)in.getNextEntry();
        File target = new File(this.dir, entry.getName());
        FileOutputStream out2 = new FileOutputStream(target);
        IOUtils.copy((InputStream)in, (OutputStream)out2);
        ((OutputStream)out2).close();
        in.close();
        ((InputStream)is).close();
    }

    public void testArDelete() throws Exception {
        ArArchiveEntry entry;
        ArArchiveEntry entry2;
        File output = new File(this.dir, "bla.ar");
        File file1 = ArTestCase.getFile("test1.xml");
        File file2 = ArTestCase.getFile("test2.xml");
        FileOutputStream out = new FileOutputStream(output);
        ArchiveOutputStream os = new ArchiveStreamFactory().createArchiveOutputStream("ar", (OutputStream)out);
        os.putArchiveEntry((ArchiveEntry)new ArArchiveEntry("test1.xml", file1.length()));
        IOUtils.copy((InputStream)new FileInputStream(file1), (OutputStream)os);
        os.closeArchiveEntry();
        os.putArchiveEntry((ArchiveEntry)new ArArchiveEntry("test2.xml", file2.length()));
        IOUtils.copy((InputStream)new FileInputStream(file2), (OutputStream)os);
        os.closeArchiveEntry();
        os.close();
        ((OutputStream)out).close();
        ArTestCase.assertEquals((long)(68L + file1.length() + file1.length() % 2L + 60L + file2.length() + file2.length() % 2L), (long)output.length());
        File output2 = new File(this.dir, "bla2.ar");
        int copied = 0;
        int deleted = 0;
        FileInputStream is = new FileInputStream(output);
        FileOutputStream os2 = new FileOutputStream(output2);
        ArchiveOutputStream aos = new ArchiveStreamFactory().createArchiveOutputStream("ar", (OutputStream)os2);
        ArchiveInputStream ais = new ArchiveStreamFactory().createArchiveInputStream((InputStream)new BufferedInputStream(is));
        while ((entry2 = (ArArchiveEntry)ais.getNextEntry()) != null) {
            if ("test1.xml".equals(entry2.getName())) {
                aos.putArchiveEntry((ArchiveEntry)entry2);
                IOUtils.copy((InputStream)ais, (OutputStream)aos);
                aos.closeArchiveEntry();
                ++copied;
                continue;
            }
            IOUtils.copy((InputStream)ais, (OutputStream)new ByteArrayOutputStream());
            ++deleted;
        }
        ais.close();
        aos.close();
        ((InputStream)is).close();
        ((OutputStream)os2).close();
        ArTestCase.assertEquals((int)1, (int)copied);
        ArTestCase.assertEquals((int)1, (int)deleted);
        ArTestCase.assertEquals((long)(68L + file1.length() + file1.length() % 2L), (long)output2.length());
        long files = 0L;
        long sum = 0L;
        FileInputStream is2 = new FileInputStream(output2);
        ArchiveInputStream ais2 = new ArchiveStreamFactory().createArchiveInputStream((InputStream)new BufferedInputStream(is2));
        while ((entry = (ArArchiveEntry)ais2.getNextEntry()) != null) {
            IOUtils.copy((InputStream)ais2, (OutputStream)new ByteArrayOutputStream());
            sum += entry.getLength();
            ++files;
        }
        ais2.close();
        ((InputStream)is2).close();
        ArTestCase.assertEquals((long)1L, (long)files);
        ArTestCase.assertEquals((long)file1.length(), (long)sum);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void XtestDirectoryEntryFromFile() throws Exception {
        File[] tmp = this.createTempDirAndFile();
        File archive = null;
        ArArchiveOutputStream aos = null;
        ArArchiveInputStream ais = null;
        try {
            archive = File.createTempFile("test.", ".ar", tmp[0]);
            archive.deleteOnExit();
            aos = new ArArchiveOutputStream((OutputStream)new FileOutputStream(archive));
            long beforeArchiveWrite = tmp[0].lastModified();
            ArArchiveEntry in = new ArArchiveEntry(tmp[0], "foo");
            aos.putArchiveEntry((ArchiveEntry)in);
            aos.closeArchiveEntry();
            aos.close();
            aos = null;
            ais = new ArArchiveInputStream((InputStream)new FileInputStream(archive));
            ArArchiveEntry out = ais.getNextArEntry();
            ais.close();
            ais = null;
            ArTestCase.assertNotNull((Object)out);
            ArTestCase.assertEquals((String)"foo/", (String)out.getName());
            ArTestCase.assertEquals((long)0L, (long)out.getSize());
            ArTestCase.assertEquals((long)(beforeArchiveWrite / 1000L), (long)(out.getLastModifiedDate().getTime() / 1000L));
            ArTestCase.assertTrue((boolean)out.isDirectory());
        }
        finally {
            if (ais != null) {
                ais.close();
            }
            if (aos != null) {
                aos.close();
            }
            ArTestCase.tryHardToDelete(archive);
            ArTestCase.tryHardToDelete(tmp[1]);
            ArTestCase.rmdir(tmp[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void XtestExplicitDirectoryEntry() throws Exception {
        File[] tmp = this.createTempDirAndFile();
        File archive = null;
        ArArchiveOutputStream aos = null;
        ArArchiveInputStream ais = null;
        try {
            archive = File.createTempFile("test.", ".ar", tmp[0]);
            archive.deleteOnExit();
            aos = new ArArchiveOutputStream((OutputStream)new FileOutputStream(archive));
            long beforeArchiveWrite = tmp[0].lastModified();
            ArArchiveEntry in = new ArArchiveEntry("foo", 0L, 0, 0, 0, tmp[1].lastModified() / 1000L);
            aos.putArchiveEntry((ArchiveEntry)in);
            aos.closeArchiveEntry();
            aos.close();
            aos = null;
            ais = new ArArchiveInputStream((InputStream)new FileInputStream(archive));
            ArArchiveEntry out = ais.getNextArEntry();
            ais.close();
            ais = null;
            ArTestCase.assertNotNull((Object)out);
            ArTestCase.assertEquals((String)"foo/", (String)out.getName());
            ArTestCase.assertEquals((long)0L, (long)out.getSize());
            ArTestCase.assertEquals((long)(beforeArchiveWrite / 1000L), (long)(out.getLastModifiedDate().getTime() / 1000L));
            ArTestCase.assertTrue((boolean)out.isDirectory());
        }
        finally {
            if (ais != null) {
                ais.close();
            }
            if (aos != null) {
                aos.close();
            }
            ArTestCase.tryHardToDelete(archive);
            ArTestCase.tryHardToDelete(tmp[1]);
            ArTestCase.rmdir(tmp[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testFileEntryFromFile() throws Exception {
        File[] tmp = this.createTempDirAndFile();
        File archive = null;
        ArArchiveOutputStream aos = null;
        ArArchiveInputStream ais = null;
        FileInputStream fis = null;
        try {
            archive = File.createTempFile("test.", ".ar", tmp[0]);
            archive.deleteOnExit();
            aos = new ArArchiveOutputStream((OutputStream)new FileOutputStream(archive));
            ArArchiveEntry in = new ArArchiveEntry(tmp[1], "foo");
            aos.putArchiveEntry((ArchiveEntry)in);
            byte[] b = new byte[(int)tmp[1].length()];
            fis = new FileInputStream(tmp[1]);
            while (fis.read(b) > 0) {
                aos.write(b);
            }
            fis.close();
            fis = null;
            aos.closeArchiveEntry();
            aos.close();
            aos = null;
            ais = new ArArchiveInputStream((InputStream)new FileInputStream(archive));
            ArArchiveEntry out = ais.getNextArEntry();
            ais.close();
            ais = null;
            ArTestCase.assertNotNull((Object)out);
            ArTestCase.assertEquals((String)"foo", (String)out.getName());
            ArTestCase.assertEquals((long)tmp[1].length(), (long)out.getSize());
            ArTestCase.assertEquals((long)(tmp[1].lastModified() / 1000L), (long)(out.getLastModifiedDate().getTime() / 1000L));
            ArTestCase.assertFalse((boolean)out.isDirectory());
        }
        finally {
            if (ais != null) {
                ais.close();
            }
            if (aos != null) {
                aos.close();
            }
            ArTestCase.tryHardToDelete(archive);
            if (fis != null) {
                fis.close();
            }
            ArTestCase.tryHardToDelete(tmp[1]);
            ArTestCase.rmdir(tmp[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testExplicitFileEntry() throws Exception {
        File[] tmp = this.createTempDirAndFile();
        File archive = null;
        ArArchiveOutputStream aos = null;
        ArArchiveInputStream ais = null;
        FileInputStream fis = null;
        try {
            archive = File.createTempFile("test.", ".ar", tmp[0]);
            archive.deleteOnExit();
            aos = new ArArchiveOutputStream((OutputStream)new FileOutputStream(archive));
            ArArchiveEntry in = new ArArchiveEntry("foo", tmp[1].length(), 0, 0, 0, tmp[1].lastModified() / 1000L);
            aos.putArchiveEntry((ArchiveEntry)in);
            byte[] b = new byte[(int)tmp[1].length()];
            fis = new FileInputStream(tmp[1]);
            while (fis.read(b) > 0) {
                aos.write(b);
            }
            fis.close();
            fis = null;
            aos.closeArchiveEntry();
            aos.close();
            aos = null;
            ais = new ArArchiveInputStream((InputStream)new FileInputStream(archive));
            ArArchiveEntry out = ais.getNextArEntry();
            ais.close();
            ais = null;
            ArTestCase.assertNotNull((Object)out);
            ArTestCase.assertEquals((String)"foo", (String)out.getName());
            ArTestCase.assertEquals((long)tmp[1].length(), (long)out.getSize());
            ArTestCase.assertEquals((long)(tmp[1].lastModified() / 1000L), (long)(out.getLastModifiedDate().getTime() / 1000L));
            ArTestCase.assertFalse((boolean)out.isDirectory());
        }
        finally {
            if (ais != null) {
                ais.close();
            }
            if (aos != null) {
                aos.close();
            }
            ArTestCase.tryHardToDelete(archive);
            if (fis != null) {
                fis.close();
            }
            ArTestCase.tryHardToDelete(tmp[1]);
            ArTestCase.rmdir(tmp[0]);
        }
    }
}

