/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.archivers;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.compress.AbstractTestCase;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.ArchiveOutputStream;
import org.apache.commons.compress.archivers.ar.ArArchiveEntry;
import org.apache.commons.compress.archivers.cpio.CpioArchiveEntry;
import org.apache.commons.compress.archivers.jar.JarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.utils.IOUtils;

public class ArchiveOutputStreamTest
extends AbstractTestCase {
    protected void setUp() throws Exception {
        super.setUp();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testFinish() throws Exception {
        ByteArrayOutputStream out1 = new ByteArrayOutputStream();
        ArchiveOutputStream aos1 = this.factory.createArchiveOutputStream("zip", (OutputStream)out1);
        aos1.putArchiveEntry((ArchiveEntry)new ZipArchiveEntry("dummy"));
        try {
            aos1.finish();
            ArchiveOutputStreamTest.fail((String)"After putArchive should follow closeArchive");
        }
        catch (IOException io) {
            // empty catch block
        }
        aos1 = this.factory.createArchiveOutputStream("jar", (OutputStream)out1);
        aos1.putArchiveEntry((ArchiveEntry)new JarArchiveEntry("dummy"));
        try {
            aos1.finish();
            ArchiveOutputStreamTest.fail((String)"After putArchive should follow closeArchive");
        }
        catch (IOException io) {
            // empty catch block
        }
        aos1 = this.factory.createArchiveOutputStream("ar", (OutputStream)out1);
        aos1.putArchiveEntry((ArchiveEntry)new ArArchiveEntry("dummy", 100L));
        try {
            aos1.finish();
            ArchiveOutputStreamTest.fail((String)"After putArchive should follow closeArchive");
        }
        catch (IOException io) {
            // empty catch block
        }
        aos1 = this.factory.createArchiveOutputStream("cpio", (OutputStream)out1);
        aos1.putArchiveEntry((ArchiveEntry)new CpioArchiveEntry("dummy"));
        try {
            aos1.finish();
            ArchiveOutputStreamTest.fail((String)"After putArchive should follow closeArchive");
        }
        catch (IOException io) {
            // empty catch block
        }
        aos1 = this.factory.createArchiveOutputStream("tar", (OutputStream)out1);
        aos1.putArchiveEntry((ArchiveEntry)new TarArchiveEntry("dummy"));
        try {
            aos1.finish();
            ArchiveOutputStreamTest.fail((String)"After putArchive should follow closeArchive");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void testOptionalFinish() throws Exception {
        ByteArrayOutputStream out1 = new ByteArrayOutputStream();
        ArchiveOutputStream aos1 = this.factory.createArchiveOutputStream("zip", (OutputStream)out1);
        aos1.putArchiveEntry((ArchiveEntry)new ZipArchiveEntry("dummy"));
        aos1.closeArchiveEntry();
        aos1.close();
        aos1 = this.factory.createArchiveOutputStream("jar", (OutputStream)out1);
        aos1.putArchiveEntry((ArchiveEntry)new JarArchiveEntry("dummy"));
        aos1.closeArchiveEntry();
        aos1.close();
        try {
            aos1.finish();
            ArchiveOutputStreamTest.fail((String)"finish() cannot follow close()");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void testCallSequenceAr() throws Exception {
        this.doCallSequence("Ar");
    }

    public void testCallSequenceCpio() throws Exception {
        this.doCallSequence("Cpio");
    }

    public void testCallSequenceJar() throws Exception {
        this.doCallSequence("Jar");
    }

    public void testCallSequenceTar() throws Exception {
        this.doCallSequence("Tar");
    }

    public void testCallSequenceZip() throws Exception {
        this.doCallSequence("Zip");
    }

    private void doCallSequence(String archiveType) throws Exception {
        ByteArrayOutputStream out1 = new ByteArrayOutputStream();
        File dummy = ArchiveOutputStreamTest.getFile("test1.xml");
        ArchiveOutputStream aos1 = this.factory.createArchiveOutputStream(archiveType, (OutputStream)out1);
        aos1.putArchiveEntry(aos1.createArchiveEntry(dummy, "dummy"));
        FileInputStream is = new FileInputStream(dummy);
        IOUtils.copy((InputStream)is, (OutputStream)aos1);
        ((InputStream)is).close();
        aos1.closeArchiveEntry();
        aos1.close();
        aos1 = this.factory.createArchiveOutputStream(archiveType, (OutputStream)out1);
        try {
            aos1.closeArchiveEntry();
            ArchiveOutputStreamTest.fail((String)"Should have raised IOException - closeArchiveEntry() called before putArchiveEntry()");
        }
        catch (IOException expected) {
            // empty catch block
        }
        aos1.putArchiveEntry(aos1.createArchiveEntry(dummy, "dummy"));
        is = new FileInputStream(dummy);
        IOUtils.copy((InputStream)is, (OutputStream)aos1);
        ((InputStream)is).close();
        try {
            aos1.finish();
            ArchiveOutputStreamTest.fail((String)"Should have raised IOException - finish() called before closeArchiveEntry()");
        }
        catch (IOException expected) {
            // empty catch block
        }
        try {
            aos1.close();
            ArchiveOutputStreamTest.fail((String)"Should have raised IOException - close() called before closeArchiveEntry()");
        }
        catch (IOException expected) {
            // empty catch block
        }
        aos1.closeArchiveEntry();
        try {
            aos1.closeArchiveEntry();
            ArchiveOutputStreamTest.fail((String)"Should have raised IOException - closeArchiveEntry() called with no open entry");
        }
        catch (IOException expected) {
            // empty catch block
        }
        aos1.finish();
        aos1.close();
        try {
            aos1.finish();
            ArchiveOutputStreamTest.fail((String)"Should have raised IOException - finish() called after close()");
        }
        catch (IOException expected) {
            // empty catch block
        }
    }
}

