/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.archivers;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.compress.archivers.ArchiveException;
import org.apache.commons.compress.archivers.ArchiveInputStream;
import org.apache.commons.compress.archivers.ArchiveStreamFactory;
import org.apache.commons.compress.archivers.StreamingNotSupportedException;
import org.apache.commons.compress.archivers.zip.ZipArchiveInputStream;
import org.junit.Assert;
import org.junit.Test;

public class ArchiveStreamFactoryTest {
    @Test
    public void shortTextFilesAreNoTARs() throws Exception {
        try {
            new ArchiveStreamFactory().createArchiveInputStream((InputStream)new ByteArrayInputStream("This certainly is not a tar archive, really, no kidding".getBytes()));
            Assert.fail((String)"created an input stream for a non-archive");
        }
        catch (ArchiveException ae) {
            Assert.assertTrue((boolean)ae.getMessage().startsWith("No Archiver found"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void aiffFilesAreNoTARs() throws Exception {
        FileInputStream fis = new FileInputStream("src/test/resources/testAIFF.aif");
        try {
            BufferedInputStream is = new BufferedInputStream(fis);
            try {
                new ArchiveStreamFactory().createArchiveInputStream((InputStream)is);
                Assert.fail((String)"created an input stream for a non-archive");
            }
            catch (ArchiveException ae) {
                Assert.assertTrue((boolean)ae.getMessage().startsWith("No Archiver found"));
            }
            finally {
                ((InputStream)is).close();
            }
        }
        finally {
            fis.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCOMPRESS209() throws Exception {
        FileInputStream fis = new FileInputStream("src/test/resources/testCompress209.doc");
        try {
            BufferedInputStream bis = new BufferedInputStream(fis);
            try {
                new ArchiveStreamFactory().createArchiveInputStream((InputStream)bis);
                Assert.fail((String)"created an input stream for a non-archive");
            }
            catch (ArchiveException ae) {
                Assert.assertTrue((boolean)ae.getMessage().startsWith("No Archiver found"));
            }
            finally {
                ((InputStream)bis).close();
            }
        }
        finally {
            fis.close();
        }
    }

    @Test(expected=StreamingNotSupportedException.class)
    public void cantRead7zFromStream() throws Exception {
        new ArchiveStreamFactory().createArchiveInputStream("7z", (InputStream)new ByteArrayInputStream(new byte[0]));
    }

    @Test(expected=StreamingNotSupportedException.class)
    public void cantWrite7zToStream() throws Exception {
        new ArchiveStreamFactory().createArchiveOutputStream("7z", (OutputStream)new ByteArrayOutputStream());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void detectsAndThrowsFor7z() throws Exception {
        FileInputStream fis = new FileInputStream("src/test/resources/bla.7z");
        try {
            BufferedInputStream bis = new BufferedInputStream(fis);
            try {
                new ArchiveStreamFactory().createArchiveInputStream((InputStream)bis);
                Assert.fail((String)"Expected a StreamingNotSupportedException");
            }
            catch (StreamingNotSupportedException ex) {
                Assert.assertEquals((Object)"7z", (Object)ex.getFormat());
            }
            finally {
                ((InputStream)bis).close();
            }
        }
        finally {
            fis.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void skipsPK00Prefix() throws Exception {
        FileInputStream fis = new FileInputStream("src/test/resources/COMPRESS-208.zip");
        try {
            BufferedInputStream bis = new BufferedInputStream(fis);
            try {
                ArchiveInputStream ais = new ArchiveStreamFactory().createArchiveInputStream((InputStream)bis);
                try {
                    Assert.assertTrue((boolean)(ais instanceof ZipArchiveInputStream));
                }
                finally {
                    ais.close();
                }
            }
            finally {
                ((InputStream)bis).close();
            }
        }
        finally {
            fis.close();
        }
    }
}

