/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.archivers;

import java.io.OutputStream;
import junit.framework.TestCase;
import org.apache.commons.compress.archivers.ArchiveException;
import org.apache.commons.compress.archivers.ArchiveStreamFactory;
import org.junit.Assert;

public class ExceptionMessageTest
extends TestCase {
    private static final String ARCHIVER_NULL_MESSAGE = "Archivername must not be null.";
    private static final String INPUTSTREAM_NULL_MESSAGE = "InputStream must not be null.";
    private static final String OUTPUTSTREAM_NULL_MESSAGE = "OutputStream must not be null.";

    public void testMessageWhenArchiverNameIsNull_1() {
        try {
            new ArchiveStreamFactory().createArchiveInputStream(null, System.in);
            ExceptionMessageTest.fail((String)"Should raise an IllegalArgumentException.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)ARCHIVER_NULL_MESSAGE, (Object)e.getMessage());
        }
        catch (ArchiveException e) {
            ExceptionMessageTest.fail((String)"ArchiveException not expected");
        }
    }

    public void testMessageWhenInputStreamIsNull() {
        try {
            new ArchiveStreamFactory().createArchiveInputStream("zip", null);
            ExceptionMessageTest.fail((String)"Should raise an IllegalArgumentException.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)INPUTSTREAM_NULL_MESSAGE, (Object)e.getMessage());
        }
        catch (ArchiveException e) {
            ExceptionMessageTest.fail((String)"ArchiveException not expected");
        }
    }

    public void testMessageWhenArchiverNameIsNull_2() {
        try {
            new ArchiveStreamFactory().createArchiveOutputStream(null, (OutputStream)System.out);
            ExceptionMessageTest.fail((String)"Should raise an IllegalArgumentException.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)ARCHIVER_NULL_MESSAGE, (Object)e.getMessage());
        }
        catch (ArchiveException e) {
            ExceptionMessageTest.fail((String)"ArchiveException not expected");
        }
    }

    public void testMessageWhenOutputStreamIsNull() {
        try {
            new ArchiveStreamFactory().createArchiveOutputStream("zip", null);
            ExceptionMessageTest.fail((String)"Should raise an IllegalArgumentException.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)OUTPUTSTREAM_NULL_MESSAGE, (Object)e.getMessage());
        }
        catch (ArchiveException e) {
            ExceptionMessageTest.fail((String)"ArchiveException not expected");
        }
    }
}

