/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.archivers;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.compress.AbstractTestCase;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.ArchiveInputStream;
import org.apache.commons.compress.archivers.ArchiveOutputStream;
import org.apache.commons.compress.archivers.ArchiveStreamFactory;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.utils.IOUtils;

public final class JarTestCase
extends AbstractTestCase {
    public void testJarArchiveCreation() throws Exception {
        File output = new File(this.dir, "bla.jar");
        File file1 = JarTestCase.getFile("test1.xml");
        File file2 = JarTestCase.getFile("test2.xml");
        FileOutputStream out = new FileOutputStream(output);
        ArchiveOutputStream os = new ArchiveStreamFactory().createArchiveOutputStream("jar", (OutputStream)out);
        os.putArchiveEntry((ArchiveEntry)new ZipArchiveEntry("testdata/test1.xml"));
        IOUtils.copy((InputStream)new FileInputStream(file1), (OutputStream)os);
        os.closeArchiveEntry();
        os.putArchiveEntry((ArchiveEntry)new ZipArchiveEntry("testdata/test2.xml"));
        IOUtils.copy((InputStream)new FileInputStream(file2), (OutputStream)os);
        os.closeArchiveEntry();
        os.close();
    }

    public void testJarUnarchive() throws Exception {
        File input = JarTestCase.getFile("bla.jar");
        FileInputStream is = new FileInputStream(input);
        ArchiveInputStream in = new ArchiveStreamFactory().createArchiveInputStream("jar", (InputStream)is);
        ZipArchiveEntry entry = (ZipArchiveEntry)in.getNextEntry();
        File o = new File(this.dir, entry.getName());
        o.getParentFile().mkdirs();
        FileOutputStream out = new FileOutputStream(o);
        IOUtils.copy((InputStream)in, (OutputStream)out);
        ((OutputStream)out).close();
        entry = (ZipArchiveEntry)in.getNextEntry();
        o = new File(this.dir, entry.getName());
        o.getParentFile().mkdirs();
        out = new FileOutputStream(o);
        IOUtils.copy((InputStream)in, (OutputStream)out);
        ((OutputStream)out).close();
        entry = (ZipArchiveEntry)in.getNextEntry();
        o = new File(this.dir, entry.getName());
        o.getParentFile().mkdirs();
        out = new FileOutputStream(o);
        IOUtils.copy((InputStream)in, (OutputStream)out);
        ((OutputStream)out).close();
        in.close();
        ((InputStream)is).close();
    }

    public void testJarUnarchiveAll() throws Exception {
        File input = JarTestCase.getFile("bla.jar");
        FileInputStream is = new FileInputStream(input);
        ArchiveInputStream in = new ArchiveStreamFactory().createArchiveInputStream("jar", (InputStream)is);
        ArchiveEntry entry = in.getNextEntry();
        while (entry != null) {
            File archiveEntry = new File(this.dir, entry.getName());
            archiveEntry.getParentFile().mkdirs();
            if (entry.isDirectory()) {
                archiveEntry.mkdir();
                entry = in.getNextEntry();
                continue;
            }
            FileOutputStream out = new FileOutputStream(archiveEntry);
            IOUtils.copy((InputStream)in, (OutputStream)out);
            ((OutputStream)out).close();
            entry = in.getNextEntry();
        }
        in.close();
        ((InputStream)is).close();
    }
}

