/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.archivers;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import junit.framework.AssertionFailedError;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.apache.commons.compress.AbstractTestCase;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.ArchiveInputStream;
import org.apache.commons.compress.archivers.ar.ArArchiveInputStream;
import org.apache.commons.compress.archivers.cpio.CpioArchiveInputStream;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.archivers.zip.ZipArchiveInputStream;

public class LongPathTest
extends AbstractTestCase {
    private String name;
    private File file;
    private static final Map<String, ArrayList<String>> fileLists = new HashMap<String, ArrayList<String>>();

    public LongPathTest(String name) {
        super(name);
    }

    private LongPathTest(String name, String function, File file) {
        super(function);
        this.name = name;
        this.file = file;
    }

    public static TestSuite suite() throws IOException {
        TestSuite suite = new TestSuite("LongPathTests");
        suite.addTest((Test)LongPathTest.createSuite("LongPathTest", "longpath"));
        suite.addTest((Test)LongPathTest.createSuite("LongSymlinkTest", "longsymlink"));
        return suite;
    }

    public static TestSuite createSuite(String name, String dirname) throws IOException {
        File[] files;
        String line;
        TestSuite suite = new TestSuite(name);
        File arcdir = LongPathTest.getFile(dirname);
        LongPathTest.assertTrue((boolean)arcdir.exists());
        File listing = new File(arcdir, "files.txt");
        LongPathTest.assertTrue((String)"File listing is readable", (boolean)listing.canRead());
        BufferedReader br = new BufferedReader(new FileReader(listing));
        ArrayList<String> fileList = new ArrayList<String>();
        while ((line = br.readLine()) != null) {
            if (line.startsWith("#")) continue;
            fileList.add(line);
        }
        fileLists.put(name, fileList);
        br.close();
        for (File file : files = arcdir.listFiles()) {
            if (file.getName().endsWith(".txt")) continue;
            TestSuite namedSuite = new TestSuite(file.getName());
            LongPathTest test = new LongPathTest(name, "testArchive", file);
            namedSuite.addTest((Test)test);
            suite.addTest((Test)namedSuite);
        }
        return suite;
    }

    protected String getExpectedString(ArchiveEntry entry) {
        TarArchiveEntry tarEntry;
        if (entry instanceof TarArchiveEntry && (tarEntry = (TarArchiveEntry)entry).isSymbolicLink()) {
            return tarEntry.getName() + " -> " + tarEntry.getLinkName();
        }
        return entry.getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testArchive() throws Exception {
        int i;
        ArrayList<String> fileList = fileLists.get(this.name);
        ArrayList expected = (ArrayList)fileList.clone();
        String name = this.file.getName();
        if ("minotaur.jar".equals(name) || "minotaur-0.jar".equals(name)) {
            expected.add("META-INF/");
            expected.add("META-INF/MANIFEST.MF");
        }
        ArchiveInputStream ais = this.factory.createArchiveInputStream((InputStream)new BufferedInputStream(new FileInputStream(this.file)));
        if (name.endsWith(".tar")) {
            LongPathTest.assertTrue((boolean)(ais instanceof TarArchiveInputStream));
        } else if (name.endsWith(".jar") || name.endsWith(".zip")) {
            LongPathTest.assertTrue((boolean)(ais instanceof ZipArchiveInputStream));
        } else if (name.endsWith(".cpio")) {
            LongPathTest.assertTrue((boolean)(ais instanceof CpioArchiveInputStream));
            for (i = 0; i < expected.size(); ++i) {
                String ent = (String)expected.get(i);
                if (!ent.endsWith("/")) continue;
                expected.set(i, ent.substring(0, ent.length() - 1));
            }
        } else if (name.endsWith(".ar")) {
            LongPathTest.assertTrue((boolean)(ais instanceof ArArchiveInputStream));
            expected.clear();
            for (i = 0; i < fileList.size(); ++i) {
                String ent = fileList.get(i);
                if (ent.endsWith("/")) continue;
                int lastSlash = ent.lastIndexOf(47);
                if (lastSlash >= 0) {
                    expected.add(ent.substring(lastSlash + 1, ent.length()));
                    continue;
                }
                expected.add(ent);
            }
        } else {
            LongPathTest.fail((String)("Unexpected file type: " + name));
        }
        try {
            this.checkArchiveContent(ais, (List<String>)expected);
        }
        catch (AssertionFailedError e) {
            LongPathTest.fail((String)("Error processing " + this.file.getName() + " " + (Object)((Object)e)));
        }
        finally {
            ais.close();
        }
    }
}

