/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.archivers;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import org.apache.commons.compress.AbstractTestCase;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.sevenz.SevenZArchiveEntry;
import org.apache.commons.compress.archivers.sevenz.SevenZFile;
import org.apache.commons.compress.archivers.sevenz.SevenZMethod;
import org.apache.commons.compress.archivers.sevenz.SevenZOutputFile;

public class SevenZTestCase
extends AbstractTestCase {
    public void testSevenZArchiveCreationUsingCopy() throws Exception {
        this.testSevenZArchiveCreation(SevenZMethod.COPY);
    }

    public void testSevenZArchiveCreationUsingLZMA2() throws Exception {
        this.testSevenZArchiveCreation(SevenZMethod.LZMA2);
    }

    public void testSevenZArchiveCreationUsingBZIP2() throws Exception {
        this.testSevenZArchiveCreation(SevenZMethod.BZIP2);
    }

    public void testSevenZArchiveCreationUsingDeflate() throws Exception {
        this.testSevenZArchiveCreation(SevenZMethod.DEFLATE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testSevenZArchiveCreation(SevenZMethod method) throws Exception {
        File output = new File(this.dir, "bla.7z");
        File file1 = SevenZTestCase.getFile("test1.xml");
        File file2 = SevenZTestCase.getFile("test2.xml");
        SevenZOutputFile outArchive = new SevenZOutputFile(output);
        outArchive.setContentCompression(method);
        try {
            SevenZArchiveEntry entry = outArchive.createArchiveEntry(file1, file1.getName());
            outArchive.putArchiveEntry((ArchiveEntry)entry);
            this.copy(file1, outArchive);
            outArchive.closeArchiveEntry();
            entry = outArchive.createArchiveEntry(file2, file2.getName());
            outArchive.putArchiveEntry((ArchiveEntry)entry);
            this.copy(file2, outArchive);
            outArchive.closeArchiveEntry();
        }
        finally {
            outArchive.close();
        }
        SevenZFile archive = new SevenZFile(output);
        try {
            SevenZArchiveEntry entry = archive.getNextEntry();
            assert (entry != null);
            SevenZTestCase.assertEquals((String)entry.getName(), (String)file1.getName());
            entry = archive.getNextEntry();
            assert (entry != null);
            SevenZTestCase.assertEquals((String)entry.getName(), (String)file2.getName());
            assert (archive.getNextEntry() == null);
        }
        finally {
            archive.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copy(File src, SevenZOutputFile dst) throws IOException {
        FileInputStream fis = null;
        try {
            int bytesRead;
            fis = new FileInputStream(src);
            byte[] buffer = new byte[8192];
            while ((bytesRead = fis.read(buffer)) >= 0) {
                dst.write(buffer, 0, bytesRead);
            }
        }
        finally {
            if (fis != null) {
                fis.close();
            }
        }
    }
}

