/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.archivers;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.compress.AbstractTestCase;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.ArchiveInputStream;
import org.apache.commons.compress.archivers.ArchiveOutputStream;
import org.apache.commons.compress.archivers.ArchiveStreamFactory;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.archivers.tar.TarArchiveOutputStream;
import org.apache.commons.compress.utils.IOUtils;

public final class TarTestCase
extends AbstractTestCase {
    public void testTarArchiveCreation() throws Exception {
        File output = new File(this.dir, "bla.tar");
        File file1 = TarTestCase.getFile("test1.xml");
        FileOutputStream out = new FileOutputStream(output);
        ArchiveOutputStream os = new ArchiveStreamFactory().createArchiveOutputStream("tar", (OutputStream)out);
        TarArchiveEntry entry = new TarArchiveEntry("testdata/test1.xml");
        entry.setModTime(0L);
        entry.setSize(file1.length());
        entry.setUserId(0);
        entry.setGroupId(0);
        entry.setUserName("avalon");
        entry.setGroupName("excalibur");
        entry.setMode(32768);
        os.putArchiveEntry((ArchiveEntry)entry);
        IOUtils.copy((InputStream)new FileInputStream(file1), (OutputStream)os);
        os.closeArchiveEntry();
        os.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testTarArchiveLongNameCreation() throws Exception {
        String name = "testdata/12345678901234567890123456789012345678901234567890123456789012345678901234567890123456.xml";
        byte[] bytes = name.getBytes("UTF-8");
        TarTestCase.assertEquals((int)bytes.length, (int)99);
        File output = new File(this.dir, "bla.tar");
        File file1 = TarTestCase.getFile("test1.xml");
        FileOutputStream out = new FileOutputStream(output);
        ArchiveOutputStream os = new ArchiveStreamFactory().createArchiveOutputStream("tar", (OutputStream)out);
        TarArchiveEntry entry = new TarArchiveEntry(name);
        entry.setModTime(0L);
        entry.setSize(file1.length());
        entry.setUserId(0);
        entry.setGroupId(0);
        entry.setUserName("avalon");
        entry.setGroupName("excalibur");
        entry.setMode(32768);
        os.putArchiveEntry((ArchiveEntry)entry);
        FileInputStream in = new FileInputStream(file1);
        IOUtils.copy((InputStream)in, (OutputStream)os);
        os.closeArchiveEntry();
        os.close();
        ((OutputStream)out).close();
        in.close();
        ArchiveOutputStream os2 = null;
        try {
            String toLongName = "testdata/123456789012345678901234567890123456789012345678901234567890123456789012345678901234567.xml";
            File output2 = new File(this.dir, "bla.tar");
            FileOutputStream out2 = new FileOutputStream(output2);
            os2 = new ArchiveStreamFactory().createArchiveOutputStream("tar", (OutputStream)out2);
            TarArchiveEntry entry2 = new TarArchiveEntry(toLongName);
            entry2.setModTime(0L);
            entry2.setSize(file1.length());
            entry2.setUserId(0);
            entry2.setGroupId(0);
            entry2.setUserName("avalon");
            entry2.setGroupName("excalibur");
            entry2.setMode(32768);
            os2.putArchiveEntry((ArchiveEntry)entry);
            IOUtils.copy((InputStream)new FileInputStream(file1), (OutputStream)os2);
            os2.closeArchiveEntry();
        }
        catch (IOException e) {
            TarTestCase.assertTrue((boolean)true);
        }
        finally {
            if (os2 != null) {
                os2.close();
            }
        }
    }

    public void testTarUnarchive() throws Exception {
        File input = TarTestCase.getFile("bla.tar");
        FileInputStream is = new FileInputStream(input);
        ArchiveInputStream in = new ArchiveStreamFactory().createArchiveInputStream("tar", (InputStream)is);
        TarArchiveEntry entry = (TarArchiveEntry)in.getNextEntry();
        FileOutputStream out = new FileOutputStream(new File(this.dir, entry.getName()));
        IOUtils.copy((InputStream)in, (OutputStream)out);
        in.close();
        ((OutputStream)out).close();
    }

    public void testCOMPRESS114() throws Exception {
        File input = TarTestCase.getFile("COMPRESS-114.tar");
        FileInputStream is = new FileInputStream(input);
        TarArchiveInputStream in = new TarArchiveInputStream((InputStream)is, "ISO-8859-1");
        TarArchiveEntry entry = (TarArchiveEntry)in.getNextEntry();
        TarTestCase.assertEquals((String)"3\u00b1\u00b1\u00b1F06\u00b1W2345\u00b1ZB\u00b1la\u00b1\u00b1\u00b1\u00b1\u00b1\u00b1\u00b1\u00b1BLA", (String)entry.getName());
        entry = (TarArchiveEntry)in.getNextEntry();
        TarTestCase.assertEquals((String)"0302-0601-3\u00b1\u00b1\u00b1F06\u00b1W2345\u00b1ZB\u00b1la\u00b1\u00b1\u00b1\u00b1\u00b1\u00b1\u00b1\u00b1BLA", (String)entry.getName());
        in.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDirectoryEntryFromFile() throws Exception {
        File[] tmp = this.createTempDirAndFile();
        File archive = null;
        TarArchiveOutputStream tos = null;
        TarArchiveInputStream tis = null;
        try {
            archive = File.createTempFile("test.", ".tar", tmp[0]);
            archive.deleteOnExit();
            tos = new TarArchiveOutputStream((OutputStream)new FileOutputStream(archive));
            long beforeArchiveWrite = tmp[0].lastModified();
            TarArchiveEntry in = new TarArchiveEntry(tmp[0], "foo");
            tos.putArchiveEntry((ArchiveEntry)in);
            tos.closeArchiveEntry();
            tos.close();
            tos = null;
            tis = new TarArchiveInputStream((InputStream)new FileInputStream(archive));
            TarArchiveEntry out = tis.getNextTarEntry();
            tis.close();
            tis = null;
            TarTestCase.assertNotNull((Object)out);
            TarTestCase.assertEquals((String)"foo/", (String)out.getName());
            TarTestCase.assertEquals((long)0L, (long)out.getSize());
            TarTestCase.assertEquals((long)(beforeArchiveWrite / 1000L), (long)(out.getLastModifiedDate().getTime() / 1000L));
            TarTestCase.assertTrue((boolean)out.isDirectory());
        }
        finally {
            if (tis != null) {
                tis.close();
            }
            if (tos != null) {
                tos.close();
            }
            TarTestCase.tryHardToDelete(archive);
            TarTestCase.tryHardToDelete(tmp[1]);
            TarTestCase.rmdir(tmp[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testExplicitDirectoryEntry() throws Exception {
        File[] tmp = this.createTempDirAndFile();
        File archive = null;
        TarArchiveOutputStream tos = null;
        TarArchiveInputStream tis = null;
        try {
            archive = File.createTempFile("test.", ".tar", tmp[0]);
            archive.deleteOnExit();
            tos = new TarArchiveOutputStream((OutputStream)new FileOutputStream(archive));
            long beforeArchiveWrite = tmp[0].lastModified();
            TarArchiveEntry in = new TarArchiveEntry("foo/");
            in.setModTime(beforeArchiveWrite);
            tos.putArchiveEntry((ArchiveEntry)in);
            tos.closeArchiveEntry();
            tos.close();
            tos = null;
            tis = new TarArchiveInputStream((InputStream)new FileInputStream(archive));
            TarArchiveEntry out = tis.getNextTarEntry();
            tis.close();
            tis = null;
            TarTestCase.assertNotNull((Object)out);
            TarTestCase.assertEquals((String)"foo/", (String)out.getName());
            TarTestCase.assertEquals((long)0L, (long)out.getSize());
            TarTestCase.assertEquals((long)(beforeArchiveWrite / 1000L), (long)(out.getLastModifiedDate().getTime() / 1000L));
            TarTestCase.assertTrue((boolean)out.isDirectory());
        }
        finally {
            if (tis != null) {
                tis.close();
            }
            if (tos != null) {
                tos.close();
            }
            TarTestCase.tryHardToDelete(archive);
            TarTestCase.tryHardToDelete(tmp[1]);
            TarTestCase.rmdir(tmp[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testFileEntryFromFile() throws Exception {
        File[] tmp = this.createTempDirAndFile();
        File archive = null;
        TarArchiveOutputStream tos = null;
        TarArchiveInputStream tis = null;
        FileInputStream fis = null;
        try {
            archive = File.createTempFile("test.", ".tar", tmp[0]);
            archive.deleteOnExit();
            tos = new TarArchiveOutputStream((OutputStream)new FileOutputStream(archive));
            TarArchiveEntry in = new TarArchiveEntry(tmp[1], "foo");
            tos.putArchiveEntry((ArchiveEntry)in);
            byte[] b = new byte[(int)tmp[1].length()];
            fis = new FileInputStream(tmp[1]);
            while (fis.read(b) > 0) {
                tos.write(b);
            }
            fis.close();
            fis = null;
            tos.closeArchiveEntry();
            tos.close();
            tos = null;
            tis = new TarArchiveInputStream((InputStream)new FileInputStream(archive));
            TarArchiveEntry out = tis.getNextTarEntry();
            tis.close();
            tis = null;
            TarTestCase.assertNotNull((Object)out);
            TarTestCase.assertEquals((String)"foo", (String)out.getName());
            TarTestCase.assertEquals((long)tmp[1].length(), (long)out.getSize());
            TarTestCase.assertEquals((long)(tmp[1].lastModified() / 1000L), (long)(out.getLastModifiedDate().getTime() / 1000L));
            TarTestCase.assertFalse((boolean)out.isDirectory());
        }
        finally {
            if (tis != null) {
                tis.close();
            }
            if (tos != null) {
                tos.close();
            }
            TarTestCase.tryHardToDelete(archive);
            if (fis != null) {
                fis.close();
            }
            TarTestCase.tryHardToDelete(tmp[1]);
            TarTestCase.rmdir(tmp[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testExplicitFileEntry() throws Exception {
        File[] tmp = this.createTempDirAndFile();
        File archive = null;
        TarArchiveOutputStream tos = null;
        TarArchiveInputStream tis = null;
        FileInputStream fis = null;
        try {
            archive = File.createTempFile("test.", ".tar", tmp[0]);
            archive.deleteOnExit();
            tos = new TarArchiveOutputStream((OutputStream)new FileOutputStream(archive));
            TarArchiveEntry in = new TarArchiveEntry("foo");
            in.setModTime(tmp[1].lastModified());
            in.setSize(tmp[1].length());
            tos.putArchiveEntry((ArchiveEntry)in);
            byte[] b = new byte[(int)tmp[1].length()];
            fis = new FileInputStream(tmp[1]);
            while (fis.read(b) > 0) {
                tos.write(b);
            }
            fis.close();
            fis = null;
            tos.closeArchiveEntry();
            tos.close();
            tos = null;
            tis = new TarArchiveInputStream((InputStream)new FileInputStream(archive));
            TarArchiveEntry out = tis.getNextTarEntry();
            tis.close();
            tis = null;
            TarTestCase.assertNotNull((Object)out);
            TarTestCase.assertEquals((String)"foo", (String)out.getName());
            TarTestCase.assertEquals((long)tmp[1].length(), (long)out.getSize());
            TarTestCase.assertEquals((long)(tmp[1].lastModified() / 1000L), (long)(out.getLastModifiedDate().getTime() / 1000L));
            TarTestCase.assertFalse((boolean)out.isDirectory());
        }
        finally {
            if (tis != null) {
                tis.close();
            }
            if (tos != null) {
                tos.close();
            }
            TarTestCase.tryHardToDelete(archive);
            if (fis != null) {
                fis.close();
            }
            TarTestCase.tryHardToDelete(tmp[1]);
            TarTestCase.rmdir(tmp[0]);
        }
    }

    public void testCOMPRESS178() throws Exception {
        File input = TarTestCase.getFile("COMPRESS-178.tar");
        FileInputStream is = new FileInputStream(input);
        ArchiveInputStream in = new ArchiveStreamFactory().createArchiveInputStream("tar", (InputStream)is);
        try {
            in.getNextEntry();
            TarTestCase.fail((String)"Expected IOException");
        }
        catch (IOException e) {
            Throwable t = e.getCause();
            TarTestCase.assertTrue((String)"Expected cause = IllegalArgumentException", (boolean)(t instanceof IllegalArgumentException));
        }
        in.close();
    }
}

