/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.archivers;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import org.apache.commons.compress.AbstractTestCase;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.ArchiveInputStream;
import org.apache.commons.compress.archivers.ArchiveOutputStream;
import org.apache.commons.compress.archivers.ArchiveStreamFactory;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveInputStream;
import org.apache.commons.compress.archivers.zip.ZipArchiveOutputStream;
import org.apache.commons.compress.archivers.zip.ZipFile;
import org.apache.commons.compress.archivers.zip.ZipMethod;
import org.apache.commons.compress.utils.IOUtils;

public final class ZipTestCase
extends AbstractTestCase {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testZipArchiveCreation() throws Exception {
        File output = new File(this.dir, "bla.zip");
        File file1 = ZipTestCase.getFile("test1.xml");
        File file2 = ZipTestCase.getFile("test2.xml");
        FileOutputStream out = new FileOutputStream(output);
        ArchiveOutputStream os = null;
        try {
            os = new ArchiveStreamFactory().createArchiveOutputStream("zip", (OutputStream)out);
            os.putArchiveEntry((ArchiveEntry)new ZipArchiveEntry("testdata/test1.xml"));
            IOUtils.copy((InputStream)new FileInputStream(file1), (OutputStream)os);
            os.closeArchiveEntry();
            os.putArchiveEntry((ArchiveEntry)new ZipArchiveEntry("testdata/test2.xml"));
            IOUtils.copy((InputStream)new FileInputStream(file2), (OutputStream)os);
            os.closeArchiveEntry();
        }
        finally {
            if (os != null) {
                os.close();
            }
        }
        ((OutputStream)out).close();
        ArrayList<File> results = new ArrayList<File>();
        FileInputStream is = new FileInputStream(output);
        ArchiveInputStream in = null;
        try {
            in = new ArchiveStreamFactory().createArchiveInputStream("zip", (InputStream)is);
            ZipArchiveEntry entry = null;
            while ((entry = (ZipArchiveEntry)in.getNextEntry()) != null) {
                File outfile = new File(this.resultDir.getCanonicalPath() + "/result/" + entry.getName());
                outfile.getParentFile().mkdirs();
                FileOutputStream o = new FileOutputStream(outfile);
                try {
                    IOUtils.copy((InputStream)in, (OutputStream)o);
                }
                finally {
                    ((OutputStream)o).close();
                }
                results.add(outfile);
            }
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
        ((InputStream)is).close();
        ZipTestCase.assertEquals((int)results.size(), (int)2);
        File result = (File)results.get(0);
        ZipTestCase.assertEquals((long)file1.length(), (long)result.length());
        result = (File)results.get(1);
        ZipTestCase.assertEquals((long)file2.length(), (long)result.length());
    }

    public void testZipUnarchive() throws Exception {
        File input = ZipTestCase.getFile("bla.zip");
        FileInputStream is = new FileInputStream(input);
        ArchiveInputStream in = new ArchiveStreamFactory().createArchiveInputStream("zip", (InputStream)is);
        ZipArchiveEntry entry = (ZipArchiveEntry)in.getNextEntry();
        FileOutputStream out = new FileOutputStream(new File(this.dir, entry.getName()));
        IOUtils.copy((InputStream)in, (OutputStream)out);
        ((OutputStream)out).close();
        in.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSkipsPK00Prefix() throws Exception {
        File input = ZipTestCase.getFile("COMPRESS-208.zip");
        FileInputStream is = new FileInputStream(input);
        ArrayList<String> al = new ArrayList<String>();
        al.add("test1.xml");
        al.add("test2.xml");
        try {
            this.checkArchiveContent((ArchiveInputStream)new ZipArchiveInputStream((InputStream)is), al);
        }
        finally {
            ((InputStream)is).close();
        }
    }

    public void testSupportedCompressionMethod() throws IOException {
        ZipFile moby = new ZipFile(ZipTestCase.getFile("moby.zip"));
        ZipArchiveEntry entry = moby.getEntry("README");
        ZipTestCase.assertEquals((String)"method", (int)ZipMethod.TOKENIZATION.getCode(), (int)entry.getMethod());
        ZipTestCase.assertFalse((boolean)moby.canReadEntryData(entry));
        moby.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSkipEntryWithUnsupportedCompressionMethod() throws IOException {
        ZipArchiveInputStream zip = new ZipArchiveInputStream((InputStream)new FileInputStream(ZipTestCase.getFile("moby.zip")));
        try {
            ZipArchiveEntry entry = zip.getNextZipEntry();
            ZipTestCase.assertEquals((String)"method", (int)ZipMethod.TOKENIZATION.getCode(), (int)entry.getMethod());
            ZipTestCase.assertEquals((String)"README", (String)entry.getName());
            ZipTestCase.assertFalse((boolean)zip.canReadEntryData((ArchiveEntry)entry));
            try {
                ZipTestCase.assertNull((Object)zip.getNextZipEntry());
            }
            catch (IOException e) {
                e.printStackTrace();
                ZipTestCase.fail((String)"COMPRESS-93: Unable to skip an unsupported zip entry");
            }
        }
        finally {
            zip.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testListAllFilesWithNestedArchive() throws Exception {
        File input = ZipTestCase.getFile("OSX_ArchiveWithNestedArchive.zip");
        ArrayList<String> results = new ArrayList<String>();
        FileInputStream is = new FileInputStream(input);
        ArchiveInputStream in = null;
        try {
            in = new ArchiveStreamFactory().createArchiveInputStream("zip", (InputStream)is);
            ZipArchiveEntry entry = null;
            while ((entry = (ZipArchiveEntry)in.getNextEntry()) != null) {
                results.add(entry.getName());
                ArchiveInputStream nestedIn = new ArchiveStreamFactory().createArchiveInputStream("zip", (InputStream)in);
                ZipArchiveEntry nestedEntry = null;
                while ((nestedEntry = (ZipArchiveEntry)nestedIn.getNextEntry()) != null) {
                    results.add(nestedEntry.getName());
                }
            }
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
        ((InputStream)is).close();
        results.contains("NestedArchiv.zip");
        results.contains("test1.xml");
        results.contains("test2.xml");
        results.contains("test3.xml");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDirectoryEntryFromFile() throws Exception {
        File[] tmp = this.createTempDirAndFile();
        File archive = null;
        ZipArchiveOutputStream zos = null;
        ZipFile zf = null;
        try {
            archive = File.createTempFile("test.", ".zip", tmp[0]);
            archive.deleteOnExit();
            zos = new ZipArchiveOutputStream(archive);
            long beforeArchiveWrite = tmp[0].lastModified();
            ZipArchiveEntry in = new ZipArchiveEntry(tmp[0], "foo");
            zos.putArchiveEntry((ArchiveEntry)in);
            zos.closeArchiveEntry();
            zos.close();
            zos = null;
            zf = new ZipFile(archive);
            ZipArchiveEntry out = zf.getEntry("foo/");
            ZipTestCase.assertNotNull((Object)out);
            ZipTestCase.assertEquals((String)"foo/", (String)out.getName());
            ZipTestCase.assertEquals((long)0L, (long)out.getSize());
            ZipTestCase.assertEquals((long)(beforeArchiveWrite / 2000L), (long)(out.getLastModifiedDate().getTime() / 2000L));
            ZipTestCase.assertTrue((boolean)out.isDirectory());
        }
        catch (Throwable throwable) {
            ZipFile.closeQuietly(zf);
            if (zos != null) {
                zos.close();
            }
            ZipTestCase.tryHardToDelete(archive);
            ZipTestCase.tryHardToDelete(tmp[1]);
            ZipTestCase.rmdir(tmp[0]);
            throw throwable;
        }
        ZipFile.closeQuietly((ZipFile)zf);
        if (zos != null) {
            zos.close();
        }
        ZipTestCase.tryHardToDelete(archive);
        ZipTestCase.tryHardToDelete(tmp[1]);
        ZipTestCase.rmdir(tmp[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testExplicitDirectoryEntry() throws Exception {
        File[] tmp = this.createTempDirAndFile();
        File archive = null;
        ZipArchiveOutputStream zos = null;
        ZipFile zf = null;
        try {
            archive = File.createTempFile("test.", ".zip", tmp[0]);
            archive.deleteOnExit();
            zos = new ZipArchiveOutputStream(archive);
            long beforeArchiveWrite = tmp[0].lastModified();
            ZipArchiveEntry in = new ZipArchiveEntry("foo/");
            in.setTime(beforeArchiveWrite);
            zos.putArchiveEntry((ArchiveEntry)in);
            zos.closeArchiveEntry();
            zos.close();
            zos = null;
            zf = new ZipFile(archive);
            ZipArchiveEntry out = zf.getEntry("foo/");
            ZipTestCase.assertNotNull((Object)out);
            ZipTestCase.assertEquals((String)"foo/", (String)out.getName());
            ZipTestCase.assertEquals((long)0L, (long)out.getSize());
            ZipTestCase.assertEquals((long)(beforeArchiveWrite / 2000L), (long)(out.getLastModifiedDate().getTime() / 2000L));
            ZipTestCase.assertTrue((boolean)out.isDirectory());
        }
        catch (Throwable throwable) {
            ZipFile.closeQuietly(zf);
            if (zos != null) {
                zos.close();
            }
            ZipTestCase.tryHardToDelete(archive);
            ZipTestCase.tryHardToDelete(tmp[1]);
            ZipTestCase.rmdir(tmp[0]);
            throw throwable;
        }
        ZipFile.closeQuietly((ZipFile)zf);
        if (zos != null) {
            zos.close();
        }
        ZipTestCase.tryHardToDelete(archive);
        ZipTestCase.tryHardToDelete(tmp[1]);
        ZipTestCase.rmdir(tmp[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testFileEntryFromFile() throws Exception {
        File[] tmp = this.createTempDirAndFile();
        File archive = null;
        ZipArchiveOutputStream zos = null;
        ZipFile zf = null;
        FileInputStream fis = null;
        try {
            archive = File.createTempFile("test.", ".zip", tmp[0]);
            archive.deleteOnExit();
            zos = new ZipArchiveOutputStream(archive);
            ZipArchiveEntry in = new ZipArchiveEntry(tmp[1], "foo");
            zos.putArchiveEntry((ArchiveEntry)in);
            byte[] b = new byte[(int)tmp[1].length()];
            fis = new FileInputStream(tmp[1]);
            while (fis.read(b) > 0) {
                zos.write(b);
            }
            fis.close();
            fis = null;
            zos.closeArchiveEntry();
            zos.close();
            zos = null;
            zf = new ZipFile(archive);
            ZipArchiveEntry out = zf.getEntry("foo");
            ZipTestCase.assertNotNull((Object)out);
            ZipTestCase.assertEquals((String)"foo", (String)out.getName());
            ZipTestCase.assertEquals((long)tmp[1].length(), (long)out.getSize());
            ZipTestCase.assertEquals((long)(tmp[1].lastModified() / 2000L), (long)(out.getLastModifiedDate().getTime() / 2000L));
            ZipTestCase.assertFalse((boolean)out.isDirectory());
        }
        catch (Throwable throwable) {
            ZipFile.closeQuietly(zf);
            if (zos != null) {
                zos.close();
            }
            ZipTestCase.tryHardToDelete(archive);
            if (fis != null) {
                fis.close();
            }
            ZipTestCase.tryHardToDelete(tmp[1]);
            ZipTestCase.rmdir(tmp[0]);
            throw throwable;
        }
        ZipFile.closeQuietly((ZipFile)zf);
        if (zos != null) {
            zos.close();
        }
        ZipTestCase.tryHardToDelete(archive);
        if (fis != null) {
            fis.close();
        }
        ZipTestCase.tryHardToDelete(tmp[1]);
        ZipTestCase.rmdir(tmp[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testExplicitFileEntry() throws Exception {
        File[] tmp = this.createTempDirAndFile();
        File archive = null;
        ZipArchiveOutputStream zos = null;
        ZipFile zf = null;
        FileInputStream fis = null;
        try {
            archive = File.createTempFile("test.", ".zip", tmp[0]);
            archive.deleteOnExit();
            zos = new ZipArchiveOutputStream(archive);
            ZipArchiveEntry in = new ZipArchiveEntry("foo");
            in.setTime(tmp[1].lastModified());
            in.setSize(tmp[1].length());
            zos.putArchiveEntry((ArchiveEntry)in);
            byte[] b = new byte[(int)tmp[1].length()];
            fis = new FileInputStream(tmp[1]);
            while (fis.read(b) > 0) {
                zos.write(b);
            }
            fis.close();
            fis = null;
            zos.closeArchiveEntry();
            zos.close();
            zos = null;
            zf = new ZipFile(archive);
            ZipArchiveEntry out = zf.getEntry("foo");
            ZipTestCase.assertNotNull((Object)out);
            ZipTestCase.assertEquals((String)"foo", (String)out.getName());
            ZipTestCase.assertEquals((long)tmp[1].length(), (long)out.getSize());
            ZipTestCase.assertEquals((long)(tmp[1].lastModified() / 2000L), (long)(out.getLastModifiedDate().getTime() / 2000L));
            ZipTestCase.assertFalse((boolean)out.isDirectory());
        }
        catch (Throwable throwable) {
            ZipFile.closeQuietly(zf);
            if (zos != null) {
                zos.close();
            }
            ZipTestCase.tryHardToDelete(archive);
            if (fis != null) {
                fis.close();
            }
            ZipTestCase.tryHardToDelete(tmp[1]);
            ZipTestCase.rmdir(tmp[0]);
            throw throwable;
        }
        ZipFile.closeQuietly((ZipFile)zf);
        if (zos != null) {
            zos.close();
        }
        ZipTestCase.tryHardToDelete(archive);
        if (fis != null) {
            fis.close();
        }
        ZipTestCase.tryHardToDelete(tmp[1]);
        ZipTestCase.rmdir(tmp[0]);
    }
}

