/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.archivers.ar;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.InputStream;
import org.apache.commons.compress.AbstractTestCase;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.ar.ArArchiveInputStream;
import org.apache.commons.compress.utils.ArchiveUtils;

public class ArArchiveInputStreamTest
extends AbstractTestCase {
    public void testReadLongNamesGNU() throws Exception {
        this.checkLongNameEntry("longfile_gnu.ar");
    }

    public void testReadLongNamesBSD() throws Exception {
        this.checkLongNameEntry("longfile_bsd.ar");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkLongNameEntry(String archive) throws Exception {
        FileInputStream fis = new FileInputStream(ArArchiveInputStreamTest.getFile(archive));
        ArArchiveInputStream s = null;
        try {
            s = new ArArchiveInputStream((InputStream)new BufferedInputStream(fis));
            ArchiveEntry e = s.getNextEntry();
            ArArchiveInputStreamTest.assertEquals((String)"this_is_a_long_file_name.txt", (String)e.getName());
            ArArchiveInputStreamTest.assertEquals((long)14L, (long)e.getSize());
            byte[] hello = new byte[14];
            s.read(hello);
            ArArchiveInputStreamTest.assertEquals((String)"Hello, world!\n", (String)ArchiveUtils.toAsciiString((byte[])hello));
            ArArchiveInputStreamTest.assertNull((Object)s.getNextEntry());
        }
        finally {
            if (s != null) {
                s.close();
            }
            fis.close();
        }
    }
}

