/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.archivers.arj;

import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Calendar;
import java.util.TimeZone;
import org.apache.commons.compress.AbstractTestCase;
import org.apache.commons.compress.archivers.arj.ArjArchiveEntry;
import org.apache.commons.compress.archivers.arj.ArjArchiveInputStream;

public class ArjArchiveInputStreamTest
extends AbstractTestCase {
    public void testArjUnarchive() throws Exception {
        ArjArchiveEntry entry;
        StringBuilder expected = new StringBuilder();
        expected.append("test1.xml<?xml version=\"1.0\"?>\n");
        expected.append("<empty/>test2.xml<?xml version=\"1.0\"?>\n");
        expected.append("<empty/>\n");
        ArjArchiveInputStream in = new ArjArchiveInputStream((InputStream)new FileInputStream(ArjArchiveInputStreamTest.getFile("bla.arj")));
        StringBuilder result = new StringBuilder();
        while ((entry = in.getNextEntry()) != null) {
            int tmp;
            result.append(entry.getName());
            while ((tmp = in.read()) != -1) {
                result.append((char)tmp);
            }
            ArjArchiveInputStreamTest.assertFalse((boolean)entry.isDirectory());
        }
        in.close();
        ArjArchiveInputStreamTest.assertEquals((String)result.toString(), (String)expected.toString());
    }

    public void testReadingOfAttributesDosVersion() throws Exception {
        ArjArchiveInputStream in = new ArjArchiveInputStream((InputStream)new FileInputStream(ArjArchiveInputStreamTest.getFile("bla.arj")));
        ArjArchiveEntry entry = in.getNextEntry();
        ArjArchiveInputStreamTest.assertEquals((String)"test1.xml", (String)entry.getName());
        ArjArchiveInputStreamTest.assertEquals((long)30L, (long)entry.getSize());
        ArjArchiveInputStreamTest.assertEquals((int)0, (int)entry.getUnixMode());
        Calendar cal = Calendar.getInstance();
        cal.set(2008, 9, 6, 23, 50, 52);
        cal.set(14, 0);
        ArjArchiveInputStreamTest.assertEquals((Object)cal.getTime(), (Object)entry.getLastModifiedDate());
    }

    public void testReadingOfAttributesUnixVersion() throws Exception {
        ArjArchiveInputStream in = new ArjArchiveInputStream((InputStream)new FileInputStream(ArjArchiveInputStreamTest.getFile("bla.unix.arj")));
        ArjArchiveEntry entry = in.getNextEntry();
        ArjArchiveInputStreamTest.assertEquals((String)"test1.xml", (String)entry.getName());
        ArjArchiveInputStreamTest.assertEquals((long)30L, (long)entry.getSize());
        ArjArchiveInputStreamTest.assertEquals((int)436, (int)(entry.getUnixMode() & 0xFFF));
        Calendar cal = Calendar.getInstance(TimeZone.getTimeZone("GMT+0000"));
        cal.set(2008, 9, 6, 21, 50, 52);
        cal.set(14, 0);
        ArjArchiveInputStreamTest.assertEquals((Object)cal.getTime(), (Object)entry.getLastModifiedDate());
    }
}

