/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.archivers.dump;

import java.io.FileInputStream;
import java.io.InputStream;
import org.apache.commons.compress.AbstractTestCase;
import org.apache.commons.compress.archivers.ArchiveException;
import org.apache.commons.compress.archivers.dump.DumpArchiveInputStream;
import org.apache.commons.compress.archivers.dump.ShortFileException;
import org.apache.commons.compress.archivers.dump.UnrecognizedFormatException;
import org.junit.Assert;

public class DumpArchiveInputStreamTest
extends AbstractTestCase {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testNotADumpArchive() throws Exception {
        FileInputStream is = new FileInputStream(DumpArchiveInputStreamTest.getFile("bla.zip"));
        try {
            new DumpArchiveInputStream((InputStream)is);
            DumpArchiveInputStreamTest.fail((String)"expected an exception");
        }
        catch (ArchiveException ex) {
            DumpArchiveInputStreamTest.assertTrue((boolean)(ex.getCause() instanceof ShortFileException));
        }
        finally {
            is.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testNotADumpArchiveButBigEnough() throws Exception {
        FileInputStream is = new FileInputStream(DumpArchiveInputStreamTest.getFile("zip64support.tar.bz2"));
        try {
            new DumpArchiveInputStream((InputStream)is);
            DumpArchiveInputStreamTest.fail((String)"expected an exception");
        }
        catch (ArchiveException ex) {
            DumpArchiveInputStreamTest.assertTrue((boolean)(ex.getCause() instanceof UnrecognizedFormatException));
        }
        finally {
            is.close();
        }
    }

    public void testConsumesArchiveCompletely() throws Exception {
        InputStream is = DumpArchiveInputStreamTest.class.getResourceAsStream("/archive_with_trailer.dump");
        DumpArchiveInputStream dump = new DumpArchiveInputStream(is);
        while (dump.getNextDumpEntry() != null) {
        }
        byte[] expected = new byte[]{72, 101, 108, 108, 111, 44, 32, 119, 111, 114, 108, 100, 33, 10};
        byte[] actual = new byte[expected.length];
        is.read(actual);
        Assert.assertArrayEquals((byte[])expected, (byte[])actual);
        dump.close();
    }
}

