/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.archivers.sevenz;

import java.io.File;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import javax.crypto.Cipher;
import org.apache.commons.compress.AbstractTestCase;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.sevenz.SevenZArchiveEntry;
import org.apache.commons.compress.archivers.sevenz.SevenZFile;
import org.apache.commons.compress.archivers.sevenz.SevenZMethod;
import org.apache.commons.compress.archivers.sevenz.SevenZMethodConfiguration;
import org.apache.commons.compress.archivers.sevenz.SevenZOutputFile;

public class SevenZFileTest
extends AbstractTestCase {
    private static final String TEST2_CONTENT = "<?xml version = '1.0'?>\r\n<!DOCTYPE connections>\r\n<meinxml>\r\n\t<leer />\r\n</meinxml>\n";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testAllEmptyFilesArchive() throws Exception {
        SevenZFile archive = new SevenZFile(SevenZFileTest.getFile("7z-empty-mhc-off.7z"));
        try {
            SevenZFileTest.assertNotNull((Object)archive.getNextEntry());
        }
        finally {
            archive.close();
        }
    }

    public void testHelloWorldHeaderCompressionOffCopy() throws Exception {
        this.checkHelloWorld("7z-hello-mhc-off-copy.7z");
    }

    public void testHelloWorldHeaderCompressionOffLZMA2() throws Exception {
        this.checkHelloWorld("7z-hello-mhc-off-lzma2.7z");
    }

    public void test7zUnarchive() throws Exception {
        this.test7zUnarchive(SevenZFileTest.getFile("bla.7z"), SevenZMethod.LZMA);
    }

    public void test7zDeflateUnarchive() throws Exception {
        this.test7zUnarchive(SevenZFileTest.getFile("bla.deflate.7z"), SevenZMethod.DEFLATE);
    }

    public void test7zDecryptUnarchive() throws Exception {
        if (SevenZFileTest.isStrongCryptoAvailable()) {
            this.test7zUnarchive(SevenZFileTest.getFile("bla.encrypted.7z"), SevenZMethod.LZMA, "foo".getBytes("UTF-16LE"));
        }
    }

    private void test7zUnarchive(File f, SevenZMethod m) throws Exception {
        this.test7zUnarchive(f, m, null);
    }

    public void testEncryptedArchiveRequiresPassword() throws Exception {
        try {
            new SevenZFile(SevenZFileTest.getFile("bla.encrypted.7z"));
            SevenZFileTest.fail((String)"shouldn't decrypt without a password");
        }
        catch (IOException ex) {
            SevenZFileTest.assertEquals((String)"Cannot read encrypted files without a password", (String)ex.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testCompressedHeaderWithNonDefaultDictionarySize() throws Exception {
        SevenZFile sevenZFile = new SevenZFile(SevenZFileTest.getFile("COMPRESS-256.7z"));
        try {
            int count = 0;
            while (sevenZFile.getNextEntry() != null) {
                ++count;
            }
            SevenZFileTest.assertEquals((int)446, (int)count);
        }
        finally {
            sevenZFile.close();
        }
    }

    public void testSignatureCheck() {
        SevenZFileTest.assertTrue((boolean)SevenZFile.matches((byte[])SevenZFile.sevenZSignature, (int)SevenZFile.sevenZSignature.length));
        SevenZFileTest.assertTrue((boolean)SevenZFile.matches((byte[])SevenZFile.sevenZSignature, (int)(SevenZFile.sevenZSignature.length + 1)));
        SevenZFileTest.assertFalse((boolean)SevenZFile.matches((byte[])SevenZFile.sevenZSignature, (int)(SevenZFile.sevenZSignature.length - 1)));
        SevenZFileTest.assertFalse((boolean)SevenZFile.matches((byte[])new byte[]{1, 2, 3, 4, 5, 6}, (int)6));
        SevenZFileTest.assertTrue((boolean)SevenZFile.matches((byte[])new byte[]{55, 122, -68, -81, 39, 28}, (int)6));
        SevenZFileTest.assertFalse((boolean)SevenZFile.matches((byte[])new byte[]{55, 122, -68, -81, 39, 29}, (int)6));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testReadingBackLZMA2DictSize() throws Exception {
        File output = new File(this.dir, "lzma2-dictsize.7z");
        SevenZOutputFile outArchive = new SevenZOutputFile(output);
        try {
            outArchive.setContentMethods(Arrays.asList(new SevenZMethodConfiguration(SevenZMethod.LZMA2, (Object)0x100000)));
            SevenZArchiveEntry entry = new SevenZArchiveEntry();
            entry.setName("foo.txt");
            outArchive.putArchiveEntry((ArchiveEntry)entry);
            outArchive.write(new byte[]{65});
            outArchive.closeArchiveEntry();
        }
        finally {
            outArchive.close();
        }
        SevenZFile archive = new SevenZFile(output);
        try {
            SevenZArchiveEntry entry = archive.getNextEntry();
            SevenZMethodConfiguration m = (SevenZMethodConfiguration)entry.getContentMethods().iterator().next();
            SevenZFileTest.assertEquals((Object)SevenZMethod.LZMA2, (Object)m.getMethod());
            SevenZFileTest.assertEquals((Object)0x100000, (Object)m.getOptions());
        }
        finally {
            archive.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testReadingBackDeltaDistance() throws Exception {
        File output = new File(this.dir, "delta-distance.7z");
        SevenZOutputFile outArchive = new SevenZOutputFile(output);
        try {
            outArchive.setContentMethods(Arrays.asList(new SevenZMethodConfiguration(SevenZMethod.DELTA_FILTER, (Object)32), new SevenZMethodConfiguration(SevenZMethod.LZMA2)));
            SevenZArchiveEntry entry = new SevenZArchiveEntry();
            entry.setName("foo.txt");
            outArchive.putArchiveEntry((ArchiveEntry)entry);
            outArchive.write(new byte[]{65});
            outArchive.closeArchiveEntry();
        }
        finally {
            outArchive.close();
        }
        SevenZFile archive = new SevenZFile(output);
        try {
            SevenZArchiveEntry entry = archive.getNextEntry();
            SevenZMethodConfiguration m = (SevenZMethodConfiguration)entry.getContentMethods().iterator().next();
            SevenZFileTest.assertEquals((Object)SevenZMethod.DELTA_FILTER, (Object)m.getMethod());
            SevenZFileTest.assertEquals((Object)32, (Object)m.getOptions());
        }
        finally {
            archive.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void test7zUnarchive(File f, SevenZMethod m, byte[] password) throws Exception {
        SevenZFile sevenZFile = new SevenZFile(f, password);
        try {
            int bytesRead;
            SevenZArchiveEntry entry = sevenZFile.getNextEntry();
            SevenZFileTest.assertEquals((String)"test1.xml", (String)entry.getName());
            SevenZFileTest.assertEquals((Object)m, (Object)((SevenZMethodConfiguration)entry.getContentMethods().iterator().next()).getMethod());
            entry = sevenZFile.getNextEntry();
            SevenZFileTest.assertEquals((String)"test2.xml", (String)entry.getName());
            SevenZFileTest.assertEquals((Object)m, (Object)((SevenZMethodConfiguration)entry.getContentMethods().iterator().next()).getMethod());
            byte[] contents = new byte[(int)entry.getSize()];
            for (int off = 0; off < contents.length; off += bytesRead) {
                bytesRead = sevenZFile.read(contents, off, contents.length - off);
                assert (bytesRead >= 0);
            }
            SevenZFileTest.assertEquals((String)TEST2_CONTENT, (String)new String(contents, "UTF-8"));
            SevenZFileTest.assertNull((Object)sevenZFile.getNextEntry());
        }
        finally {
            sevenZFile.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkHelloWorld(String filename) throws Exception {
        SevenZFile sevenZFile = new SevenZFile(SevenZFileTest.getFile(filename));
        try {
            int bytesRead;
            SevenZArchiveEntry entry = sevenZFile.getNextEntry();
            SevenZFileTest.assertEquals((String)"Hello world.txt", (String)entry.getName());
            byte[] contents = new byte[(int)entry.getSize()];
            for (int off = 0; off < contents.length; off += bytesRead) {
                bytesRead = sevenZFile.read(contents, off, contents.length - off);
                assert (bytesRead >= 0);
            }
            SevenZFileTest.assertEquals((String)"Hello, world!\n", (String)new String(contents, "UTF-8"));
            SevenZFileTest.assertNull((Object)sevenZFile.getNextEntry());
        }
        finally {
            sevenZFile.close();
        }
    }

    private static boolean isStrongCryptoAvailable() throws NoSuchAlgorithmException {
        return Cipher.getMaxAllowedKeyLength("AES/ECB/PKCS5Padding") >= 256;
    }
}

