/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.archivers.sevenz;

import org.apache.commons.compress.archivers.sevenz.SevenZMethod;
import org.apache.commons.compress.archivers.sevenz.SevenZMethodConfiguration;
import org.junit.Assert;
import org.junit.Test;
import org.tukaani.xz.LZMA2Options;

public class SevenZMethodConfigurationTest {
    @Test
    public void shouldAllowNullOptions() {
        Assert.assertNull((Object)new SevenZMethodConfiguration(SevenZMethod.LZMA2, null).getOptions());
    }

    @Test
    public void shouldAllowLZMA2OptionsForLZMA2() {
        Assert.assertNotNull((Object)new SevenZMethodConfiguration(SevenZMethod.LZMA2, (Object)new LZMA2Options()).getOptions());
    }

    @Test
    public void shouldAllowNumberForLZMA2() {
        Assert.assertNotNull((Object)new SevenZMethodConfiguration(SevenZMethod.LZMA2, (Object)42).getOptions());
    }

    @Test
    public void shouldAllowNumberForBzip2() {
        Assert.assertNotNull((Object)new SevenZMethodConfiguration(SevenZMethod.BZIP2, (Object)42).getOptions());
    }

    @Test
    public void shouldAllowNumberForDeflate() {
        Assert.assertNotNull((Object)new SevenZMethodConfiguration(SevenZMethod.DEFLATE, (Object)42).getOptions());
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldNotAllowStringOptionsForLZMA2() {
        new SevenZMethodConfiguration(SevenZMethod.LZMA2, (Object)"");
    }
}

