/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.archivers.sevenz;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import org.apache.commons.compress.AbstractTestCase;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.sevenz.SevenZArchiveEntry;
import org.apache.commons.compress.archivers.sevenz.SevenZFile;
import org.apache.commons.compress.archivers.sevenz.SevenZMethod;
import org.apache.commons.compress.archivers.sevenz.SevenZMethodConfiguration;
import org.apache.commons.compress.archivers.sevenz.SevenZOutputFile;
import org.tukaani.xz.LZMA2Options;
import org.tukaani.xz.XZ;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SevenZOutputFileTest
extends AbstractTestCase {
    private static final boolean XZ_BCJ_IS_BUGGY;
    private File output;

    @Override
    public void tearDown() throws Exception {
        if (this.output != null && !this.output.delete()) {
            this.output.deleteOnExit();
        }
        super.tearDown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDirectoriesAndEmptyFiles() throws Exception {
        this.output = new File(this.dir, "empties.7z");
        Date accessDate = new Date();
        Calendar cal = Calendar.getInstance();
        cal.add(10, -1);
        Date creationDate = cal.getTime();
        SevenZOutputFile outArchive = new SevenZOutputFile(this.output);
        try {
            SevenZArchiveEntry entry = outArchive.createArchiveEntry(this.dir, "foo/");
            outArchive.putArchiveEntry((ArchiveEntry)entry);
            outArchive.closeArchiveEntry();
            entry = new SevenZArchiveEntry();
            entry.setName("foo/bar");
            entry.setCreationDate(creationDate);
            entry.setAccessDate(accessDate);
            outArchive.putArchiveEntry((ArchiveEntry)entry);
            outArchive.write(new byte[0]);
            outArchive.closeArchiveEntry();
            entry = new SevenZArchiveEntry();
            entry.setName("xyzzy");
            outArchive.putArchiveEntry((ArchiveEntry)entry);
            outArchive.write(0);
            outArchive.closeArchiveEntry();
            entry = outArchive.createArchiveEntry(this.dir, "baz/");
            entry.setAntiItem(true);
            outArchive.putArchiveEntry((ArchiveEntry)entry);
            outArchive.closeArchiveEntry();
            entry = new SevenZArchiveEntry();
            entry.setName("dada");
            entry.setHasWindowsAttributes(true);
            entry.setWindowsAttributes(17);
            outArchive.putArchiveEntry((ArchiveEntry)entry);
            outArchive.write(5);
            outArchive.write(42);
            outArchive.closeArchiveEntry();
            outArchive.finish();
        }
        finally {
            outArchive.close();
        }
        SevenZFile archive = new SevenZFile(this.output);
        try {
            SevenZArchiveEntry entry = archive.getNextEntry();
            assert (entry != null);
            SevenZOutputFileTest.assertEquals((String)"foo/", (String)entry.getName());
            SevenZOutputFileTest.assertTrue((boolean)entry.isDirectory());
            SevenZOutputFileTest.assertFalse((boolean)entry.isAntiItem());
            entry = archive.getNextEntry();
            assert (entry != null);
            SevenZOutputFileTest.assertEquals((String)"foo/bar", (String)entry.getName());
            SevenZOutputFileTest.assertFalse((boolean)entry.isDirectory());
            SevenZOutputFileTest.assertFalse((boolean)entry.isAntiItem());
            SevenZOutputFileTest.assertEquals((long)0L, (long)entry.getSize());
            SevenZOutputFileTest.assertFalse((boolean)entry.getHasLastModifiedDate());
            SevenZOutputFileTest.assertEquals((Object)accessDate, (Object)entry.getAccessDate());
            SevenZOutputFileTest.assertEquals((Object)creationDate, (Object)entry.getCreationDate());
            entry = archive.getNextEntry();
            assert (entry != null);
            SevenZOutputFileTest.assertEquals((String)"xyzzy", (String)entry.getName());
            SevenZOutputFileTest.assertEquals((long)1L, (long)entry.getSize());
            SevenZOutputFileTest.assertFalse((boolean)entry.getHasAccessDate());
            SevenZOutputFileTest.assertFalse((boolean)entry.getHasCreationDate());
            SevenZOutputFileTest.assertEquals((int)0, (int)archive.read());
            entry = archive.getNextEntry();
            assert (entry != null);
            SevenZOutputFileTest.assertEquals((String)"baz/", (String)entry.getName());
            SevenZOutputFileTest.assertTrue((boolean)entry.isDirectory());
            SevenZOutputFileTest.assertTrue((boolean)entry.isAntiItem());
            entry = archive.getNextEntry();
            assert (entry != null);
            SevenZOutputFileTest.assertEquals((String)"dada", (String)entry.getName());
            SevenZOutputFileTest.assertEquals((long)2L, (long)entry.getSize());
            byte[] content = new byte[2];
            SevenZOutputFileTest.assertEquals((int)2, (int)archive.read(content));
            SevenZOutputFileTest.assertEquals((int)5, (int)content[0]);
            SevenZOutputFileTest.assertEquals((int)42, (int)content[1]);
            SevenZOutputFileTest.assertEquals((int)17, (int)entry.getWindowsAttributes());
            assert (archive.getNextEntry() == null);
        }
        finally {
            archive.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDirectoriesOnly() throws Exception {
        this.output = new File(this.dir, "dirs.7z");
        SevenZOutputFile outArchive = new SevenZOutputFile(this.output);
        try {
            SevenZArchiveEntry entry = new SevenZArchiveEntry();
            entry.setName("foo/");
            entry.setDirectory(true);
            outArchive.putArchiveEntry((ArchiveEntry)entry);
            outArchive.closeArchiveEntry();
        }
        finally {
            outArchive.close();
        }
        SevenZFile archive = new SevenZFile(this.output);
        try {
            SevenZArchiveEntry entry = archive.getNextEntry();
            assert (entry != null);
            SevenZOutputFileTest.assertEquals((String)"foo/", (String)entry.getName());
            SevenZOutputFileTest.assertTrue((boolean)entry.isDirectory());
            SevenZOutputFileTest.assertFalse((boolean)entry.isAntiItem());
            assert (archive.getNextEntry() == null);
        }
        finally {
            archive.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testCantFinishTwice() throws Exception {
        this.output = new File(this.dir, "finish.7z");
        SevenZOutputFile outArchive = new SevenZOutputFile(this.output);
        try {
            outArchive.finish();
            outArchive.finish();
            SevenZOutputFileTest.fail((String)"shouldn't be able to call finish twice");
        }
        catch (IOException ex) {
            SevenZOutputFileTest.assertEquals((String)"This archive has already been finished", (String)ex.getMessage());
        }
        finally {
            outArchive.close();
        }
    }

    public void testSixEmptyFiles() throws Exception {
        this.testCompress252(6, 0);
    }

    public void testSixFilesSomeNotEmpty() throws Exception {
        this.testCompress252(6, 2);
    }

    public void testSevenEmptyFiles() throws Exception {
        this.testCompress252(7, 0);
    }

    public void testSevenFilesSomeNotEmpty() throws Exception {
        this.testCompress252(7, 2);
    }

    public void testEightEmptyFiles() throws Exception {
        this.testCompress252(8, 0);
    }

    public void testEightFilesSomeNotEmpty() throws Exception {
        this.testCompress252(8, 2);
    }

    public void testNineEmptyFiles() throws Exception {
        this.testCompress252(9, 0);
    }

    public void testNineFilesSomeNotEmpty() throws Exception {
        this.testCompress252(9, 2);
    }

    public void testTwentyNineEmptyFiles() throws Exception {
        this.testCompress252(29, 0);
    }

    public void testTwentyNineFilesSomeNotEmpty() throws Exception {
        this.testCompress252(29, 7);
    }

    public void testCopyRoundtrip() throws Exception {
        this.testRoundTrip(SevenZMethod.COPY);
    }

    public void testBzip2Roundtrip() throws Exception {
        this.testRoundTrip(SevenZMethod.BZIP2);
    }

    public void testLzma2Roundtrip() throws Exception {
        this.testRoundTrip(SevenZMethod.LZMA2);
    }

    public void testDeflateRoundtrip() throws Exception {
        this.testRoundTrip(SevenZMethod.DEFLATE);
    }

    public void testBCJX86Roundtrip() throws Exception {
        if (XZ_BCJ_IS_BUGGY) {
            return;
        }
        this.testFilterRoundTrip(new SevenZMethodConfiguration(SevenZMethod.BCJ_X86_FILTER));
    }

    public void testBCJARMRoundtrip() throws Exception {
        if (XZ_BCJ_IS_BUGGY) {
            return;
        }
        this.testFilterRoundTrip(new SevenZMethodConfiguration(SevenZMethod.BCJ_ARM_FILTER));
    }

    public void testBCJARMThumbRoundtrip() throws Exception {
        if (XZ_BCJ_IS_BUGGY) {
            return;
        }
        this.testFilterRoundTrip(new SevenZMethodConfiguration(SevenZMethod.BCJ_ARM_THUMB_FILTER));
    }

    public void testBCJIA64Roundtrip() throws Exception {
        if (XZ_BCJ_IS_BUGGY) {
            return;
        }
        this.testFilterRoundTrip(new SevenZMethodConfiguration(SevenZMethod.BCJ_IA64_FILTER));
    }

    public void testBCJPPCRoundtrip() throws Exception {
        if (XZ_BCJ_IS_BUGGY) {
            return;
        }
        this.testFilterRoundTrip(new SevenZMethodConfiguration(SevenZMethod.BCJ_PPC_FILTER));
    }

    public void testBCJSparcRoundtrip() throws Exception {
        if (XZ_BCJ_IS_BUGGY) {
            return;
        }
        this.testFilterRoundTrip(new SevenZMethodConfiguration(SevenZMethod.BCJ_SPARC_FILTER));
    }

    public void testDeltaRoundtrip() throws Exception {
        this.testFilterRoundTrip(new SevenZMethodConfiguration(SevenZMethod.DELTA_FILTER));
    }

    public void testStackOfContentCompressions() throws Exception {
        this.output = new File(this.dir, "multiple-methods.7z");
        ArrayList<SevenZMethodConfiguration> methods = new ArrayList<SevenZMethodConfiguration>();
        methods.add(new SevenZMethodConfiguration(SevenZMethod.LZMA2));
        methods.add(new SevenZMethodConfiguration(SevenZMethod.COPY));
        methods.add(new SevenZMethodConfiguration(SevenZMethod.DEFLATE));
        methods.add(new SevenZMethodConfiguration(SevenZMethod.BZIP2));
        this.createAndReadBack(this.output, methods);
    }

    public void testDeflateWithConfiguration() throws Exception {
        this.output = new File(this.dir, "deflate-options.7z");
        this.createAndReadBack(this.output, Collections.singletonList(new SevenZMethodConfiguration(SevenZMethod.DEFLATE, (Object)1)));
    }

    public void testBzip2WithConfiguration() throws Exception {
        this.output = new File(this.dir, "bzip2-options.7z");
        this.createAndReadBack(this.output, Collections.singletonList(new SevenZMethodConfiguration(SevenZMethod.BZIP2, (Object)4)));
    }

    public void testLzma2WithIntConfiguration() throws Exception {
        this.output = new File(this.dir, "lzma2-options.7z");
        this.createAndReadBack(this.output, Collections.singletonList(new SevenZMethodConfiguration(SevenZMethod.LZMA2, (Object)0x100000)));
    }

    public void testLzma2WithOptionsConfiguration() throws Exception {
        this.output = new File(this.dir, "lzma2-options2.7z");
        LZMA2Options opts = new LZMA2Options(1);
        this.createAndReadBack(this.output, Collections.singletonList(new SevenZMethodConfiguration(SevenZMethod.LZMA2, (Object)opts)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testArchiveWithMixedMethods() throws Exception {
        this.output = new File(this.dir, "mixed-methods.7z");
        SevenZOutputFile outArchive = new SevenZOutputFile(this.output);
        try {
            this.addFile(outArchive, 0, true);
            this.addFile(outArchive, 1, true, Arrays.asList(new SevenZMethodConfiguration(SevenZMethod.BZIP2)));
        }
        finally {
            outArchive.close();
        }
        SevenZFile archive = new SevenZFile(this.output);
        try {
            SevenZOutputFileTest.assertEquals((Object)Boolean.TRUE, (Object)this.verifyFile(archive, 0, Arrays.asList(new SevenZMethodConfiguration(SevenZMethod.LZMA2))));
            SevenZOutputFileTest.assertEquals((Object)Boolean.TRUE, (Object)this.verifyFile(archive, 1, Arrays.asList(new SevenZMethodConfiguration(SevenZMethod.BZIP2))));
        }
        finally {
            archive.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testCompress252(int numberOfFiles, int numberOfNonEmptyFiles) throws Exception {
        int nonEmptyModulus = numberOfNonEmptyFiles != 0 ? numberOfFiles / numberOfNonEmptyFiles : numberOfFiles + 1;
        int nonEmptyFilesAdded = 0;
        this.output = new File(this.dir, "COMPRESS252-" + numberOfFiles + "-" + numberOfNonEmptyFiles + ".7z");
        SevenZOutputFile archive = new SevenZOutputFile(this.output);
        try {
            this.addDir(archive);
            for (int i = 0; i < numberOfFiles; ++i) {
                this.addFile(archive, i, (i + 1) % nonEmptyModulus == 0 && nonEmptyFilesAdded++ < numberOfNonEmptyFiles);
            }
        }
        finally {
            archive.close();
        }
        this.verifyCompress252(this.output, numberOfFiles, numberOfNonEmptyFiles);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void verifyCompress252(File output, int numberOfFiles, int numberOfNonEmptyFiles) throws Exception {
        SevenZFile archive = new SevenZFile(output);
        int filesFound = 0;
        int nonEmptyFilesFound = 0;
        try {
            this.verifyDir(archive);
            Boolean b = this.verifyFile(archive, filesFound++);
            while (b != null) {
                if (Boolean.TRUE.equals(b)) {
                    ++nonEmptyFilesFound;
                }
                b = this.verifyFile(archive, filesFound++);
            }
        }
        finally {
            archive.close();
        }
        SevenZOutputFileTest.assertEquals((int)(numberOfFiles + 1), (int)filesFound);
        SevenZOutputFileTest.assertEquals((int)numberOfNonEmptyFiles, (int)nonEmptyFilesFound);
    }

    private void addDir(SevenZOutputFile archive) throws Exception {
        SevenZArchiveEntry entry = archive.createArchiveEntry(this.dir, "foo/");
        archive.putArchiveEntry((ArchiveEntry)entry);
        archive.closeArchiveEntry();
    }

    private void verifyDir(SevenZFile archive) throws Exception {
        SevenZArchiveEntry entry = archive.getNextEntry();
        SevenZOutputFileTest.assertNotNull((Object)entry);
        SevenZOutputFileTest.assertEquals((String)"foo/", (String)entry.getName());
        SevenZOutputFileTest.assertTrue((boolean)entry.isDirectory());
    }

    private void addFile(SevenZOutputFile archive, int index, boolean nonEmpty) throws Exception {
        this.addFile(archive, index, nonEmpty, null);
    }

    private void addFile(SevenZOutputFile archive, int index, boolean nonEmpty, Iterable<SevenZMethodConfiguration> methods) throws Exception {
        byte[] byArray;
        SevenZArchiveEntry entry = new SevenZArchiveEntry();
        entry.setName("foo/" + index + ".txt");
        entry.setContentMethods(methods);
        archive.putArchiveEntry((ArchiveEntry)entry);
        if (nonEmpty) {
            byte[] byArray2 = new byte[1];
            byArray = byArray2;
            byArray2[0] = 65;
        } else {
            byArray = new byte[]{};
        }
        archive.write(byArray);
        archive.closeArchiveEntry();
    }

    private Boolean verifyFile(SevenZFile archive, int index) throws Exception {
        return this.verifyFile(archive, index, null);
    }

    private Boolean verifyFile(SevenZFile archive, int index, Iterable<SevenZMethodConfiguration> methods) throws Exception {
        SevenZArchiveEntry entry = archive.getNextEntry();
        if (entry == null) {
            return null;
        }
        SevenZOutputFileTest.assertEquals((String)("foo/" + index + ".txt"), (String)entry.getName());
        SevenZOutputFileTest.assertEquals((boolean)false, (boolean)entry.isDirectory());
        if (entry.getSize() == 0L) {
            return Boolean.FALSE;
        }
        SevenZOutputFileTest.assertEquals((long)1L, (long)entry.getSize());
        SevenZOutputFileTest.assertEquals((int)65, (int)archive.read());
        SevenZOutputFileTest.assertEquals((int)-1, (int)archive.read());
        if (methods != null) {
            SevenZOutputFileTest.assertContentMethodsEquals(methods, entry.getContentMethods());
        }
        return Boolean.TRUE;
    }

    private void testRoundTrip(SevenZMethod method) throws Exception {
        this.output = new File(this.dir, method + "-roundtrip.7z");
        ArrayList<SevenZMethodConfiguration> methods = new ArrayList<SevenZMethodConfiguration>();
        methods.add(new SevenZMethodConfiguration(method));
        this.createAndReadBack(this.output, methods);
    }

    private void testFilterRoundTrip(SevenZMethodConfiguration method) throws Exception {
        this.output = new File(this.dir, method.getMethod() + "-roundtrip.7z");
        ArrayList<SevenZMethodConfiguration> methods = new ArrayList<SevenZMethodConfiguration>();
        methods.add(method);
        methods.add(new SevenZMethodConfiguration(SevenZMethod.LZMA2));
        this.createAndReadBack(this.output, methods);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createAndReadBack(File output, Iterable<SevenZMethodConfiguration> methods) throws Exception {
        SevenZOutputFile outArchive = new SevenZOutputFile(output);
        outArchive.setContentMethods(methods);
        try {
            this.addFile(outArchive, 0, true);
        }
        finally {
            outArchive.close();
        }
        SevenZFile archive = new SevenZFile(output);
        try {
            SevenZOutputFileTest.assertEquals((Object)Boolean.TRUE, (Object)this.verifyFile(archive, 0, methods));
        }
        finally {
            archive.close();
        }
    }

    private static void assertContentMethodsEquals(Iterable<? extends SevenZMethodConfiguration> expected, Iterable<? extends SevenZMethodConfiguration> actual) {
        SevenZOutputFileTest.assertNotNull(actual);
        Iterator<? extends SevenZMethodConfiguration> expectedIter = expected.iterator();
        Iterator<? extends SevenZMethodConfiguration> actualIter = actual.iterator();
        while (expectedIter.hasNext()) {
            SevenZOutputFileTest.assertTrue((boolean)actualIter.hasNext());
            SevenZMethodConfiguration expConfig = expectedIter.next();
            SevenZMethodConfiguration actConfig = actualIter.next();
            SevenZOutputFileTest.assertEquals((Object)expConfig.getMethod(), (Object)actConfig.getMethod());
        }
        SevenZOutputFileTest.assertFalse((boolean)actualIter.hasNext());
    }

    static {
        String version = XZ.class.getPackage().getImplementationVersion();
        XZ_BCJ_IS_BUGGY = version.equals("1.4");
        if (XZ_BCJ_IS_BUGGY) {
            System.out.println("XZ version is " + version + " - skipping BCJ tests");
        }
    }
}

