/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.archivers.tar;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Locale;
import junit.framework.TestCase;
import org.apache.commons.compress.AbstractTestCase;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.archivers.tar.TarArchiveOutputStream;
import org.apache.commons.compress.archivers.tar.TarConstants;

public class TarArchiveEntryTest
extends TestCase
implements TarConstants {
    private static final String OS = System.getProperty("os.name").toLowerCase(Locale.ENGLISH);
    private static final String ROOT = OS.startsWith("windows") || OS.startsWith("netware") ? "C:\\" : "/";

    public void testFileSystemRoot() {
        TarArchiveEntry t = new TarArchiveEntry(new File(ROOT));
        TarArchiveEntryTest.assertEquals((String)"/", (String)t.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testTarFileWithFSRoot() throws IOException {
        File f = File.createTempFile("taetest", ".tar");
        f.deleteOnExit();
        TarArchiveOutputStream tout = null;
        TarArchiveInputStream tin = null;
        try {
            tout = new TarArchiveOutputStream((OutputStream)new FileOutputStream(f));
            TarArchiveEntry t = new TarArchiveEntry(new File(ROOT));
            tout.putArchiveEntry((ArchiveEntry)t);
            tout.closeArchiveEntry();
            t = new TarArchiveEntry(new File(new File(ROOT), "foo.txt"));
            t.setSize(6L);
            tout.putArchiveEntry((ArchiveEntry)t);
            tout.write(new byte[]{104, 101, 108, 108, 111, 32});
            tout.closeArchiveEntry();
            t = new TarArchiveEntry(new File(new File(ROOT), "bar.txt").getAbsolutePath());
            t.setSize(5L);
            tout.putArchiveEntry((ArchiveEntry)t);
            tout.write(new byte[]{119, 111, 114, 108, 100});
            tout.closeArchiveEntry();
            t = new TarArchiveEntry("dummy");
            t.setName(new File(new File(ROOT), "baz.txt").getAbsolutePath());
            t.setSize(1L);
            tout.putArchiveEntry((ArchiveEntry)t);
            tout.write(new byte[]{33});
            tout.closeArchiveEntry();
            tout.close();
            tout = null;
            tin = new TarArchiveInputStream((InputStream)new FileInputStream(f));
            t = tin.getNextTarEntry();
            TarArchiveEntryTest.assertNotNull((Object)t);
            TarArchiveEntryTest.assertEquals((String)"/", (String)t.getName());
            TarArchiveEntryTest.assertTrue((boolean)t.isCheckSumOK());
            t = tin.getNextTarEntry();
            TarArchiveEntryTest.assertNotNull((Object)t);
            TarArchiveEntryTest.assertEquals((String)"foo.txt", (String)t.getName());
            TarArchiveEntryTest.assertTrue((boolean)t.isCheckSumOK());
            t = tin.getNextTarEntry();
            TarArchiveEntryTest.assertNotNull((Object)t);
            TarArchiveEntryTest.assertEquals((String)"bar.txt", (String)t.getName());
            TarArchiveEntryTest.assertTrue((boolean)t.isCheckSumOK());
            t = tin.getNextTarEntry();
            TarArchiveEntryTest.assertNotNull((Object)t);
            TarArchiveEntryTest.assertEquals((String)"baz.txt", (String)t.getName());
            TarArchiveEntryTest.assertTrue((boolean)t.isCheckSumOK());
        }
        finally {
            if (tin != null) {
                tin.close();
            }
            if (tout != null) {
                tout.close();
            }
            AbstractTestCase.tryHardToDelete(f);
        }
    }

    public void testMaxFileSize() {
        TarArchiveEntry t = new TarArchiveEntry("");
        t.setSize(0L);
        t.setSize(1L);
        try {
            t.setSize(-1L);
            TarArchiveEntryTest.fail((String)"Should have generated IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        t.setSize(0x1FFFFFFFFL);
        t.setSize(0x200000000L);
    }

    public void testLinkFlagConstructor() {
        TarArchiveEntry t = new TarArchiveEntry("/foo", 76);
        this.assertGnuMagic(t);
        TarArchiveEntryTest.assertEquals((String)"foo", (String)t.getName());
    }

    public void testLinkFlagConstructorWithFileFlag() {
        TarArchiveEntry t = new TarArchiveEntry("/foo", 48);
        this.assertPosixMagic(t);
        TarArchiveEntryTest.assertEquals((String)"foo", (String)t.getName());
    }

    public void testLinkFlagConstructorWithPreserve() {
        TarArchiveEntry t = new TarArchiveEntry("/foo", 76, true);
        this.assertGnuMagic(t);
        TarArchiveEntryTest.assertEquals((String)"/foo", (String)t.getName());
    }

    private void assertGnuMagic(TarArchiveEntry t) {
        TarArchiveEntryTest.assertEquals((String)"ustar  \u0000", (String)this.readMagic(t));
    }

    private void assertPosixMagic(TarArchiveEntry t) {
        TarArchiveEntryTest.assertEquals((String)"ustar\u000000", (String)this.readMagic(t));
    }

    private String readMagic(TarArchiveEntry t) {
        byte[] buf = new byte[512];
        t.writeEntryHeader(buf);
        return new String(buf, 257, 8);
    }
}

