/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.archivers.tar;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import java.util.TimeZone;
import org.apache.commons.compress.AbstractTestCase;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.ArchiveOutputStream;
import org.apache.commons.compress.archivers.ArchiveStreamFactory;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.archivers.tar.TarArchiveOutputStream;
import org.apache.commons.compress.utils.IOUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TarArchiveOutputStreamTest
extends AbstractTestCase {
    public void testCount() throws Exception {
        File f = File.createTempFile("commons-compress-tarcount", ".tar");
        f.deleteOnExit();
        FileOutputStream fos = new FileOutputStream(f);
        ArchiveOutputStream tarOut = new ArchiveStreamFactory().createArchiveOutputStream("tar", (OutputStream)fos);
        File file1 = TarArchiveOutputStreamTest.getFile("test1.xml");
        TarArchiveEntry sEntry = new TarArchiveEntry(file1, file1.getName());
        tarOut.putArchiveEntry((ArchiveEntry)sEntry);
        FileInputStream in = new FileInputStream(file1);
        byte[] buf = new byte[8192];
        int read = 0;
        while ((read = in.read(buf)) > 0) {
            tarOut.write(buf, 0, read);
        }
        in.close();
        tarOut.closeArchiveEntry();
        tarOut.close();
        TarArchiveOutputStreamTest.assertEquals((long)f.length(), (long)tarOut.getBytesWritten());
    }

    public void testMaxFileSizeError() throws Exception {
        TarArchiveEntry t = new TarArchiveEntry("foo");
        t.setSize(0x1FFFFFFFFL);
        TarArchiveOutputStream tos = new TarArchiveOutputStream((OutputStream)new ByteArrayOutputStream());
        tos.putArchiveEntry((ArchiveEntry)t);
        t.setSize(0x200000000L);
        tos = new TarArchiveOutputStream((OutputStream)new ByteArrayOutputStream());
        try {
            tos.putArchiveEntry((ArchiveEntry)t);
            TarArchiveOutputStreamTest.fail((String)"Should have generated RuntimeException");
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    public void testBigNumberStarMode() throws Exception {
        TarArchiveEntry t = new TarArchiveEntry("foo");
        t.setSize(0x200000000L);
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        TarArchiveOutputStream tos = new TarArchiveOutputStream((OutputStream)bos);
        tos.setBigNumberMode(1);
        tos.putArchiveEntry((ArchiveEntry)t);
        tos.write(new byte[10240]);
        byte[] data = bos.toByteArray();
        TarArchiveOutputStreamTest.assertEquals((int)128, (int)(data[124] & 0x80));
        TarArchiveInputStream tin = new TarArchiveInputStream((InputStream)new ByteArrayInputStream(data));
        TarArchiveEntry e = tin.getNextTarEntry();
        TarArchiveOutputStreamTest.assertEquals((long)0x200000000L, (long)e.getSize());
        tin.close();
        this.closeQuietly((Closeable)tos);
    }

    public void testBigNumberPosixMode() throws Exception {
        TarArchiveEntry t = new TarArchiveEntry("foo");
        t.setSize(0x200000000L);
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        TarArchiveOutputStream tos = new TarArchiveOutputStream((OutputStream)bos);
        tos.setBigNumberMode(2);
        tos.putArchiveEntry((ArchiveEntry)t);
        tos.write(new byte[10240]);
        byte[] data = bos.toByteArray();
        TarArchiveOutputStreamTest.assertEquals((String)"00000000000 ", (String)new String(data, 1148, 12, "UTF-8"));
        TarArchiveInputStream tin = new TarArchiveInputStream((InputStream)new ByteArrayInputStream(data));
        TarArchiveEntry e = tin.getNextTarEntry();
        TarArchiveOutputStreamTest.assertEquals((long)0x200000000L, (long)e.getSize());
        tin.close();
        this.closeQuietly((Closeable)tos);
    }

    public void testWriteSimplePaxHeaders() throws Exception {
        HashMap<String, String> m = new HashMap<String, String>();
        m.put("a", "b");
        byte[] data = this.writePaxHeader(m);
        TarArchiveOutputStreamTest.assertEquals((String)"00000000006 ", (String)new String(data, 124, 12, "UTF-8"));
        TarArchiveOutputStreamTest.assertEquals((String)"6 a=b\n", (String)new String(data, 512, 6, "UTF-8"));
    }

    public void testPaxHeadersWithLength99() throws Exception {
        HashMap<String, String> m = new HashMap<String, String>();
        m.put("a", "012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012");
        byte[] data = this.writePaxHeader(m);
        TarArchiveOutputStreamTest.assertEquals((String)"00000000143 ", (String)new String(data, 124, 12, "UTF-8"));
        TarArchiveOutputStreamTest.assertEquals((String)"99 a=012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012\n", (String)new String(data, 512, 99, "UTF-8"));
    }

    public void testPaxHeadersWithLength101() throws Exception {
        HashMap<String, String> m = new HashMap<String, String>();
        m.put("a", "0123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123");
        byte[] data = this.writePaxHeader(m);
        TarArchiveOutputStreamTest.assertEquals((String)"00000000145 ", (String)new String(data, 124, 12, "UTF-8"));
        TarArchiveOutputStreamTest.assertEquals((String)"101 a=0123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123\n", (String)new String(data, 512, 101, "UTF-8"));
    }

    private byte[] writePaxHeader(Map<String, String> m) throws Exception {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        TarArchiveOutputStream tos = new TarArchiveOutputStream((OutputStream)bos, "ASCII");
        tos.writePaxHeaders("foo", m);
        TarArchiveEntry t = new TarArchiveEntry("foo");
        t.setSize(10240L);
        tos.putArchiveEntry((ArchiveEntry)t);
        tos.write(new byte[10240]);
        tos.closeArchiveEntry();
        tos.close();
        return bos.toByteArray();
    }

    public void testWriteLongFileNamePosixMode() throws Exception {
        String n = "012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789";
        TarArchiveEntry t = new TarArchiveEntry(n);
        t.setSize(10240L);
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        TarArchiveOutputStream tos = new TarArchiveOutputStream((OutputStream)bos, "ASCII");
        tos.setLongFileMode(3);
        tos.putArchiveEntry((ArchiveEntry)t);
        tos.write(new byte[10240]);
        tos.closeArchiveEntry();
        byte[] data = bos.toByteArray();
        TarArchiveOutputStreamTest.assertEquals((String)("160 path=" + n + "\n"), (String)new String(data, 512, 160, "UTF-8"));
        TarArchiveInputStream tin = new TarArchiveInputStream((InputStream)new ByteArrayInputStream(data));
        TarArchiveEntry e = tin.getNextTarEntry();
        TarArchiveOutputStreamTest.assertEquals((String)n, (String)e.getName());
        tin.close();
        tos.close();
    }

    public void testOldEntryStarMode() throws Exception {
        TarArchiveEntry t = new TarArchiveEntry("foo");
        t.setSize(Integer.MAX_VALUE);
        t.setModTime(-1000L);
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        TarArchiveOutputStream tos = new TarArchiveOutputStream((OutputStream)bos);
        tos.setBigNumberMode(1);
        tos.putArchiveEntry((ArchiveEntry)t);
        tos.write(new byte[10240]);
        byte[] data = bos.toByteArray();
        TarArchiveOutputStreamTest.assertEquals((byte)-1, (byte)data[136]);
        TarArchiveInputStream tin = new TarArchiveInputStream((InputStream)new ByteArrayInputStream(data));
        TarArchiveEntry e = tin.getNextTarEntry();
        Calendar cal = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
        cal.set(1969, 11, 31, 23, 59, 59);
        cal.set(14, 0);
        TarArchiveOutputStreamTest.assertEquals((Object)cal.getTime(), (Object)e.getLastModifiedDate());
        tin.close();
        this.closeQuietly((Closeable)tos);
    }

    public void testOldEntryPosixMode() throws Exception {
        TarArchiveEntry t = new TarArchiveEntry("foo");
        t.setSize(Integer.MAX_VALUE);
        t.setModTime(-1000L);
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        TarArchiveOutputStream tos = new TarArchiveOutputStream((OutputStream)bos);
        tos.setBigNumberMode(2);
        tos.putArchiveEntry((ArchiveEntry)t);
        tos.write(new byte[10240]);
        byte[] data = bos.toByteArray();
        TarArchiveOutputStreamTest.assertEquals((String)"00000000000 ", (String)new String(data, 1160, 12, "UTF-8"));
        TarArchiveInputStream tin = new TarArchiveInputStream((InputStream)new ByteArrayInputStream(data));
        TarArchiveEntry e = tin.getNextTarEntry();
        Calendar cal = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
        cal.set(1969, 11, 31, 23, 59, 59);
        cal.set(14, 0);
        TarArchiveOutputStreamTest.assertEquals((Object)cal.getTime(), (Object)e.getLastModifiedDate());
        tin.close();
        this.closeQuietly((Closeable)tos);
    }

    public void testOldEntryError() throws Exception {
        TarArchiveEntry t = new TarArchiveEntry("foo");
        t.setSize(Integer.MAX_VALUE);
        t.setModTime(-1000L);
        TarArchiveOutputStream tos = new TarArchiveOutputStream((OutputStream)new ByteArrayOutputStream());
        try {
            tos.putArchiveEntry((ArchiveEntry)t);
            TarArchiveOutputStreamTest.fail((String)"Should have generated RuntimeException");
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        tos.close();
    }

    public void testWriteNonAsciiPathNamePaxHeader() throws Exception {
        String n = "\u00e4";
        TarArchiveEntry t = new TarArchiveEntry(n);
        t.setSize(10240L);
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        TarArchiveOutputStream tos = new TarArchiveOutputStream((OutputStream)bos);
        tos.setAddPaxHeadersForNonAsciiNames(true);
        tos.putArchiveEntry((ArchiveEntry)t);
        tos.write(new byte[10240]);
        tos.closeArchiveEntry();
        tos.close();
        byte[] data = bos.toByteArray();
        TarArchiveOutputStreamTest.assertEquals((String)("11 path=" + n + "\n"), (String)new String(data, 512, 11, "UTF-8"));
        TarArchiveInputStream tin = new TarArchiveInputStream((InputStream)new ByteArrayInputStream(data));
        TarArchiveEntry e = tin.getNextTarEntry();
        TarArchiveOutputStreamTest.assertEquals((String)n, (String)e.getName());
        tin.close();
    }

    public void testWriteNonAsciiLinkPathNamePaxHeader() throws Exception {
        String n = "\u00e4";
        TarArchiveEntry t = new TarArchiveEntry("a", 49);
        t.setSize(10240L);
        t.setLinkName(n);
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        TarArchiveOutputStream tos = new TarArchiveOutputStream((OutputStream)bos);
        tos.setAddPaxHeadersForNonAsciiNames(true);
        tos.putArchiveEntry((ArchiveEntry)t);
        tos.write(new byte[10240]);
        tos.closeArchiveEntry();
        tos.close();
        byte[] data = bos.toByteArray();
        TarArchiveOutputStreamTest.assertEquals((String)("15 linkpath=" + n + "\n"), (String)new String(data, 512, 15, "UTF-8"));
        TarArchiveInputStream tin = new TarArchiveInputStream((InputStream)new ByteArrayInputStream(data));
        TarArchiveEntry e = tin.getNextTarEntry();
        TarArchiveOutputStreamTest.assertEquals((String)n, (String)e.getLinkName());
        tin.close();
    }

    public void testRoundtripWith67CharFileNameGnu() throws Exception {
        this.testRoundtripWith67CharFileName(2);
    }

    public void testRoundtripWith67CharFileNamePosix() throws Exception {
        this.testRoundtripWith67CharFileName(3);
    }

    private void testRoundtripWith67CharFileName(int mode) throws Exception {
        String n = "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA";
        TarArchiveOutputStreamTest.assertEquals((int)67, (int)n.length());
        TarArchiveEntry t = new TarArchiveEntry(n);
        t.setSize(10240L);
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        TarArchiveOutputStream tos = new TarArchiveOutputStream((OutputStream)bos, "ASCII");
        tos.setLongFileMode(mode);
        tos.putArchiveEntry((ArchiveEntry)t);
        tos.write(new byte[10240]);
        tos.closeArchiveEntry();
        tos.close();
        byte[] data = bos.toByteArray();
        TarArchiveInputStream tin = new TarArchiveInputStream((InputStream)new ByteArrayInputStream(data));
        TarArchiveEntry e = tin.getNextTarEntry();
        TarArchiveOutputStreamTest.assertEquals((String)n, (String)e.getName());
        tin.close();
    }

    public void testWriteLongDirectoryNameErrorMode() throws Exception {
        String n = "012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789/";
        try {
            TarArchiveEntry t = new TarArchiveEntry(n);
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            TarArchiveOutputStream tos = new TarArchiveOutputStream((OutputStream)bos, "ASCII");
            tos.setLongFileMode(0);
            tos.putArchiveEntry((ArchiveEntry)t);
            tos.closeArchiveEntry();
            tos.close();
            TarArchiveOutputStreamTest.fail((String)"Truncated name didn't throw an exception");
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    public void testWriteLongDirectoryNameTruncateMode() throws Exception {
        String n = "012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789/";
        TarArchiveEntry t = new TarArchiveEntry(n);
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        TarArchiveOutputStream tos = new TarArchiveOutputStream((OutputStream)bos, "ASCII");
        tos.setLongFileMode(1);
        tos.putArchiveEntry((ArchiveEntry)t);
        tos.closeArchiveEntry();
        tos.close();
        byte[] data = bos.toByteArray();
        TarArchiveInputStream tin = new TarArchiveInputStream((InputStream)new ByteArrayInputStream(data));
        TarArchiveEntry e = tin.getNextTarEntry();
        TarArchiveOutputStreamTest.assertEquals((String)"Entry name", (String)(n.substring(0, 100) + "/"), (String)e.getName());
        TarArchiveOutputStreamTest.assertTrue((String)"The entry is not a directory", (boolean)e.isDirectory());
        tin.close();
    }

    public void testWriteLongDirectoryNameGnuMode() throws Exception {
        this.testWriteLongDirectoryName(2);
    }

    public void testWriteLongDirectoryNamePosixMode() throws Exception {
        this.testWriteLongDirectoryName(3);
    }

    private void testWriteLongDirectoryName(int mode) throws Exception {
        String n = "012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789/";
        TarArchiveEntry t = new TarArchiveEntry(n);
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        TarArchiveOutputStream tos = new TarArchiveOutputStream((OutputStream)bos, "ASCII");
        tos.setLongFileMode(mode);
        tos.putArchiveEntry((ArchiveEntry)t);
        tos.closeArchiveEntry();
        tos.close();
        byte[] data = bos.toByteArray();
        TarArchiveInputStream tin = new TarArchiveInputStream((InputStream)new ByteArrayInputStream(data));
        TarArchiveEntry e = tin.getNextTarEntry();
        TarArchiveOutputStreamTest.assertEquals((String)n, (String)e.getName());
        TarArchiveOutputStreamTest.assertTrue((boolean)e.isDirectory());
        tin.close();
    }

    public void testWriteNonAsciiDirectoryNamePosixMode() throws Exception {
        String n = "f\u00f6\u00f6/";
        TarArchiveEntry t = new TarArchiveEntry(n);
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        TarArchiveOutputStream tos = new TarArchiveOutputStream((OutputStream)bos);
        tos.setAddPaxHeadersForNonAsciiNames(true);
        tos.putArchiveEntry((ArchiveEntry)t);
        tos.closeArchiveEntry();
        tos.close();
        byte[] data = bos.toByteArray();
        TarArchiveInputStream tin = new TarArchiveInputStream((InputStream)new ByteArrayInputStream(data));
        TarArchiveEntry e = tin.getNextTarEntry();
        TarArchiveOutputStreamTest.assertEquals((String)n, (String)e.getName());
        TarArchiveOutputStreamTest.assertTrue((boolean)e.isDirectory());
        tin.close();
    }

    public void testWriteNonAsciiNameWithUnfortunateNamePosixMode() throws Exception {
        String n = "f\u00f6\u00f6\u00dc";
        TarArchiveEntry t = new TarArchiveEntry(n);
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        TarArchiveOutputStream tos = new TarArchiveOutputStream((OutputStream)bos);
        tos.setAddPaxHeadersForNonAsciiNames(true);
        tos.putArchiveEntry((ArchiveEntry)t);
        tos.closeArchiveEntry();
        tos.close();
        byte[] data = bos.toByteArray();
        TarArchiveInputStream tin = new TarArchiveInputStream((InputStream)new ByteArrayInputStream(data));
        TarArchiveEntry e = tin.getNextTarEntry();
        TarArchiveOutputStreamTest.assertEquals((String)n, (String)e.getName());
        TarArchiveOutputStreamTest.assertFalse((boolean)e.isDirectory());
        tin.close();
    }

    public void testWriteLongLinkNameErrorMode() throws Exception {
        String linkname = "012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789/test";
        TarArchiveEntry entry = new TarArchiveEntry("test", 50);
        entry.setLinkName(linkname);
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            TarArchiveOutputStream tos = new TarArchiveOutputStream((OutputStream)bos, "ASCII");
            tos.setLongFileMode(0);
            tos.putArchiveEntry((ArchiveEntry)entry);
            tos.closeArchiveEntry();
            tos.close();
            TarArchiveOutputStreamTest.fail((String)"Truncated link name didn't throw an exception");
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    public void testWriteLongLinkNameTruncateMode() throws Exception {
        String linkname = "012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789/";
        TarArchiveEntry entry = new TarArchiveEntry("test", 50);
        entry.setLinkName(linkname);
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        TarArchiveOutputStream tos = new TarArchiveOutputStream((OutputStream)bos, "ASCII");
        tos.setLongFileMode(1);
        tos.putArchiveEntry((ArchiveEntry)entry);
        tos.closeArchiveEntry();
        tos.close();
        byte[] data = bos.toByteArray();
        TarArchiveInputStream tin = new TarArchiveInputStream((InputStream)new ByteArrayInputStream(data));
        TarArchiveEntry e = tin.getNextTarEntry();
        TarArchiveOutputStreamTest.assertEquals((String)"Link name", (String)linkname.substring(0, 100), (String)e.getLinkName());
        tin.close();
    }

    public void testWriteLongLinkNameGnuMode() throws Exception {
        this.testWriteLongLinkName(2);
    }

    public void testWriteLongLinkNamePosixMode() throws Exception {
        this.testWriteLongLinkName(3);
    }

    public void testWriteLongLinkName(int mode) throws Exception {
        String linkname = "012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789/test";
        TarArchiveEntry entry = new TarArchiveEntry("test", 50);
        entry.setLinkName(linkname);
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        TarArchiveOutputStream tos = new TarArchiveOutputStream((OutputStream)bos, "ASCII");
        tos.setLongFileMode(mode);
        tos.putArchiveEntry((ArchiveEntry)entry);
        tos.closeArchiveEntry();
        tos.close();
        byte[] data = bos.toByteArray();
        TarArchiveInputStream tin = new TarArchiveInputStream((InputStream)new ByteArrayInputStream(data));
        TarArchiveEntry e = tin.getNextTarEntry();
        TarArchiveOutputStreamTest.assertEquals((String)"Entry name", (String)"test", (String)e.getName());
        TarArchiveOutputStreamTest.assertEquals((String)"Link name", (String)linkname, (String)e.getLinkName());
        TarArchiveOutputStreamTest.assertTrue((String)"The entry is not a symbolic link", (boolean)e.isSymbolicLink());
        tin.close();
    }

    public void testPadsOutputToFullBlockLength() throws Exception {
        File f = File.createTempFile("commons-compress-padding", ".tar");
        f.deleteOnExit();
        FileOutputStream fos = new FileOutputStream(f);
        TarArchiveOutputStream tos = new TarArchiveOutputStream((OutputStream)fos);
        File file1 = TarArchiveOutputStreamTest.getFile("test1.xml");
        TarArchiveEntry sEntry = new TarArchiveEntry(file1, file1.getName());
        tos.putArchiveEntry((ArchiveEntry)sEntry);
        FileInputStream in = new FileInputStream(file1);
        IOUtils.copy((InputStream)in, (OutputStream)tos);
        in.close();
        tos.closeArchiveEntry();
        tos.close();
        TarArchiveOutputStreamTest.assertEquals((long)10240L, (long)f.length());
    }
}

