/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.archivers.tar;

import junit.framework.TestCase;
import org.apache.commons.compress.archivers.tar.TarUtils;
import org.apache.commons.compress.archivers.zip.ZipEncoding;
import org.apache.commons.compress.archivers.zip.ZipEncodingHelper;

public class TarUtilsTest
extends TestCase {
    public void testName() {
        byte[] buff = new byte[20];
        String sb1 = "abcdefghijklmnopqrstuvwxyz";
        int off = TarUtils.formatNameBytes((String)sb1, (byte[])buff, (int)1, (int)(buff.length - 1));
        TarUtilsTest.assertEquals((int)off, (int)20);
        String sb2 = TarUtils.parseName((byte[])buff, (int)1, (int)10);
        TarUtilsTest.assertEquals((String)sb2, (String)sb1.substring(0, 10));
        sb2 = TarUtils.parseName((byte[])buff, (int)1, (int)19);
        TarUtilsTest.assertEquals((String)sb2, (String)sb1.substring(0, 19));
        buff = new byte[30];
        off = TarUtils.formatNameBytes((String)sb1, (byte[])buff, (int)1, (int)(buff.length - 1));
        TarUtilsTest.assertEquals((int)off, (int)30);
        sb2 = TarUtils.parseName((byte[])buff, (int)1, (int)(buff.length - 1));
        TarUtilsTest.assertEquals((String)sb1, (String)sb2);
    }

    public void testParseOctal() throws Exception {
        long MAX_OCTAL = 0x1FFFFFFFFL;
        long MAX_OCTAL_OVERFLOW = 0xFFFFFFFFFL;
        String maxOctal = "777777777777";
        byte[] buffer = "777777777777".getBytes("UTF-8");
        long value = TarUtils.parseOctal((byte[])buffer, (int)0, (int)buffer.length);
        TarUtilsTest.assertEquals((long)0xFFFFFFFFFL, (long)value);
        buffer[buffer.length - 1] = 32;
        value = TarUtils.parseOctal((byte[])buffer, (int)0, (int)buffer.length);
        TarUtilsTest.assertEquals((long)0x1FFFFFFFFL, (long)value);
        buffer[buffer.length - 1] = 0;
        value = TarUtils.parseOctal((byte[])buffer, (int)0, (int)buffer.length);
        TarUtilsTest.assertEquals((long)0x1FFFFFFFFL, (long)value);
        buffer = new byte[]{0, 0};
        value = TarUtils.parseOctal((byte[])buffer, (int)0, (int)buffer.length);
        TarUtilsTest.assertEquals((long)0L, (long)value);
        buffer = new byte[]{0, 32};
        value = TarUtils.parseOctal((byte[])buffer, (int)0, (int)buffer.length);
        TarUtilsTest.assertEquals((long)0L, (long)value);
        buffer = new byte[]{32, 0};
        value = TarUtils.parseOctal((byte[])buffer, (int)0, (int)buffer.length);
        TarUtilsTest.assertEquals((long)0L, (long)value);
    }

    public void testParseOctalInvalid() throws Exception {
        byte[] buffer = new byte[]{};
        try {
            TarUtils.parseOctal((byte[])buffer, (int)0, (int)buffer.length);
            TarUtilsTest.fail((String)"Expected IllegalArgumentException - should be at least 2 bytes long");
        }
        catch (IllegalArgumentException expected) {
            // empty catch block
        }
        buffer = new byte[]{0};
        try {
            TarUtils.parseOctal((byte[])buffer, (int)0, (int)buffer.length);
            TarUtilsTest.fail((String)"Expected IllegalArgumentException - should be at least 2 bytes long");
        }
        catch (IllegalArgumentException expected) {
            // empty catch block
        }
        buffer = "abcdef ".getBytes("UTF-8");
        try {
            TarUtils.parseOctal((byte[])buffer, (int)0, (int)buffer.length);
            TarUtilsTest.fail((String)"Expected IllegalArgumentException");
        }
        catch (IllegalArgumentException expected) {
            // empty catch block
        }
        buffer = " 0 07 ".getBytes("UTF-8");
        try {
            TarUtils.parseOctal((byte[])buffer, (int)0, (int)buffer.length);
            TarUtilsTest.fail((String)"Expected IllegalArgumentException - embedded space");
        }
        catch (IllegalArgumentException expected) {
            // empty catch block
        }
        buffer = " 0\u000007 ".getBytes("UTF-8");
        try {
            TarUtils.parseOctal((byte[])buffer, (int)0, (int)buffer.length);
            TarUtilsTest.fail((String)"Expected IllegalArgumentException - embedded NUL");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    private void checkRoundTripOctal(long value, int bufsize) {
        byte[] buffer = new byte[bufsize];
        TarUtils.formatLongOctalBytes((long)value, (byte[])buffer, (int)0, (int)buffer.length);
        long parseValue = TarUtils.parseOctal((byte[])buffer, (int)0, (int)buffer.length);
        TarUtilsTest.assertEquals((long)value, (long)parseValue);
    }

    private void checkRoundTripOctal(long value) {
        this.checkRoundTripOctal(value, 12);
    }

    public void testRoundTripOctal() {
        this.checkRoundTripOctal(0L);
        this.checkRoundTripOctal(1L);
        this.checkRoundTripOctal(0x1FFFFFFFFL);
        this.checkRoundTripOctal(0L, 8);
        this.checkRoundTripOctal(1L, 8);
        this.checkRoundTripOctal(0x1FFFFFL, 8);
    }

    private void checkRoundTripOctalOrBinary(long value, int bufsize) {
        byte[] buffer = new byte[bufsize];
        TarUtils.formatLongOctalOrBinaryBytes((long)value, (byte[])buffer, (int)0, (int)buffer.length);
        long parseValue = TarUtils.parseOctalOrBinary((byte[])buffer, (int)0, (int)buffer.length);
        TarUtilsTest.assertEquals((long)value, (long)parseValue);
    }

    public void testRoundTripOctalOrBinary8() {
        this.testRoundTripOctalOrBinary(8);
    }

    public void testRoundTripOctalOrBinary12() {
        this.testRoundTripOctalOrBinary(12);
        this.checkRoundTripOctalOrBinary(Long.MAX_VALUE, 12);
        this.checkRoundTripOctalOrBinary(-9223372036854775807L, 12);
    }

    private void testRoundTripOctalOrBinary(int length) {
        this.checkRoundTripOctalOrBinary(0L, length);
        this.checkRoundTripOctalOrBinary(1L, length);
        this.checkRoundTripOctalOrBinary(0x1FFFFFFFFL, length);
        this.checkRoundTripOctalOrBinary(-1L, length);
        this.checkRoundTripOctalOrBinary(-72057594037927935L, length);
    }

    public void testTrailers() {
        byte[] buffer = new byte[12];
        TarUtils.formatLongOctalBytes((long)123L, (byte[])buffer, (int)0, (int)buffer.length);
        TarUtilsTest.assertEquals((int)32, (int)buffer[buffer.length - 1]);
        TarUtilsTest.assertEquals((int)51, (int)buffer[buffer.length - 2]);
        TarUtils.formatOctalBytes((long)123L, (byte[])buffer, (int)0, (int)buffer.length);
        TarUtilsTest.assertEquals((int)0, (int)buffer[buffer.length - 1]);
        TarUtilsTest.assertEquals((int)32, (int)buffer[buffer.length - 2]);
        TarUtilsTest.assertEquals((int)51, (int)buffer[buffer.length - 3]);
        TarUtils.formatCheckSumOctalBytes((long)123L, (byte[])buffer, (int)0, (int)buffer.length);
        TarUtilsTest.assertEquals((int)32, (int)buffer[buffer.length - 1]);
        TarUtilsTest.assertEquals((int)0, (int)buffer[buffer.length - 2]);
        TarUtilsTest.assertEquals((int)51, (int)buffer[buffer.length - 3]);
    }

    public void testNegative() throws Exception {
        byte[] buffer = new byte[22];
        TarUtils.formatUnsignedOctalString((long)-1L, (byte[])buffer, (int)0, (int)buffer.length);
        TarUtilsTest.assertEquals((String)"1777777777777777777777", (String)new String(buffer, "UTF-8"));
    }

    public void testOverflow() throws Exception {
        byte[] buffer = new byte[7];
        TarUtils.formatUnsignedOctalString((long)0x1FFFFFL, (byte[])buffer, (int)0, (int)buffer.length);
        TarUtilsTest.assertEquals((String)"7777777", (String)new String(buffer, "UTF-8"));
        try {
            TarUtils.formatUnsignedOctalString((long)0x3FFFFFL, (byte[])buffer, (int)0, (int)buffer.length);
            TarUtilsTest.fail((String)"Should have cause IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testRoundTripNames() {
        this.checkName("");
        this.checkName("The quick brown fox\n");
        this.checkName("\u007f");
    }

    public void testRoundEncoding() throws Exception {
        ZipEncoding enc = ZipEncodingHelper.getZipEncoding((String)"ISO-8859-1");
        String s = "0302-0601-3\u00b1\u00b1\u00b1F06\u00b1W220\u00b1ZB\u00b1LALALA\u00b1\u00b1\u00b1\u00b1\u00b1\u00b1\u00b1\u00b1\u00b1\u00b1CAN\u00b1\u00b1DC\u00b1\u00b1\u00b104\u00b1060302\u00b1MOE.model";
        byte[] buff = new byte[100];
        int len = TarUtils.formatNameBytes((String)s, (byte[])buff, (int)0, (int)buff.length, (ZipEncoding)enc);
        TarUtilsTest.assertEquals((String)s, (String)TarUtils.parseName((byte[])buff, (int)0, (int)len, (ZipEncoding)enc));
    }

    private void checkName(String string) {
        byte[] buff = new byte[100];
        int len = TarUtils.formatNameBytes((String)string, (byte[])buff, (int)0, (int)buff.length);
        TarUtilsTest.assertEquals((String)string, (String)TarUtils.parseName((byte[])buff, (int)0, (int)len));
    }

    public void testReadNegativeBinary8Byte() {
        byte[] b = new byte[]{-1, -1, -1, -1, -1, -1, -15, -17};
        TarUtilsTest.assertEquals((long)-3601L, (long)TarUtils.parseOctalOrBinary((byte[])b, (int)0, (int)8));
    }

    public void testReadNegativeBinary12Byte() {
        byte[] b = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -15, -17};
        TarUtilsTest.assertEquals((long)-3601L, (long)TarUtils.parseOctalOrBinary((byte[])b, (int)0, (int)12));
    }

    public void testWriteNegativeBinary8Byte() {
        byte[] b = new byte[]{-1, -1, -1, -1, -1, -1, -15, -17};
        TarUtilsTest.assertEquals((long)-3601L, (long)TarUtils.parseOctalOrBinary((byte[])b, (int)0, (int)8));
    }

    public void testVerifyHeaderCheckSum() {
        byte[] valid = new byte[]{116, 101, 115, 116, 49, 46, 120, 109, 108, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 48, 48, 48, 48, 54, 52, 52, 0, 48, 48, 48, 48, 55, 54, 53, 0, 48, 48, 48, 48, 55, 54, 53, 0, 48, 48, 48, 48, 48, 48, 48, 49, 49, 52, 50, 0, 49, 48, 55, 49, 54, 53, 52, 53, 54, 50, 54, 0, 48, 49, 50, 50, 54, 48, 0, 32, 48, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 117, 115, 116, 97, 114, 32, 32, 0, 116, 99, 117, 114, 100, 116, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 116, 99, 117, 114, 100, 116, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
        TarUtilsTest.assertTrue((boolean)TarUtils.verifyCheckSum((byte[])valid));
        byte[] compress117 = new byte[]{116, 101, 115, 116, 49, 46, 120, 109, 108, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 48, 48, 48, 48, 54, 52, 52, 0, 48, 48, 48, 48, 55, 54, 53, 0, 48, 48, 48, 48, 55, 54, 53, 0, 48, 48, 48, 48, 48, 48, 48, 49, 49, 52, 50, 0, 49, 48, 55, 49, 54, 53, 52, 53, 54, 50, 54, 0, 48, 49, 50, 50, 54, 48, 0, 32, 48, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
        TarUtilsTest.assertTrue((boolean)TarUtils.verifyCheckSum((byte[])compress117));
        byte[] invalid = new byte[]{70, 79, 82, 77, 0, 0, 15, 46, 65, 73, 70, 70, 67, 79, 77, 77, 0, 0, 0, 18, 0, 2, 0, 0, 3, -64, 0, 16, 64, 14, -84, 68, 0, 0, 0, 0, 0, 0, 83, 83, 78, 68, 0, 0, 15, 8, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, -1, -1, 0, 1, -1, -1, 0, 0, 0, 0, 0, 0, 0, 1, -1, -1, 0, 0, 0, 0, 0, 0, -1, -1, 0, 2, -1, -2, 0, 2, -1, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, -1, -1, 0, 0, -1, -1, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, -1, -1, 0, 1, -1, -2, 0, 1, -1, -1, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -1, -1, 0, 2, -1, -2, 0, 2, -1, -1, 0, 0, 0, 1, -1, -1, 0, 1, -1, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, -1, -2, 0, 2, -1, -2, 0, 1, 0, 0, 0, 1, -1, -1, 0, 0, 0, 1, -1, -1, 0, 0, 0, 1, -1, -2, 0, 2, -1, -1, 0, 0, 0, 0, 0, 0, -1, -1, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -1, -1, 0, 1, -1, -1, 0, 2, -1, -2, 0, 2, -1, -2, 0, 2, -1, -2, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, -1, -2, 0, 2, -1, -2, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -1, -1, 0, 1, 0, 0, -1, -1, 0, 2, -1, -2, 0, 2, -1, -1, 0, 0, 0, 0, 0, 0, -1, -1, 0, 1, -1, -1, 0, 1, -1, -1, 0, 2, -1, -2, 0, 1, 0, 0, -1, -1, 0, 2, -1, -2, 0, 2, -1, -2, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, -1, -1, 0, 0, 0, 0, -1, -1, 0, 1, 0, 0, 0, 0, 0, 1, -1, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, -1, -2, 0, 2, -1, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, -1, -2, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, -1, -1, 0, 0, 0, 0, -1, -1, 0, 2, -1, -2, 0, 2, -1, -2, 0, 2, -1, -1, 0, 0, 0, 0, -1, -1, 0, 1, -1, -1, 0, 1, -1, -1, 0, 1, -1, -1, 0, 1, -1, -1, 0, 1, 0, 0, 0, 0, -1, -1, 0, 2, -1, -2, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, -1, -1, 0, 0, 0, 0, -1, -1, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1};
        TarUtilsTest.assertFalse((boolean)TarUtils.verifyCheckSum((byte[])invalid));
    }
}

