/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.archivers.zip;

import junit.framework.TestCase;
import org.apache.commons.compress.archivers.zip.AsiExtraField;
import org.apache.commons.compress.archivers.zip.UnixStat;

public class AsiExtraFieldTest
extends TestCase
implements UnixStat {
    public AsiExtraFieldTest(String name) {
        super(name);
    }

    public void testModes() {
        AsiExtraField a = new AsiExtraField();
        a.setMode(83);
        AsiExtraFieldTest.assertEquals((String)"plain file", (int)32851, (int)a.getMode());
        a.setDirectory(true);
        AsiExtraFieldTest.assertEquals((String)"directory", (int)16467, (int)a.getMode());
        a.setLinkedFile("test");
        AsiExtraFieldTest.assertEquals((String)"symbolic link", (int)41043, (int)a.getMode());
    }

    public void testContent() {
        int i;
        AsiExtraField a = new AsiExtraField();
        a.setMode(83);
        a.setUserId(5);
        a.setGroupId(6);
        byte[] b = a.getLocalFileDataData();
        byte[] expect = new byte[]{-58, 2, 120, -74, 83, -128, 0, 0, 0, 0, 5, 0, 6, 0};
        AsiExtraFieldTest.assertEquals((String)"no link", (int)expect.length, (int)b.length);
        for (i = 0; i < expect.length; ++i) {
            AsiExtraFieldTest.assertEquals((String)("no link, byte " + i), (byte)expect[i], (byte)b[i]);
        }
        a.setLinkedFile("test");
        expect = new byte[]{117, -114, 65, -3, 83, -96, 4, 0, 0, 0, 5, 0, 6, 0, 116, 101, 115, 116};
        b = a.getLocalFileDataData();
        AsiExtraFieldTest.assertEquals((String)"no link", (int)expect.length, (int)b.length);
        for (i = 0; i < expect.length; ++i) {
            AsiExtraFieldTest.assertEquals((String)("no link, byte " + i), (byte)expect[i], (byte)b[i]);
        }
    }

    public void testReparse() throws Exception {
        byte[] data = new byte[]{-58, 2, 120, -74, 83, -128, 0, 0, 0, 0, 5, 0, 6, 0};
        AsiExtraField a = new AsiExtraField();
        a.parseFromLocalFileData(data, 0, data.length);
        AsiExtraFieldTest.assertEquals((String)"length plain file", (int)data.length, (int)a.getLocalFileDataLength().getValue());
        AsiExtraFieldTest.assertTrue((String)"plain file, no link", (!a.isLink() ? 1 : 0) != 0);
        AsiExtraFieldTest.assertTrue((String)"plain file, no dir", (!a.isDirectory() ? 1 : 0) != 0);
        AsiExtraFieldTest.assertEquals((String)"mode plain file", (int)32851, (int)a.getMode());
        AsiExtraFieldTest.assertEquals((String)"uid plain file", (int)5, (int)a.getUserId());
        AsiExtraFieldTest.assertEquals((String)"gid plain file", (int)6, (int)a.getGroupId());
        data = new byte[]{117, -114, 65, -3, 83, -96, 4, 0, 0, 0, 5, 0, 6, 0, 116, 101, 115, 116};
        a = new AsiExtraField();
        a.parseFromLocalFileData(data, 0, data.length);
        AsiExtraFieldTest.assertEquals((String)"length link", (int)data.length, (int)a.getLocalFileDataLength().getValue());
        AsiExtraFieldTest.assertTrue((String)"link, is link", (boolean)a.isLink());
        AsiExtraFieldTest.assertTrue((String)"link, no dir", (!a.isDirectory() ? 1 : 0) != 0);
        AsiExtraFieldTest.assertEquals((String)"mode link", (int)41043, (int)a.getMode());
        AsiExtraFieldTest.assertEquals((String)"uid link", (int)5, (int)a.getUserId());
        AsiExtraFieldTest.assertEquals((String)"gid link", (int)6, (int)a.getGroupId());
        AsiExtraFieldTest.assertEquals((String)"test", (String)a.getLinkedFile());
        data = new byte[]{-114, 1, -65, 14, 83, 64, 0, 0, 0, 0, 5, 0, 6, 0};
        a = new AsiExtraField();
        a.parseFromLocalFileData(data, 0, data.length);
        AsiExtraFieldTest.assertEquals((String)"length dir", (int)data.length, (int)a.getLocalFileDataLength().getValue());
        AsiExtraFieldTest.assertTrue((String)"dir, no link", (!a.isLink() ? 1 : 0) != 0);
        AsiExtraFieldTest.assertTrue((String)"dir, is dir", (boolean)a.isDirectory());
        AsiExtraFieldTest.assertEquals((String)"mode dir", (int)16467, (int)a.getMode());
        AsiExtraFieldTest.assertEquals((String)"uid dir", (int)5, (int)a.getUserId());
        AsiExtraFieldTest.assertEquals((String)"gid dir", (int)6, (int)a.getGroupId());
        data = new byte[]{0, 0, 0, 0, 83, 64, 0, 0, 0, 0, 5, 0, 6, 0};
        a = new AsiExtraField();
        try {
            a.parseFromLocalFileData(data, 0, data.length);
            AsiExtraFieldTest.fail((String)"should raise bad CRC exception");
        }
        catch (Exception e) {
            AsiExtraFieldTest.assertEquals((String)"bad CRC checksum 0 instead of ebf018e", (String)e.getMessage());
        }
    }

    public void testClone() {
        AsiExtraField s1 = new AsiExtraField();
        s1.setUserId(42);
        s1.setGroupId(12);
        s1.setLinkedFile("foo");
        s1.setMode(420);
        s1.setDirectory(true);
        AsiExtraField s2 = (AsiExtraField)s1.clone();
        AsiExtraFieldTest.assertNotSame((Object)s1, (Object)s2);
        AsiExtraFieldTest.assertEquals((int)s1.getUserId(), (int)s2.getUserId());
        AsiExtraFieldTest.assertEquals((int)s1.getGroupId(), (int)s2.getGroupId());
        AsiExtraFieldTest.assertEquals((String)s1.getLinkedFile(), (String)s2.getLinkedFile());
        AsiExtraFieldTest.assertEquals((int)s1.getMode(), (int)s2.getMode());
        AsiExtraFieldTest.assertEquals((boolean)s1.isDirectory(), (boolean)s2.isDirectory());
    }
}

