/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.archivers.zip;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import junit.framework.TestCase;
import org.apache.commons.compress.archivers.zip.BitStream;

public class BitStreamTest
extends TestCase {
    public void testEmptyStream() throws Exception {
        BitStream stream = new BitStream((InputStream)new ByteArrayInputStream(new byte[0]));
        BitStreamTest.assertEquals((String)"next bit", (int)-1, (int)stream.nextBit());
        BitStreamTest.assertEquals((String)"next bit", (int)-1, (int)stream.nextBit());
        BitStreamTest.assertEquals((String)"next bit", (int)-1, (int)stream.nextBit());
    }

    public void testStream() throws Exception {
        BitStream stream = new BitStream((InputStream)new ByteArrayInputStream(new byte[]{-22, 3}));
        BitStreamTest.assertEquals((String)"bit 0", (int)0, (int)stream.nextBit());
        BitStreamTest.assertEquals((String)"bit 1", (int)1, (int)stream.nextBit());
        BitStreamTest.assertEquals((String)"bit 2", (int)0, (int)stream.nextBit());
        BitStreamTest.assertEquals((String)"bit 3", (int)1, (int)stream.nextBit());
        BitStreamTest.assertEquals((String)"bit 4", (int)0, (int)stream.nextBit());
        BitStreamTest.assertEquals((String)"bit 5", (int)1, (int)stream.nextBit());
        BitStreamTest.assertEquals((String)"bit 6", (int)1, (int)stream.nextBit());
        BitStreamTest.assertEquals((String)"bit 7", (int)1, (int)stream.nextBit());
        BitStreamTest.assertEquals((String)"bit 8", (int)1, (int)stream.nextBit());
        BitStreamTest.assertEquals((String)"bit 9", (int)1, (int)stream.nextBit());
        BitStreamTest.assertEquals((String)"bit 10", (int)0, (int)stream.nextBit());
        BitStreamTest.assertEquals((String)"bit 11", (int)0, (int)stream.nextBit());
        BitStreamTest.assertEquals((String)"bit 12", (int)0, (int)stream.nextBit());
        BitStreamTest.assertEquals((String)"bit 13", (int)0, (int)stream.nextBit());
        BitStreamTest.assertEquals((String)"bit 14", (int)0, (int)stream.nextBit());
        BitStreamTest.assertEquals((String)"bit 15", (int)0, (int)stream.nextBit());
        BitStreamTest.assertEquals((String)"next bit", (int)-1, (int)stream.nextBit());
    }

    public void testNextByteFromEmptyStream() throws Exception {
        BitStream stream = new BitStream((InputStream)new ByteArrayInputStream(new byte[0]));
        BitStreamTest.assertEquals((String)"next byte", (int)-1, (int)stream.nextByte());
        BitStreamTest.assertEquals((String)"next byte", (int)-1, (int)stream.nextByte());
    }

    public void testReadAlignedBytes() throws Exception {
        BitStream stream = new BitStream((InputStream)new ByteArrayInputStream(new byte[]{-22, 53}));
        BitStreamTest.assertEquals((String)"next byte", (int)234, (int)stream.nextByte());
        BitStreamTest.assertEquals((String)"next byte", (int)53, (int)stream.nextByte());
        BitStreamTest.assertEquals((String)"next byte", (int)-1, (int)stream.nextByte());
    }

    public void testNextByte() throws Exception {
        BitStream stream = new BitStream((InputStream)new ByteArrayInputStream(new byte[]{-22, 53}));
        BitStreamTest.assertEquals((String)"bit 0", (int)0, (int)stream.nextBit());
        BitStreamTest.assertEquals((String)"bit 1", (int)1, (int)stream.nextBit());
        BitStreamTest.assertEquals((String)"bit 2", (int)0, (int)stream.nextBit());
        BitStreamTest.assertEquals((String)"bit 3", (int)1, (int)stream.nextBit());
        BitStreamTest.assertEquals((String)"next byte", (int)94, (int)stream.nextByte());
        BitStreamTest.assertEquals((String)"next byte", (int)-1, (int)stream.nextByte());
    }
}

