/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.archivers.zip;

import junit.framework.TestCase;
import org.apache.commons.compress.archivers.zip.CircularBuffer;

public class CircularBufferTest
extends TestCase {
    public void testPutAndGet() throws Exception {
        int i;
        int size = 16;
        CircularBuffer buffer = new CircularBuffer(size);
        for (i = 0; i < size / 2; ++i) {
            buffer.put(i);
        }
        CircularBufferTest.assertTrue((String)"available", (boolean)buffer.available());
        for (i = 0; i < size / 2; ++i) {
            CircularBufferTest.assertEquals((String)("buffer[" + i + "]"), (int)i, (int)buffer.get());
        }
        CircularBufferTest.assertEquals((int)-1, (int)buffer.get());
        CircularBufferTest.assertFalse((String)"available", (boolean)buffer.available());
    }

    public void testCopy() throws Exception {
        int i;
        CircularBuffer buffer = new CircularBuffer(16);
        buffer.put(1);
        buffer.put(2);
        buffer.get();
        buffer.get();
        buffer.copy(6, 8);
        for (i = 2; i < 6; ++i) {
            CircularBufferTest.assertEquals((String)("buffer[" + i + "]"), (int)0, (int)buffer.get());
        }
        CircularBufferTest.assertEquals((String)"buffer[6]", (int)1, (int)buffer.get());
        CircularBufferTest.assertEquals((String)"buffer[7]", (int)2, (int)buffer.get());
        CircularBufferTest.assertEquals((String)"buffer[8]", (int)0, (int)buffer.get());
        CircularBufferTest.assertEquals((String)"buffer[9]", (int)0, (int)buffer.get());
        for (i = 10; i < 14; ++i) {
            buffer.put(i);
            buffer.get();
        }
        CircularBufferTest.assertFalse((String)"available", (boolean)buffer.available());
        buffer.copy(2, 8);
        for (i = 14; i < 18; ++i) {
            CircularBufferTest.assertEquals((String)("buffer[" + i + "]"), (int)(i % 2 == 0 ? 12 : 13), (int)buffer.get());
        }
    }
}

