/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.archivers.zip;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import junit.framework.TestCase;
import org.apache.commons.compress.AbstractTestCase;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.zip.UnsupportedZipFeatureException;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveInputStream;
import org.apache.commons.compress.archivers.zip.ZipFile;

public class EncryptedArchiveTest
extends TestCase {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testReadPasswordEncryptedEntryViaZipFile() throws IOException {
        File file = AbstractTestCase.getFile("password-encrypted.zip");
        ZipFile zf = null;
        try {
            zf = new ZipFile(file);
            ZipArchiveEntry zae = zf.getEntry("LICENSE.txt");
            EncryptedArchiveTest.assertTrue((boolean)zae.getGeneralPurposeBit().usesEncryption());
            EncryptedArchiveTest.assertFalse((boolean)zae.getGeneralPurposeBit().usesStrongEncryption());
            EncryptedArchiveTest.assertFalse((boolean)zf.canReadEntryData(zae));
            try {
                zf.getInputStream(zae);
                EncryptedArchiveTest.fail((String)"expected an exception");
            }
            catch (UnsupportedZipFeatureException ex) {
                EncryptedArchiveTest.assertSame((Object)UnsupportedZipFeatureException.Feature.ENCRYPTION, (Object)ex.getFeature());
            }
        }
        catch (Throwable throwable) {
            ZipFile.closeQuietly(zf);
            throw throwable;
        }
        ZipFile.closeQuietly((ZipFile)zf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testReadPasswordEncryptedEntryViaStream() throws IOException {
        File file = AbstractTestCase.getFile("password-encrypted.zip");
        ZipArchiveInputStream zin = null;
        try {
            zin = new ZipArchiveInputStream((InputStream)new FileInputStream(file));
            ZipArchiveEntry zae = zin.getNextZipEntry();
            EncryptedArchiveTest.assertEquals((String)"LICENSE.txt", (String)zae.getName());
            EncryptedArchiveTest.assertTrue((boolean)zae.getGeneralPurposeBit().usesEncryption());
            EncryptedArchiveTest.assertFalse((boolean)zae.getGeneralPurposeBit().usesStrongEncryption());
            EncryptedArchiveTest.assertFalse((boolean)zin.canReadEntryData((ArchiveEntry)zae));
            try {
                byte[] buf = new byte[1024];
                zin.read(buf, 0, buf.length);
                EncryptedArchiveTest.fail((String)"expected an exception");
            }
            catch (UnsupportedZipFeatureException ex) {
                EncryptedArchiveTest.assertSame((Object)UnsupportedZipFeatureException.Feature.ENCRYPTION, (Object)ex.getFeature());
            }
        }
        finally {
            if (zin != null) {
                zin.close();
            }
        }
    }
}

