/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.archivers.zip;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.CRC32;
import java.util.zip.CheckedOutputStream;
import junit.framework.TestCase;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveInputStream;
import org.apache.commons.compress.archivers.zip.ZipFile;
import org.apache.commons.compress.archivers.zip.ZipMethod;
import org.apache.commons.compress.utils.BoundedInputStream;
import org.apache.commons.compress.utils.IOUtils;

public class ExplodeSupportTest
extends TestCase {
    private void testArchiveWithImplodeCompression(String filename, String entryName) throws IOException {
        ZipFile zip = new ZipFile(new File(filename));
        ZipArchiveEntry entry = (ZipArchiveEntry)zip.getEntries().nextElement();
        ExplodeSupportTest.assertEquals((String)"entry name", (String)entryName, (String)entry.getName());
        ExplodeSupportTest.assertTrue((String)"entry can't be read", (boolean)zip.canReadEntryData(entry));
        ExplodeSupportTest.assertEquals((String)"method", (int)ZipMethod.IMPLODING.getCode(), (int)entry.getMethod());
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        CheckedOutputStream out = new CheckedOutputStream(bout, new CRC32());
        IOUtils.copy((InputStream)zip.getInputStream(entry), (OutputStream)out);
        out.flush();
        ExplodeSupportTest.assertEquals((String)"CRC32", (long)entry.getCrc(), (long)out.getChecksum().getValue());
    }

    public void testArchiveWithImplodeCompression4K2Trees() throws IOException {
        this.testArchiveWithImplodeCompression("target/test-classes/archives/imploding-4Kdict-2trees.zip", "HEADER.TXT");
    }

    public void testArchiveWithImplodeCompression8K3Trees() throws IOException {
        this.testArchiveWithImplodeCompression("target/test-classes/archives/imploding-8Kdict-3trees.zip", "LICENSE.TXT");
    }

    public void testTikaTestArchive() throws IOException {
        this.testArchiveWithImplodeCompression("target/test-classes/moby-imploded.zip", "README");
    }

    private void testZipStreamWithImplodeCompression(String filename, String entryName) throws IOException {
        ZipArchiveInputStream zin = new ZipArchiveInputStream((InputStream)new FileInputStream(new File(filename)));
        ZipArchiveEntry entry = zin.getNextZipEntry();
        ExplodeSupportTest.assertEquals((String)"entry name", (String)entryName, (String)entry.getName());
        ExplodeSupportTest.assertTrue((String)"entry can't be read", (boolean)zin.canReadEntryData((ArchiveEntry)entry));
        ExplodeSupportTest.assertEquals((String)"method", (int)ZipMethod.IMPLODING.getCode(), (int)entry.getMethod());
        BoundedInputStream bio = new BoundedInputStream((InputStream)zin, entry.getSize());
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        CheckedOutputStream out = new CheckedOutputStream(bout, new CRC32());
        IOUtils.copy((InputStream)bio, (OutputStream)out);
        out.flush();
        ExplodeSupportTest.assertEquals((String)"CRC32", (long)entry.getCrc(), (long)out.getChecksum().getValue());
    }

    public void testZipStreamWithImplodeCompression4K2Trees() throws IOException {
        this.testZipStreamWithImplodeCompression("target/test-classes/archives/imploding-4Kdict-2trees.zip", "HEADER.TXT");
    }

    public void testZipStreamWithImplodeCompression8K3Trees() throws IOException {
        this.testZipStreamWithImplodeCompression("target/test-classes/archives/imploding-8Kdict-3trees.zip", "LICENSE.TXT");
    }

    public void testTikaTestStream() throws IOException {
        this.testZipStreamWithImplodeCompression("target/test-classes/moby-imploded.zip", "README");
    }
}

