/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.archivers.zip;

import junit.framework.TestCase;
import org.apache.commons.compress.archivers.zip.AsiExtraField;
import org.apache.commons.compress.archivers.zip.ExtraFieldUtils;
import org.apache.commons.compress.archivers.zip.UnixStat;
import org.apache.commons.compress.archivers.zip.UnparseableExtraFieldData;
import org.apache.commons.compress.archivers.zip.UnrecognizedExtraField;
import org.apache.commons.compress.archivers.zip.ZipExtraField;
import org.apache.commons.compress.archivers.zip.ZipShort;

public class ExtraFieldUtilsTest
extends TestCase
implements UnixStat {
    static final ZipShort UNRECOGNIZED_HEADER = new ZipShort(21845);
    private AsiExtraField a;
    private UnrecognizedExtraField dummy;
    private byte[] data;
    private byte[] aLocal;

    public ExtraFieldUtilsTest(String name) {
        super(name);
    }

    public void setUp() {
        this.a = new AsiExtraField();
        this.a.setMode(493);
        this.a.setDirectory(true);
        this.dummy = new UnrecognizedExtraField();
        this.dummy.setHeaderId(UNRECOGNIZED_HEADER);
        this.dummy.setLocalFileDataData(new byte[]{0});
        this.dummy.setCentralDirectoryData(new byte[]{0});
        this.aLocal = this.a.getLocalFileDataData();
        byte[] dummyLocal = this.dummy.getLocalFileDataData();
        this.data = new byte[4 + this.aLocal.length + 4 + dummyLocal.length];
        System.arraycopy(this.a.getHeaderId().getBytes(), 0, this.data, 0, 2);
        System.arraycopy(this.a.getLocalFileDataLength().getBytes(), 0, this.data, 2, 2);
        System.arraycopy(this.aLocal, 0, this.data, 4, this.aLocal.length);
        System.arraycopy(this.dummy.getHeaderId().getBytes(), 0, this.data, 4 + this.aLocal.length, 2);
        System.arraycopy(this.dummy.getLocalFileDataLength().getBytes(), 0, this.data, 4 + this.aLocal.length + 2, 2);
        System.arraycopy(dummyLocal, 0, this.data, 4 + this.aLocal.length + 4, dummyLocal.length);
    }

    public void testParse() throws Exception {
        ZipExtraField[] ze = ExtraFieldUtils.parse((byte[])this.data);
        ExtraFieldUtilsTest.assertEquals((String)"number of fields", (int)2, (int)ze.length);
        ExtraFieldUtilsTest.assertTrue((String)"type field 1", (boolean)(ze[0] instanceof AsiExtraField));
        ExtraFieldUtilsTest.assertEquals((String)"mode field 1", (int)16877, (int)((AsiExtraField)ze[0]).getMode());
        ExtraFieldUtilsTest.assertTrue((String)"type field 2", (boolean)(ze[1] instanceof UnrecognizedExtraField));
        ExtraFieldUtilsTest.assertEquals((String)"data length field 2", (int)1, (int)ze[1].getLocalFileDataLength().getValue());
        byte[] data2 = new byte[this.data.length - 1];
        System.arraycopy(this.data, 0, data2, 0, data2.length);
        try {
            ExtraFieldUtils.parse((byte[])data2);
            ExtraFieldUtilsTest.fail((String)"data should be invalid");
        }
        catch (Exception e) {
            ExtraFieldUtilsTest.assertEquals((String)"message", (String)("bad extra field starting at " + (4 + this.aLocal.length) + ".  Block length of 1 bytes exceeds remaining data of 0 bytes."), (String)e.getMessage());
        }
    }

    public void testParseWithRead() throws Exception {
        ZipExtraField[] ze = ExtraFieldUtils.parse((byte[])this.data, (boolean)true, (ExtraFieldUtils.UnparseableExtraField)ExtraFieldUtils.UnparseableExtraField.READ);
        ExtraFieldUtilsTest.assertEquals((String)"number of fields", (int)2, (int)ze.length);
        ExtraFieldUtilsTest.assertTrue((String)"type field 1", (boolean)(ze[0] instanceof AsiExtraField));
        ExtraFieldUtilsTest.assertEquals((String)"mode field 1", (int)16877, (int)((AsiExtraField)ze[0]).getMode());
        ExtraFieldUtilsTest.assertTrue((String)"type field 2", (boolean)(ze[1] instanceof UnrecognizedExtraField));
        ExtraFieldUtilsTest.assertEquals((String)"data length field 2", (int)1, (int)ze[1].getLocalFileDataLength().getValue());
        byte[] data2 = new byte[this.data.length - 1];
        System.arraycopy(this.data, 0, data2, 0, data2.length);
        ze = ExtraFieldUtils.parse((byte[])data2, (boolean)true, (ExtraFieldUtils.UnparseableExtraField)ExtraFieldUtils.UnparseableExtraField.READ);
        ExtraFieldUtilsTest.assertEquals((String)"number of fields", (int)2, (int)ze.length);
        ExtraFieldUtilsTest.assertTrue((String)"type field 1", (boolean)(ze[0] instanceof AsiExtraField));
        ExtraFieldUtilsTest.assertEquals((String)"mode field 1", (int)16877, (int)((AsiExtraField)ze[0]).getMode());
        ExtraFieldUtilsTest.assertTrue((String)"type field 2", (boolean)(ze[1] instanceof UnparseableExtraFieldData));
        ExtraFieldUtilsTest.assertEquals((String)"data length field 2", (int)4, (int)ze[1].getLocalFileDataLength().getValue());
        for (int i = 0; i < 4; ++i) {
            ExtraFieldUtilsTest.assertEquals((String)("byte number " + i), (byte)data2[this.data.length - 5 + i], (byte)ze[1].getLocalFileDataData()[i]);
        }
    }

    public void testParseWithSkip() throws Exception {
        ZipExtraField[] ze = ExtraFieldUtils.parse((byte[])this.data, (boolean)true, (ExtraFieldUtils.UnparseableExtraField)ExtraFieldUtils.UnparseableExtraField.SKIP);
        ExtraFieldUtilsTest.assertEquals((String)"number of fields", (int)2, (int)ze.length);
        ExtraFieldUtilsTest.assertTrue((String)"type field 1", (boolean)(ze[0] instanceof AsiExtraField));
        ExtraFieldUtilsTest.assertEquals((String)"mode field 1", (int)16877, (int)((AsiExtraField)ze[0]).getMode());
        ExtraFieldUtilsTest.assertTrue((String)"type field 2", (boolean)(ze[1] instanceof UnrecognizedExtraField));
        ExtraFieldUtilsTest.assertEquals((String)"data length field 2", (int)1, (int)ze[1].getLocalFileDataLength().getValue());
        byte[] data2 = new byte[this.data.length - 1];
        System.arraycopy(this.data, 0, data2, 0, data2.length);
        ze = ExtraFieldUtils.parse((byte[])data2, (boolean)true, (ExtraFieldUtils.UnparseableExtraField)ExtraFieldUtils.UnparseableExtraField.SKIP);
        ExtraFieldUtilsTest.assertEquals((String)"number of fields", (int)1, (int)ze.length);
        ExtraFieldUtilsTest.assertTrue((String)"type field 1", (boolean)(ze[0] instanceof AsiExtraField));
        ExtraFieldUtilsTest.assertEquals((String)"mode field 1", (int)16877, (int)((AsiExtraField)ze[0]).getMode());
    }

    public void testMerge() {
        byte[] local = ExtraFieldUtils.mergeLocalFileDataData((ZipExtraField[])new ZipExtraField[]{this.a, this.dummy});
        ExtraFieldUtilsTest.assertEquals((String)"local length", (int)this.data.length, (int)local.length);
        for (int i = 0; i < local.length; ++i) {
            ExtraFieldUtilsTest.assertEquals((String)("local byte " + i), (byte)this.data[i], (byte)local[i]);
        }
        byte[] dummyCentral = this.dummy.getCentralDirectoryData();
        byte[] data2 = new byte[4 + this.aLocal.length + 4 + dummyCentral.length];
        System.arraycopy(this.data, 0, data2, 0, 4 + this.aLocal.length + 2);
        System.arraycopy(this.dummy.getCentralDirectoryLength().getBytes(), 0, data2, 4 + this.aLocal.length + 2, 2);
        System.arraycopy(dummyCentral, 0, data2, 4 + this.aLocal.length + 4, dummyCentral.length);
        byte[] central = ExtraFieldUtils.mergeCentralDirectoryData((ZipExtraField[])new ZipExtraField[]{this.a, this.dummy});
        ExtraFieldUtilsTest.assertEquals((String)"central length", (int)data2.length, (int)central.length);
        for (int i = 0; i < central.length; ++i) {
            ExtraFieldUtilsTest.assertEquals((String)("central byte " + i), (byte)data2[i], (byte)central[i]);
        }
    }

    public void testMergeWithUnparseableData() throws Exception {
        UnparseableExtraFieldData d = new UnparseableExtraFieldData();
        byte[] b = UNRECOGNIZED_HEADER.getBytes();
        d.parseFromLocalFileData(new byte[]{b[0], b[1], 1, 0}, 0, 4);
        byte[] local = ExtraFieldUtils.mergeLocalFileDataData((ZipExtraField[])new ZipExtraField[]{this.a, d});
        ExtraFieldUtilsTest.assertEquals((String)"local length", (int)(this.data.length - 1), (int)local.length);
        for (int i = 0; i < local.length; ++i) {
            ExtraFieldUtilsTest.assertEquals((String)("local byte " + i), (byte)this.data[i], (byte)local[i]);
        }
        byte[] dCentral = d.getCentralDirectoryData();
        byte[] data2 = new byte[4 + this.aLocal.length + dCentral.length];
        System.arraycopy(this.data, 0, data2, 0, 4 + this.aLocal.length + 2);
        System.arraycopy(dCentral, 0, data2, 4 + this.aLocal.length, dCentral.length);
        byte[] central = ExtraFieldUtils.mergeCentralDirectoryData((ZipExtraField[])new ZipExtraField[]{this.a, d});
        ExtraFieldUtilsTest.assertEquals((String)"central length", (int)data2.length, (int)central.length);
        for (int i = 0; i < central.length; ++i) {
            ExtraFieldUtilsTest.assertEquals((String)("central byte " + i), (byte)data2[i], (byte)central[i]);
        }
    }
}

