/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.archivers.zip;

import java.util.Arrays;
import junit.framework.TestCase;
import org.apache.commons.compress.archivers.zip.GeneralPurposeBit;

public class GeneralPurposeBitTest
extends TestCase {
    public void testDefaults() {
        GeneralPurposeBitTest.assertFalse((boolean)new GeneralPurposeBit().usesDataDescriptor());
        GeneralPurposeBitTest.assertFalse((boolean)new GeneralPurposeBit().usesUTF8ForNames());
        GeneralPurposeBitTest.assertFalse((boolean)new GeneralPurposeBit().usesEncryption());
        GeneralPurposeBitTest.assertFalse((boolean)new GeneralPurposeBit().usesStrongEncryption());
        byte[] b = new byte[2];
        GeneralPurposeBitTest.assertTrue((boolean)Arrays.equals(b, new GeneralPurposeBit().encode()));
    }

    public void testParseEdgeCases() {
        GeneralPurposeBitTest.assertFalse((boolean)GeneralPurposeBit.parse((byte[])new byte[2], (int)0).usesDataDescriptor());
        GeneralPurposeBitTest.assertFalse((boolean)GeneralPurposeBit.parse((byte[])new byte[2], (int)0).usesUTF8ForNames());
        GeneralPurposeBitTest.assertFalse((boolean)GeneralPurposeBit.parse((byte[])new byte[2], (int)0).usesEncryption());
        GeneralPurposeBitTest.assertFalse((boolean)GeneralPurposeBit.parse((byte[])new byte[2], (int)0).usesStrongEncryption());
        GeneralPurposeBitTest.assertTrue((boolean)GeneralPurposeBit.parse((byte[])new byte[]{-1, -1}, (int)0).usesDataDescriptor());
        GeneralPurposeBitTest.assertTrue((boolean)GeneralPurposeBit.parse((byte[])new byte[]{-1, -1}, (int)0).usesUTF8ForNames());
        GeneralPurposeBitTest.assertTrue((boolean)GeneralPurposeBit.parse((byte[])new byte[]{-1, -1}, (int)0).usesEncryption());
        GeneralPurposeBitTest.assertTrue((boolean)GeneralPurposeBit.parse((byte[])new byte[]{-1, -1}, (int)0).usesStrongEncryption());
    }

    public void testDataDescriptor() {
        byte[] flags = new byte[]{8, 0};
        GeneralPurposeBitTest.assertTrue((boolean)GeneralPurposeBit.parse((byte[])flags, (int)0).usesDataDescriptor());
        GeneralPurposeBit b = new GeneralPurposeBit();
        b.useDataDescriptor(true);
        GeneralPurposeBitTest.assertTrue((boolean)Arrays.equals(flags, b.encode()));
    }

    public void testLanguageEncodingFlag() {
        byte[] flags = new byte[]{0, 8};
        GeneralPurposeBitTest.assertTrue((boolean)GeneralPurposeBit.parse((byte[])flags, (int)0).usesUTF8ForNames());
        GeneralPurposeBit b = new GeneralPurposeBit();
        b.useUTF8ForNames(true);
        GeneralPurposeBitTest.assertTrue((boolean)Arrays.equals(flags, b.encode()));
    }

    public void testEncryption() {
        byte[] flags = new byte[]{1, 0};
        GeneralPurposeBitTest.assertTrue((boolean)GeneralPurposeBit.parse((byte[])flags, (int)0).usesEncryption());
        GeneralPurposeBit b = new GeneralPurposeBit();
        b.useEncryption(true);
        GeneralPurposeBitTest.assertTrue((boolean)Arrays.equals(flags, b.encode()));
    }

    public void testStringEncryption() {
        byte[] flags = new byte[]{65, 0};
        GeneralPurposeBitTest.assertTrue((boolean)GeneralPurposeBit.parse((byte[])flags, (int)0).usesStrongEncryption());
        GeneralPurposeBit b = new GeneralPurposeBit();
        b.useStrongEncryption(true);
        GeneralPurposeBitTest.assertTrue((boolean)b.usesEncryption());
        GeneralPurposeBitTest.assertTrue((boolean)Arrays.equals(flags, b.encode()));
        flags = new byte[]{64, 0};
        GeneralPurposeBitTest.assertFalse((boolean)GeneralPurposeBit.parse((byte[])flags, (int)0).usesStrongEncryption());
    }
}

