/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.archivers.zip;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveInputStream;
import org.apache.commons.compress.archivers.zip.ZipFile;
import org.apache.commons.compress.utils.IOUtils;

public final class Lister {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws IOException {
        CommandLine cl = Lister.parse(args);
        File f = new File(cl.archive);
        if (!f.isFile()) {
            System.err.println(f + " doesn't exists or is a directory");
            Lister.usage();
        }
        if (cl.useStream) {
            BufferedInputStream fs = new BufferedInputStream(new FileInputStream(f));
            try {
                ZipArchiveInputStream zs = new ZipArchiveInputStream((InputStream)fs, cl.encoding, true, cl.allowStoredEntriesWithDataDescriptor);
                ArchiveEntry entry = zs.getNextEntry();
                while (entry != null) {
                    ZipArchiveEntry ze = (ZipArchiveEntry)entry;
                    Lister.list(ze);
                    if (cl.dir != null) {
                        Lister.extract(cl.dir, ze, (InputStream)zs);
                    }
                    entry = zs.getNextEntry();
                }
            }
            finally {
                fs.close();
            }
        }
        ZipFile zf = new ZipFile(f, cl.encoding);
        try {
            Enumeration entries = zf.getEntries();
            while (entries.hasMoreElements()) {
                ZipArchiveEntry ze = (ZipArchiveEntry)entries.nextElement();
                Lister.list(ze);
                if (cl.dir == null) continue;
                InputStream is = zf.getInputStream(ze);
                try {
                    Lister.extract(cl.dir, ze, is);
                }
                finally {
                    is.close();
                }
            }
        }
        finally {
            zf.close();
        }
    }

    private static void list(ZipArchiveEntry entry) {
        System.out.println(entry.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void extract(String dir, ZipArchiveEntry entry, InputStream is) throws IOException {
        File f = new File(dir, entry.getName());
        if (!f.getParentFile().exists()) {
            f.getParentFile().mkdirs();
        }
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(f);
            IOUtils.copy((InputStream)is, (OutputStream)fos);
        }
        finally {
            if (fos != null) {
                fos.close();
            }
        }
    }

    private static CommandLine parse(String[] args) {
        CommandLine cl = new CommandLine();
        boolean error = false;
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("-enc")) {
                if (args.length > i + 1) {
                    cl.encoding = args[++i];
                    continue;
                }
                System.err.println("missing argument to -enc");
                error = true;
                continue;
            }
            if (args[i].equals("-extract")) {
                if (args.length > i + 1) {
                    cl.dir = args[++i];
                    continue;
                }
                System.err.println("missing argument to -extract");
                error = true;
                continue;
            }
            if (args[i].equals("-stream")) {
                cl.useStream = true;
                continue;
            }
            if (args[i].equals("+storeddd")) {
                cl.allowStoredEntriesWithDataDescriptor = true;
                continue;
            }
            if (args[i].equals("-file")) {
                cl.useStream = false;
                continue;
            }
            if (cl.archive != null) {
                System.err.println("Only one archive");
                error = true;
                continue;
            }
            cl.archive = args[i];
        }
        if (error || cl.archive == null) {
            Lister.usage();
        }
        return cl;
    }

    private static void usage() {
        System.err.println("lister [-enc encoding] [-stream] [-file] [+storeddd] [-extract dir] archive");
        System.exit(1);
    }

    private static class CommandLine {
        String archive;
        boolean useStream = false;
        String encoding;
        boolean allowStoredEntriesWithDataDescriptor = false;
        String dir;

        private CommandLine() {
        }
    }
}

