/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.archivers.zip;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import junit.framework.TestCase;
import org.apache.commons.compress.AbstractTestCase;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveInputStream;
import org.apache.commons.compress.archivers.zip.ZipFile;

public class Maven221MultiVolumeTest
extends TestCase {
    private static final String[] ENTRIES = new String[]{"apache-maven-2.2.1/", "apache-maven-2.2.1/LICENSE.txt", "apache-maven-2.2.1/NOTICE.txt", "apache-maven-2.2.1/README.txt", "apache-maven-2.2.1/bin/", "apache-maven-2.2.1/bin/m2.conf", "apache-maven-2.2.1/bin/mvn", "apache-maven-2.2.1/bin/mvn.bat", "apache-maven-2.2.1/bin/mvnDebug", "apache-maven-2.2.1/bin/mvnDebug.bat", "apache-maven-2.2.1/boot/", "apache-maven-2.2.1/boot/classworlds-1.1.jar", "apache-maven-2.2.1/conf/", "apache-maven-2.2.1/conf/settings.xml", "apache-maven-2.2.1/lib/"};
    private static final String LAST_ENTRY_NAME = "apache-maven-2.2.1/lib/maven-2.2.1-uber.jar";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testRead7ZipMultiVolumeArchiveForStream() throws IOException {
        FileInputStream archive = new FileInputStream(AbstractTestCase.getFile("apache-maven-2.2.1.zip.001"));
        ZipArchiveInputStream zi = null;
        try {
            zi = new ZipArchiveInputStream((InputStream)archive, null, false);
            for (String element : ENTRIES) {
                Maven221MultiVolumeTest.assertEquals((String)element, (String)zi.getNextEntry().getName());
            }
            ArchiveEntry lastEntry = zi.getNextEntry();
            Maven221MultiVolumeTest.assertEquals((String)LAST_ENTRY_NAME, (String)lastEntry.getName());
            byte[] buffer = new byte[4096];
            try {
                while (zi.read(buffer) > 0) {
                }
                Maven221MultiVolumeTest.fail((String)"shouldn't be able to read from truncated entry");
            }
            catch (IOException e) {
                Maven221MultiVolumeTest.assertEquals((String)"Truncated ZIP file", (String)e.getMessage());
            }
            try {
                zi.getNextEntry();
                Maven221MultiVolumeTest.fail((String)"shouldn't be able to read another entry from truncated file");
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        finally {
            if (zi != null) {
                zi.close();
            }
        }
    }

    public void testRead7ZipMultiVolumeArchiveForFile() throws IOException {
        File file = AbstractTestCase.getFile("apache-maven-2.2.1.zip.001");
        try {
            new ZipFile(file);
            Maven221MultiVolumeTest.fail((String)"Expected ZipFile to fail");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

