/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.archivers.zip;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.util.Enumeration;
import java.util.zip.CRC32;
import org.apache.commons.compress.AbstractTestCase;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.zip.UnicodePathExtraField;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveInputStream;
import org.apache.commons.compress.archivers.zip.ZipArchiveOutputStream;
import org.apache.commons.compress.archivers.zip.ZipEncoding;
import org.apache.commons.compress.archivers.zip.ZipEncodingHelper;
import org.apache.commons.compress.archivers.zip.ZipExtraField;
import org.apache.commons.compress.archivers.zip.ZipFile;

public class UTF8ZipFilesTest
extends AbstractTestCase {
    private static final String CP437 = "cp437";
    private static final String ASCII_TXT = "ascii.txt";
    private static final String EURO_FOR_DOLLAR_TXT = "\u20ac_for_Dollar.txt";
    private static final String OIL_BARREL_TXT = "\u00d6lf\u00e4sser.txt";

    public void testUtf8FileRoundtripExplicitUnicodeExtra() throws IOException {
        UTF8ZipFilesTest.testFileRoundtrip("UTF-8", true, true);
    }

    public void testUtf8FileRoundtripNoEFSExplicitUnicodeExtra() throws IOException {
        UTF8ZipFilesTest.testFileRoundtrip("UTF-8", false, true);
    }

    public void testCP437FileRoundtripExplicitUnicodeExtra() throws IOException {
        UTF8ZipFilesTest.testFileRoundtrip(CP437, false, true);
    }

    public void testASCIIFileRoundtripExplicitUnicodeExtra() throws IOException {
        UTF8ZipFilesTest.testFileRoundtrip("US-ASCII", false, true);
    }

    public void testUtf8FileRoundtripImplicitUnicodeExtra() throws IOException {
        UTF8ZipFilesTest.testFileRoundtrip("UTF-8", true, false);
    }

    public void testUtf8FileRoundtripNoEFSImplicitUnicodeExtra() throws IOException {
        UTF8ZipFilesTest.testFileRoundtrip("UTF-8", false, false);
    }

    public void testCP437FileRoundtripImplicitUnicodeExtra() throws IOException {
        UTF8ZipFilesTest.testFileRoundtrip(CP437, false, false);
    }

    public void testASCIIFileRoundtripImplicitUnicodeExtra() throws IOException {
        UTF8ZipFilesTest.testFileRoundtrip("US-ASCII", false, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testRead7ZipArchive() throws IOException {
        File archive = UTF8ZipFilesTest.getFile("utf8-7zip-test.zip");
        ZipFile zf = null;
        try {
            zf = new ZipFile(archive, CP437, false);
            UTF8ZipFilesTest.assertNotNull((Object)zf.getEntry(ASCII_TXT));
            UTF8ZipFilesTest.assertNotNull((Object)zf.getEntry(EURO_FOR_DOLLAR_TXT));
            UTF8ZipFilesTest.assertNotNull((Object)zf.getEntry(OIL_BARREL_TXT));
        }
        catch (Throwable throwable) {
            ZipFile.closeQuietly(zf);
            throw throwable;
        }
        ZipFile.closeQuietly((ZipFile)zf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testRead7ZipArchiveForStream() throws IOException {
        FileInputStream archive = new FileInputStream(UTF8ZipFilesTest.getFile("utf8-7zip-test.zip"));
        ZipArchiveInputStream zi = null;
        try {
            zi = new ZipArchiveInputStream((InputStream)archive, CP437, false);
            UTF8ZipFilesTest.assertEquals((String)ASCII_TXT, (String)zi.getNextEntry().getName());
            UTF8ZipFilesTest.assertEquals((String)OIL_BARREL_TXT, (String)zi.getNextEntry().getName());
            UTF8ZipFilesTest.assertEquals((String)EURO_FOR_DOLLAR_TXT, (String)zi.getNextEntry().getName());
        }
        finally {
            if (zi != null) {
                zi.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testReadWinZipArchive() throws IOException {
        File archive = UTF8ZipFilesTest.getFile("utf8-winzip-test.zip");
        ZipFile zf = null;
        try {
            zf = new ZipFile(archive, null, true);
            this.assertCanRead(zf, ASCII_TXT);
            this.assertCanRead(zf, EURO_FOR_DOLLAR_TXT);
            this.assertCanRead(zf, OIL_BARREL_TXT);
        }
        catch (Throwable throwable) {
            ZipFile.closeQuietly(zf);
            throw throwable;
        }
        ZipFile.closeQuietly((ZipFile)zf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void assertCanRead(ZipFile zf, String fileName) throws IOException {
        ZipArchiveEntry entry = zf.getEntry(fileName);
        UTF8ZipFilesTest.assertNotNull((String)"Entry doesn't exist", (Object)entry);
        InputStream is = zf.getInputStream(entry);
        UTF8ZipFilesTest.assertNotNull((String)"InputStream is null", (Object)is);
        try {
            is.read();
        }
        finally {
            is.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testReadWinZipArchiveForStream() throws IOException {
        FileInputStream archive = new FileInputStream(UTF8ZipFilesTest.getFile("utf8-winzip-test.zip"));
        ZipArchiveInputStream zi = null;
        try {
            zi = new ZipArchiveInputStream((InputStream)archive, null, true);
            UTF8ZipFilesTest.assertEquals((String)EURO_FOR_DOLLAR_TXT, (String)zi.getNextEntry().getName());
            UTF8ZipFilesTest.assertEquals((String)OIL_BARREL_TXT, (String)zi.getNextEntry().getName());
            UTF8ZipFilesTest.assertEquals((String)ASCII_TXT, (String)zi.getNextEntry().getName());
        }
        finally {
            if (zi != null) {
                zi.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testZipFileReadsUnicodeFields() throws IOException {
        File file = File.createTempFile("unicode-test", ".zip");
        file.deleteOnExit();
        ZipArchiveInputStream zi = null;
        try {
            UTF8ZipFilesTest.createTestFile(file, "US-ASCII", false, true);
            FileInputStream archive = new FileInputStream(file);
            zi = new ZipArchiveInputStream((InputStream)archive, "US-ASCII", true);
            UTF8ZipFilesTest.assertEquals((String)OIL_BARREL_TXT, (String)zi.getNextEntry().getName());
            UTF8ZipFilesTest.assertEquals((String)EURO_FOR_DOLLAR_TXT, (String)zi.getNextEntry().getName());
            UTF8ZipFilesTest.assertEquals((String)ASCII_TXT, (String)zi.getNextEntry().getName());
        }
        finally {
            if (zi != null) {
                zi.close();
            }
            UTF8ZipFilesTest.tryHardToDelete(file);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testZipArchiveInputStreamReadsUnicodeFields() throws IOException {
        File file = File.createTempFile("unicode-test", ".zip");
        file.deleteOnExit();
        ZipFile zf = null;
        try {
            UTF8ZipFilesTest.createTestFile(file, "US-ASCII", false, true);
            zf = new ZipFile(file, "US-ASCII", true);
            UTF8ZipFilesTest.assertNotNull((Object)zf.getEntry(ASCII_TXT));
            UTF8ZipFilesTest.assertNotNull((Object)zf.getEntry(EURO_FOR_DOLLAR_TXT));
            UTF8ZipFilesTest.assertNotNull((Object)zf.getEntry(OIL_BARREL_TXT));
        }
        catch (Throwable throwable) {
            ZipFile.closeQuietly(zf);
            UTF8ZipFilesTest.tryHardToDelete(file);
            throw throwable;
        }
        ZipFile.closeQuietly((ZipFile)zf);
        UTF8ZipFilesTest.tryHardToDelete(file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testRawNameReadFromZipFile() throws IOException {
        File archive = UTF8ZipFilesTest.getFile("utf8-7zip-test.zip");
        ZipFile zf = null;
        try {
            zf = new ZipFile(archive, CP437, false);
            UTF8ZipFilesTest.assertRawNameOfAcsiiTxt(zf.getEntry(ASCII_TXT));
        }
        catch (Throwable throwable) {
            ZipFile.closeQuietly(zf);
            throw throwable;
        }
        ZipFile.closeQuietly((ZipFile)zf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testRawNameReadFromStream() throws IOException {
        FileInputStream archive = new FileInputStream(UTF8ZipFilesTest.getFile("utf8-7zip-test.zip"));
        ZipArchiveInputStream zi = null;
        try {
            zi = new ZipArchiveInputStream((InputStream)archive, CP437, false);
            UTF8ZipFilesTest.assertRawNameOfAcsiiTxt((ZipArchiveEntry)zi.getNextEntry());
        }
        finally {
            if (zi != null) {
                zi.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void testFileRoundtrip(String encoding, boolean withEFS, boolean withExplicitUnicodeExtra) throws IOException {
        File file = File.createTempFile(encoding + "-test", ".zip");
        file.deleteOnExit();
        try {
            UTF8ZipFilesTest.createTestFile(file, encoding, withEFS, withExplicitUnicodeExtra);
            UTF8ZipFilesTest.testFile(file, encoding);
        }
        finally {
            UTF8ZipFilesTest.tryHardToDelete(file);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void createTestFile(File file, String encoding, boolean withEFS, boolean withExplicitUnicodeExtra) throws UnsupportedEncodingException, IOException {
        ZipEncoding zipEncoding = ZipEncodingHelper.getZipEncoding((String)encoding);
        ZipArchiveOutputStream zos = null;
        try {
            ByteBuffer en;
            zos = new ZipArchiveOutputStream(file);
            zos.setEncoding(encoding);
            zos.setUseLanguageEncodingFlag(withEFS);
            zos.setCreateUnicodeExtraFields(withExplicitUnicodeExtra ? ZipArchiveOutputStream.UnicodeExtraFieldPolicy.NEVER : ZipArchiveOutputStream.UnicodeExtraFieldPolicy.ALWAYS);
            ZipArchiveEntry ze = new ZipArchiveEntry(OIL_BARREL_TXT);
            if (withExplicitUnicodeExtra && !zipEncoding.canEncode(ze.getName())) {
                en = zipEncoding.encode(ze.getName());
                ze.addExtraField((ZipExtraField)new UnicodePathExtraField(ze.getName(), en.array(), en.arrayOffset(), en.limit() - en.position()));
            }
            zos.putArchiveEntry((ArchiveEntry)ze);
            zos.write("Hello, world!".getBytes("US-ASCII"));
            zos.closeArchiveEntry();
            ze = new ZipArchiveEntry(EURO_FOR_DOLLAR_TXT);
            if (withExplicitUnicodeExtra && !zipEncoding.canEncode(ze.getName())) {
                en = zipEncoding.encode(ze.getName());
                ze.addExtraField((ZipExtraField)new UnicodePathExtraField(ze.getName(), en.array(), en.arrayOffset(), en.limit() - en.position()));
            }
            zos.putArchiveEntry((ArchiveEntry)ze);
            zos.write("Give me your money!".getBytes("US-ASCII"));
            zos.closeArchiveEntry();
            ze = new ZipArchiveEntry(ASCII_TXT);
            if (withExplicitUnicodeExtra && !zipEncoding.canEncode(ze.getName())) {
                en = zipEncoding.encode(ze.getName());
                ze.addExtraField((ZipExtraField)new UnicodePathExtraField(ze.getName(), en.array(), en.arrayOffset(), en.limit() - en.position()));
            }
            zos.putArchiveEntry((ArchiveEntry)ze);
            zos.write("ascii".getBytes("US-ASCII"));
            zos.closeArchiveEntry();
            zos.finish();
        }
        finally {
            if (zos != null) {
                try {
                    zos.close();
                }
                catch (IOException e) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void testFile(File file, String encoding) throws IOException {
        ZipFile zf = null;
        try {
            zf = new ZipFile(file, encoding, false);
            Enumeration e = zf.getEntries();
            while (e.hasMoreElements()) {
                ZipArchiveEntry ze = (ZipArchiveEntry)e.nextElement();
                if (ze.getName().endsWith("sser.txt")) {
                    UTF8ZipFilesTest.assertUnicodeName(ze, OIL_BARREL_TXT, encoding);
                    continue;
                }
                if (ze.getName().endsWith("_for_Dollar.txt")) {
                    UTF8ZipFilesTest.assertUnicodeName(ze, EURO_FOR_DOLLAR_TXT, encoding);
                    continue;
                }
                if (!ze.getName().equals(ASCII_TXT)) {
                    throw new AssertionError((Object)("Urecognized ZIP entry with name [" + ze.getName() + "] found."));
                }
            }
        }
        catch (Throwable throwable) {
            ZipFile.closeQuietly(zf);
            throw throwable;
        }
        ZipFile.closeQuietly((ZipFile)zf);
    }

    private static UnicodePathExtraField findUniCodePath(ZipArchiveEntry ze) {
        return (UnicodePathExtraField)ze.getExtraField(UnicodePathExtraField.UPATH_ID);
    }

    private static void assertUnicodeName(ZipArchiveEntry ze, String expectedName, String encoding) throws IOException {
        if (!expectedName.equals(ze.getName())) {
            UnicodePathExtraField ucpf = UTF8ZipFilesTest.findUniCodePath(ze);
            UTF8ZipFilesTest.assertNotNull((Object)ucpf);
            ZipEncoding enc = ZipEncodingHelper.getZipEncoding((String)encoding);
            ByteBuffer ne = enc.encode(ze.getName());
            CRC32 crc = new CRC32();
            crc.update(ne.array(), ne.arrayOffset(), ne.limit() - ne.position());
            UTF8ZipFilesTest.assertEquals((long)crc.getValue(), (long)ucpf.getNameCRC32());
            UTF8ZipFilesTest.assertEquals((String)expectedName, (String)new String(ucpf.getUnicodeName(), "UTF-8"));
        }
    }

    public void testUtf8Interoperability() throws IOException {
        File file1 = AbstractTestCase.getFile("utf8-7zip-test.zip");
        File file2 = AbstractTestCase.getFile("utf8-winzip-test.zip");
        UTF8ZipFilesTest.testFile(file1, CP437);
        UTF8ZipFilesTest.testFile(file2, CP437);
    }

    private static void assertRawNameOfAcsiiTxt(ZipArchiveEntry ze) {
        byte[] b = ze.getRawName();
        UTF8ZipFilesTest.assertNotNull((Object)b);
        int len = ASCII_TXT.length();
        UTF8ZipFilesTest.assertEquals((int)len, (int)b.length);
        for (int i = 0; i < len; ++i) {
            UTF8ZipFilesTest.assertEquals((String)("Byte " + i), (byte)((byte)ASCII_TXT.charAt(i)), (byte)b[i]);
        }
        UTF8ZipFilesTest.assertNotSame((Object)b, (Object)ze.getRawName());
    }
}

