/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.archivers.zip;

import java.math.BigInteger;
import java.util.zip.ZipException;
import junit.framework.TestCase;
import org.apache.commons.compress.archivers.zip.Zip64ExtendedInformationExtraField;
import org.apache.commons.compress.archivers.zip.ZipEightByteInteger;
import org.apache.commons.compress.archivers.zip.ZipLong;
import org.apache.commons.compress.archivers.zip.ZipShort;

public class Zip64ExtendedInformationExtraFieldTest
extends TestCase {
    private static final ZipEightByteInteger SIZE = new ZipEightByteInteger(305419896L);
    private static final ZipEightByteInteger CSIZE = new ZipEightByteInteger(162254319L);
    private static final ZipEightByteInteger OFF = new ZipEightByteInteger(BigInteger.valueOf(773738360809407847L).shiftLeft(4).setBit(3));
    private static final ZipLong DISK = new ZipLong(18L);

    public Zip64ExtendedInformationExtraFieldTest(String name) {
        super(name);
    }

    public void testWriteCDOnlySizes() {
        Zip64ExtendedInformationExtraField f = new Zip64ExtendedInformationExtraField(SIZE, CSIZE);
        Zip64ExtendedInformationExtraFieldTest.assertEquals((Object)new ZipShort(16), (Object)f.getCentralDirectoryLength());
        byte[] b = f.getCentralDirectoryData();
        Zip64ExtendedInformationExtraFieldTest.assertEquals((int)16, (int)b.length);
        Zip64ExtendedInformationExtraFieldTest.checkSizes(b);
    }

    public void testWriteCDSizeAndOffset() {
        Zip64ExtendedInformationExtraField f = new Zip64ExtendedInformationExtraField(SIZE, CSIZE, OFF, null);
        Zip64ExtendedInformationExtraFieldTest.assertEquals((Object)new ZipShort(24), (Object)f.getCentralDirectoryLength());
        byte[] b = f.getCentralDirectoryData();
        Zip64ExtendedInformationExtraFieldTest.assertEquals((int)24, (int)b.length);
        Zip64ExtendedInformationExtraFieldTest.checkSizes(b);
        Zip64ExtendedInformationExtraFieldTest.checkOffset(b, 16);
    }

    public void testWriteCDSizeOffsetAndDisk() {
        Zip64ExtendedInformationExtraField f = new Zip64ExtendedInformationExtraField(SIZE, CSIZE, OFF, DISK);
        Zip64ExtendedInformationExtraFieldTest.assertEquals((Object)new ZipShort(28), (Object)f.getCentralDirectoryLength());
        byte[] b = f.getCentralDirectoryData();
        Zip64ExtendedInformationExtraFieldTest.assertEquals((int)28, (int)b.length);
        Zip64ExtendedInformationExtraFieldTest.checkSizes(b);
        Zip64ExtendedInformationExtraFieldTest.checkOffset(b, 16);
        Zip64ExtendedInformationExtraFieldTest.checkDisk(b, 24);
    }

    public void testWriteCDSizeAndDisk() {
        Zip64ExtendedInformationExtraField f = new Zip64ExtendedInformationExtraField(SIZE, CSIZE, null, DISK);
        Zip64ExtendedInformationExtraFieldTest.assertEquals((Object)new ZipShort(20), (Object)f.getCentralDirectoryLength());
        byte[] b = f.getCentralDirectoryData();
        Zip64ExtendedInformationExtraFieldTest.assertEquals((int)20, (int)b.length);
        Zip64ExtendedInformationExtraFieldTest.checkSizes(b);
        Zip64ExtendedInformationExtraFieldTest.checkDisk(b, 16);
    }

    public void testReadLFHSizesOnly() throws ZipException {
        Zip64ExtendedInformationExtraField f = new Zip64ExtendedInformationExtraField();
        byte[] b = new byte[16];
        System.arraycopy(SIZE.getBytes(), 0, b, 0, 8);
        System.arraycopy(CSIZE.getBytes(), 0, b, 8, 8);
        f.parseFromLocalFileData(b, 0, b.length);
        Zip64ExtendedInformationExtraFieldTest.assertEquals((Object)SIZE, (Object)f.getSize());
        Zip64ExtendedInformationExtraFieldTest.assertEquals((Object)CSIZE, (Object)f.getCompressedSize());
        Zip64ExtendedInformationExtraFieldTest.assertNull((Object)f.getRelativeHeaderOffset());
        Zip64ExtendedInformationExtraFieldTest.assertNull((Object)f.getDiskStartNumber());
    }

    public void testReadLFHSizesAndOffset() throws ZipException {
        Zip64ExtendedInformationExtraField f = new Zip64ExtendedInformationExtraField();
        byte[] b = new byte[24];
        System.arraycopy(SIZE.getBytes(), 0, b, 0, 8);
        System.arraycopy(CSIZE.getBytes(), 0, b, 8, 8);
        System.arraycopy(OFF.getBytes(), 0, b, 16, 8);
        f.parseFromLocalFileData(b, 0, b.length);
        Zip64ExtendedInformationExtraFieldTest.assertEquals((Object)SIZE, (Object)f.getSize());
        Zip64ExtendedInformationExtraFieldTest.assertEquals((Object)CSIZE, (Object)f.getCompressedSize());
        Zip64ExtendedInformationExtraFieldTest.assertEquals((Object)OFF, (Object)f.getRelativeHeaderOffset());
        Zip64ExtendedInformationExtraFieldTest.assertNull((Object)f.getDiskStartNumber());
    }

    public void testReadLFHSizesOffsetAndDisk() throws ZipException {
        Zip64ExtendedInformationExtraField f = new Zip64ExtendedInformationExtraField();
        byte[] b = new byte[28];
        System.arraycopy(SIZE.getBytes(), 0, b, 0, 8);
        System.arraycopy(CSIZE.getBytes(), 0, b, 8, 8);
        System.arraycopy(OFF.getBytes(), 0, b, 16, 8);
        System.arraycopy(DISK.getBytes(), 0, b, 24, 4);
        f.parseFromLocalFileData(b, 0, b.length);
        Zip64ExtendedInformationExtraFieldTest.assertEquals((Object)SIZE, (Object)f.getSize());
        Zip64ExtendedInformationExtraFieldTest.assertEquals((Object)CSIZE, (Object)f.getCompressedSize());
        Zip64ExtendedInformationExtraFieldTest.assertEquals((Object)OFF, (Object)f.getRelativeHeaderOffset());
        Zip64ExtendedInformationExtraFieldTest.assertEquals((Object)DISK, (Object)f.getDiskStartNumber());
    }

    public void testReadLFHSizesAndDisk() throws ZipException {
        Zip64ExtendedInformationExtraField f = new Zip64ExtendedInformationExtraField();
        byte[] b = new byte[20];
        System.arraycopy(SIZE.getBytes(), 0, b, 0, 8);
        System.arraycopy(CSIZE.getBytes(), 0, b, 8, 8);
        System.arraycopy(DISK.getBytes(), 0, b, 16, 4);
        f.parseFromLocalFileData(b, 0, b.length);
        Zip64ExtendedInformationExtraFieldTest.assertEquals((Object)SIZE, (Object)f.getSize());
        Zip64ExtendedInformationExtraFieldTest.assertEquals((Object)CSIZE, (Object)f.getCompressedSize());
        Zip64ExtendedInformationExtraFieldTest.assertNull((Object)f.getRelativeHeaderOffset());
        Zip64ExtendedInformationExtraFieldTest.assertEquals((Object)DISK, (Object)f.getDiskStartNumber());
    }

    public void testReadCDSizesOffsetAndDisk() throws ZipException {
        Zip64ExtendedInformationExtraField f = new Zip64ExtendedInformationExtraField();
        byte[] b = new byte[28];
        System.arraycopy(SIZE.getBytes(), 0, b, 0, 8);
        System.arraycopy(CSIZE.getBytes(), 0, b, 8, 8);
        System.arraycopy(OFF.getBytes(), 0, b, 16, 8);
        System.arraycopy(DISK.getBytes(), 0, b, 24, 4);
        f.parseFromCentralDirectoryData(b, 0, b.length);
        Zip64ExtendedInformationExtraFieldTest.assertEquals((Object)SIZE, (Object)f.getSize());
        Zip64ExtendedInformationExtraFieldTest.assertEquals((Object)CSIZE, (Object)f.getCompressedSize());
        Zip64ExtendedInformationExtraFieldTest.assertEquals((Object)OFF, (Object)f.getRelativeHeaderOffset());
        Zip64ExtendedInformationExtraFieldTest.assertEquals((Object)DISK, (Object)f.getDiskStartNumber());
    }

    public void testReadCDSizesAndOffset() throws ZipException {
        Zip64ExtendedInformationExtraField f = new Zip64ExtendedInformationExtraField();
        byte[] b = new byte[24];
        System.arraycopy(SIZE.getBytes(), 0, b, 0, 8);
        System.arraycopy(CSIZE.getBytes(), 0, b, 8, 8);
        System.arraycopy(OFF.getBytes(), 0, b, 16, 8);
        f.parseFromCentralDirectoryData(b, 0, b.length);
        Zip64ExtendedInformationExtraFieldTest.assertEquals((Object)SIZE, (Object)f.getSize());
        Zip64ExtendedInformationExtraFieldTest.assertEquals((Object)CSIZE, (Object)f.getCompressedSize());
        Zip64ExtendedInformationExtraFieldTest.assertEquals((Object)OFF, (Object)f.getRelativeHeaderOffset());
        Zip64ExtendedInformationExtraFieldTest.assertNull((Object)f.getDiskStartNumber());
    }

    public void testReadCDSomethingAndDisk() throws ZipException {
        Zip64ExtendedInformationExtraField f = new Zip64ExtendedInformationExtraField();
        byte[] b = new byte[12];
        System.arraycopy(SIZE.getBytes(), 0, b, 0, 8);
        System.arraycopy(DISK.getBytes(), 0, b, 8, 4);
        f.parseFromCentralDirectoryData(b, 0, b.length);
        Zip64ExtendedInformationExtraFieldTest.assertNull((Object)f.getSize());
        Zip64ExtendedInformationExtraFieldTest.assertNull((Object)f.getCompressedSize());
        Zip64ExtendedInformationExtraFieldTest.assertNull((Object)f.getRelativeHeaderOffset());
        Zip64ExtendedInformationExtraFieldTest.assertEquals((Object)DISK, (Object)f.getDiskStartNumber());
    }

    public void testReparseCDSingleEightByteData() throws ZipException {
        Zip64ExtendedInformationExtraField f = new Zip64ExtendedInformationExtraField();
        byte[] b = new byte[8];
        System.arraycopy(SIZE.getBytes(), 0, b, 0, 8);
        f.parseFromCentralDirectoryData(b, 0, b.length);
        f.reparseCentralDirectoryData(true, false, false, false);
        Zip64ExtendedInformationExtraFieldTest.assertEquals((Object)SIZE, (Object)f.getSize());
        Zip64ExtendedInformationExtraFieldTest.assertNull((Object)f.getCompressedSize());
        Zip64ExtendedInformationExtraFieldTest.assertNull((Object)f.getRelativeHeaderOffset());
        Zip64ExtendedInformationExtraFieldTest.assertNull((Object)f.getDiskStartNumber());
        f.setSize(null);
        f.reparseCentralDirectoryData(false, true, false, false);
        Zip64ExtendedInformationExtraFieldTest.assertNull((Object)f.getSize());
        Zip64ExtendedInformationExtraFieldTest.assertEquals((Object)SIZE, (Object)f.getCompressedSize());
        Zip64ExtendedInformationExtraFieldTest.assertNull((Object)f.getRelativeHeaderOffset());
        Zip64ExtendedInformationExtraFieldTest.assertNull((Object)f.getDiskStartNumber());
        f.setCompressedSize(null);
        f.reparseCentralDirectoryData(false, false, true, false);
        Zip64ExtendedInformationExtraFieldTest.assertNull((Object)f.getSize());
        Zip64ExtendedInformationExtraFieldTest.assertNull((Object)f.getCompressedSize());
        Zip64ExtendedInformationExtraFieldTest.assertEquals((Object)SIZE, (Object)f.getRelativeHeaderOffset());
        Zip64ExtendedInformationExtraFieldTest.assertNull((Object)f.getDiskStartNumber());
    }

    private static void checkSizes(byte[] b) {
        Zip64ExtendedInformationExtraFieldTest.assertEquals((int)120, (int)b[0]);
        Zip64ExtendedInformationExtraFieldTest.assertEquals((int)86, (int)b[1]);
        Zip64ExtendedInformationExtraFieldTest.assertEquals((int)52, (int)b[2]);
        Zip64ExtendedInformationExtraFieldTest.assertEquals((int)18, (int)b[3]);
        Zip64ExtendedInformationExtraFieldTest.assertEquals((int)0, (int)b[4]);
        Zip64ExtendedInformationExtraFieldTest.assertEquals((int)0, (int)b[5]);
        Zip64ExtendedInformationExtraFieldTest.assertEquals((int)0, (int)b[6]);
        Zip64ExtendedInformationExtraFieldTest.assertEquals((int)0, (int)b[7]);
        Zip64ExtendedInformationExtraFieldTest.assertEquals((byte)-17, (byte)b[8]);
        Zip64ExtendedInformationExtraFieldTest.assertEquals((byte)-51, (byte)b[9]);
        Zip64ExtendedInformationExtraFieldTest.assertEquals((byte)-85, (byte)b[10]);
        Zip64ExtendedInformationExtraFieldTest.assertEquals((int)9, (int)b[11]);
        Zip64ExtendedInformationExtraFieldTest.assertEquals((int)0, (int)b[12]);
        Zip64ExtendedInformationExtraFieldTest.assertEquals((int)0, (int)b[13]);
        Zip64ExtendedInformationExtraFieldTest.assertEquals((int)0, (int)b[14]);
        Zip64ExtendedInformationExtraFieldTest.assertEquals((int)0, (int)b[15]);
    }

    private static void checkOffset(byte[] b, int off) {
        Zip64ExtendedInformationExtraFieldTest.assertEquals((int)120, (int)b[0 + off]);
        Zip64ExtendedInformationExtraFieldTest.assertEquals((int)86, (int)b[1 + off]);
        Zip64ExtendedInformationExtraFieldTest.assertEquals((int)52, (int)b[2 + off]);
        Zip64ExtendedInformationExtraFieldTest.assertEquals((int)18, (int)b[3 + off]);
        Zip64ExtendedInformationExtraFieldTest.assertEquals((byte)9, (byte)b[4 + off]);
        Zip64ExtendedInformationExtraFieldTest.assertEquals((byte)-17, (byte)b[5 + off]);
        Zip64ExtendedInformationExtraFieldTest.assertEquals((byte)-51, (byte)b[6 + off]);
        Zip64ExtendedInformationExtraFieldTest.assertEquals((byte)-85, (byte)b[7 + off]);
    }

    private static void checkDisk(byte[] b, int off) {
        Zip64ExtendedInformationExtraFieldTest.assertEquals((int)18, (int)b[0 + off]);
        Zip64ExtendedInformationExtraFieldTest.assertEquals((int)0, (int)b[1 + off]);
        Zip64ExtendedInformationExtraFieldTest.assertEquals((int)0, (int)b[2 + off]);
        Zip64ExtendedInformationExtraFieldTest.assertEquals((int)0, (int)b[3 + off]);
    }
}

