/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.archivers.zip;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.util.Enumeration;
import java.util.Random;
import org.apache.commons.compress.AbstractTestCase;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.zip.Zip64Mode;
import org.apache.commons.compress.archivers.zip.Zip64RequiredException;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveInputStream;
import org.apache.commons.compress.archivers.zip.ZipArchiveOutputStream;
import org.apache.commons.compress.archivers.zip.ZipEightByteInteger;
import org.apache.commons.compress.archivers.zip.ZipFile;
import org.apache.commons.compress.archivers.zip.ZipLong;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Test;

public class Zip64SupportIT {
    private static final long FIVE_BILLION = 5000000000L;
    private static final int ONE_MILLION = 1000000;
    private static final int ONE_HUNDRED_THOUSAND = 100000;
    private static final ZipOutputTest write100KFilesModeNever = new ZipOutputTest(){

        public void test(File f, ZipArchiveOutputStream zos) throws IOException {
            zos.setUseZip64(Zip64Mode.Never);
            try {
                Zip64SupportIT.write100KFilesToStream(zos);
                Assert.fail((String)"expected a Zip64RequiredException");
            }
            catch (Zip64RequiredException ex) {
                Assert.assertEquals((Object)"archive contains more than 65535 entries.", (Object)ex.getMessage());
            }
        }
    };
    private static final ZipOutputTest write3EntriesCreatingBigArchiveModeNever = new ZipOutputTest(){

        public void test(File f, ZipArchiveOutputStream zos) throws IOException {
            zos.setUseZip64(Zip64Mode.Never);
            try {
                Zip64SupportIT.write3EntriesCreatingBigArchiveToStream(zos);
                Assert.fail((String)"expected a Zip64RequiredException");
            }
            catch (Zip64RequiredException ex) {
                Assert.assertEquals((Object)"archive's size exceeds the limit of 4GByte.", (Object)ex.getMessage());
            }
        }
    };

    @Test
    public void read5GBOfZerosUsingInputStream() throws Throwable {
        Zip64SupportIT.read5GBOfZerosImpl(Zip64SupportIT.get5GBZerosFile(), "5GB_of_Zeros");
    }

    @Test
    public void read5GBOfZerosGeneratedBy7ZIPUsingInputStream() throws Throwable {
        Zip64SupportIT.read5GBOfZerosImpl(Zip64SupportIT.get5GBZerosFileGeneratedBy7ZIP(), "5GB_of_Zeros");
    }

    @Test
    public void read5GBOfZerosGeneratedByJava7JarUsingInputStream() throws Throwable {
        Zip64SupportIT.read5GBOfZerosImpl(Zip64SupportIT.get5GBZerosFileGeneratedByJava7Jar(), "5GB_of_Zeros");
    }

    @Test
    public void read5GBOfZerosGeneratedByWinZIPUsingInputStream() throws Throwable {
        Zip64SupportIT.read5GBOfZerosImpl(Zip64SupportIT.get5GBZerosFileGeneratedByWinZIP(), "5GB_of_Zeros");
    }

    @Test
    public void read5GBOfZerosGeneratedByPKZipUsingInputStream() throws Throwable {
        Zip64SupportIT.read5GBOfZerosImpl(Zip64SupportIT.get5GBZerosFileGeneratedByPKZip(), "zip6/5GB_of_Zeros");
    }

    @Test
    public void read100KFilesUsingInputStream() throws Throwable {
        Zip64SupportIT.read100KFilesImpl(Zip64SupportIT.get100KFileFile());
    }

    @Test
    public void read100KFilesGeneratedBy7ZIPUsingInputStream() throws Throwable {
        Zip64SupportIT.read100KFilesImpl(Zip64SupportIT.get100KFileFileGeneratedBy7ZIP());
    }

    @Test
    public void read100KFilesGeneratedByWinCFUsingInputStream() throws Throwable {
        Zip64SupportIT.read100KFilesImpl(Zip64SupportIT.get100KFileFileGeneratedByWinCF());
    }

    @Test
    public void read100KFilesGeneratedByJava7JarUsingInputStream() throws Throwable {
        Zip64SupportIT.read100KFilesImpl(Zip64SupportIT.get100KFileFileGeneratedByJava7Jar());
    }

    @Test
    public void read100KFilesGeneratedByWinZIPUsingInputStream() throws Throwable {
        Zip64SupportIT.read100KFilesImpl(Zip64SupportIT.get100KFileFileGeneratedByWinZIP());
    }

    @Test
    public void read100KFilesGeneratedByPKZipUsingInputStream() throws Throwable {
        Zip64SupportIT.read100KFilesImpl(Zip64SupportIT.get100KFileFileGeneratedByPKZip());
    }

    @Test
    public void read5GBOfZerosUsingZipFile() throws Throwable {
        Zip64SupportIT.read5GBOfZerosUsingZipFileImpl(Zip64SupportIT.get5GBZerosFile(), "5GB_of_Zeros");
    }

    @Test
    public void read5GBOfZerosGeneratedBy7ZIPUsingZipFile() throws Throwable {
        Zip64SupportIT.read5GBOfZerosUsingZipFileImpl(Zip64SupportIT.get5GBZerosFileGeneratedBy7ZIP(), "5GB_of_Zeros");
    }

    @Test
    public void read5GBOfZerosGeneratedByJava7JarUsingZipFile() throws Throwable {
        Zip64SupportIT.read5GBOfZerosUsingZipFileImpl(Zip64SupportIT.get5GBZerosFileGeneratedByJava7Jar(), "5GB_of_Zeros");
    }

    @Test
    public void read5GBOfZerosGeneratedByWinZIPUsingZipFile() throws Throwable {
        Zip64SupportIT.read5GBOfZerosUsingZipFileImpl(Zip64SupportIT.get5GBZerosFileGeneratedByWinZIP(), "5GB_of_Zeros");
    }

    @Test
    public void read5GBOfZerosGeneratedByPKZipUsingZipFile() throws Throwable {
        Zip64SupportIT.read5GBOfZerosUsingZipFileImpl(Zip64SupportIT.get5GBZerosFileGeneratedByPKZip(), "zip6/5GB_of_Zeros");
    }

    @Test
    public void read100KFilesUsingZipFile() throws Throwable {
        Zip64SupportIT.read100KFilesUsingZipFileImpl(Zip64SupportIT.get100KFileFile());
    }

    @Test
    public void read100KFilesGeneratedBy7ZIPUsingZipFile() throws Throwable {
        Zip64SupportIT.read100KFilesUsingZipFileImpl(Zip64SupportIT.get100KFileFileGeneratedBy7ZIP());
    }

    @Test
    public void read100KFilesGeneratedByWinCFUsingZipFile() throws Throwable {
        Zip64SupportIT.read100KFilesUsingZipFileImpl(Zip64SupportIT.get100KFileFileGeneratedByWinCF());
    }

    @Test
    public void read100KFilesGeneratedByJava7JarUsingZipFile() throws Throwable {
        Zip64SupportIT.read100KFilesUsingZipFileImpl(Zip64SupportIT.get100KFileFileGeneratedByJava7Jar());
    }

    @Test
    public void read100KFilesGeneratedByWinZIPUsingZipFile() throws Throwable {
        Zip64SupportIT.read100KFilesUsingZipFileImpl(Zip64SupportIT.get100KFileFileGeneratedByWinZIP());
    }

    @Test
    public void read100KFilesGeneratedByPKZipUsingZipFile() throws Throwable {
        Zip64SupportIT.read100KFilesUsingZipFileImpl(Zip64SupportIT.get100KFileFileGeneratedByPKZip());
    }

    private static ZipOutputTest write100KFiles() {
        return Zip64SupportIT.write100KFiles(Zip64Mode.AsNeeded);
    }

    private static ZipOutputTest write100KFiles(final Zip64Mode mode) {
        return new ZipOutputTest(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void test(File f, ZipArchiveOutputStream zos) throws IOException {
                if (mode != Zip64Mode.AsNeeded) {
                    zos.setUseZip64(mode);
                }
                Zip64SupportIT.write100KFilesToStream(zos);
                RandomAccessFile a = new RandomAccessFile(f, "r");
                try {
                    long end = a.length();
                    a.seek(end - 22L);
                    byte[] eocd = new byte[12];
                    a.readFully(eocd);
                    Assert.assertArrayEquals((byte[])new byte[]{80, 75, 5, 6, 0, 0, 0, 0, -1, -1, -1, -1}, (byte[])eocd);
                    long expectedZ64EocdOffset = end - 22L - 20L - 56L;
                    byte[] loc = ZipEightByteInteger.getBytes((long)expectedZ64EocdOffset);
                    a.seek(end - 22L - 20L);
                    byte[] z64EocdLoc = new byte[20];
                    a.readFully(z64EocdLoc);
                    Assert.assertArrayEquals((byte[])new byte[]{80, 75, 6, 7, 0, 0, 0, 0, loc[0], loc[1], loc[2], loc[3], loc[4], loc[5], loc[6], loc[7], 1, 0, 0, 0}, (byte[])z64EocdLoc);
                    a.seek(expectedZ64EocdOffset);
                    byte[] z64EocdStart = new byte[40];
                    a.readFully(z64EocdStart);
                    Assert.assertArrayEquals((byte[])new byte[]{80, 75, 6, 6, 44, 0, 0, 0, 0, 0, 0, 0, 45, 0, 45, 0, 0, 0, 0, 0, 0, 0, 0, 0, -96, -122, 1, 0, 0, 0, 0, 0, -96, -122, 1, 0, 0, 0, 0, 0}, (byte[])z64EocdStart);
                    a.seek(expectedZ64EocdOffset + 48L);
                    byte[] cdOffset = new byte[8];
                    a.readFully(cdOffset);
                    long cdLoc = ZipEightByteInteger.getLongValue((byte[])cdOffset);
                    a.seek(cdLoc);
                    byte[] sig = new byte[4];
                    a.readFully(sig);
                    Assert.assertArrayEquals((byte[])new byte[]{80, 75, 1, 2}, (byte[])sig);
                }
                finally {
                    a.close();
                }
            }
        };
    }

    @Test
    public void write100KFilesFile() throws Throwable {
        Zip64SupportIT.withTemporaryArchive("write100KFilesFile", Zip64SupportIT.write100KFiles(), true);
    }

    @Test
    public void write100KFilesStream() throws Throwable {
        Zip64SupportIT.withTemporaryArchive("write100KFilesStream", Zip64SupportIT.write100KFiles(), false);
    }

    @Test
    public void write100KFilesFileModeAlways() throws Throwable {
        Zip64SupportIT.withTemporaryArchive("write100KFilesFileModeAlways", Zip64SupportIT.write100KFiles(Zip64Mode.Always), true);
    }

    @Test
    public void write100KFilesStreamModeAlways() throws Throwable {
        Zip64SupportIT.withTemporaryArchive("write100KFilesStreamModeAlways", Zip64SupportIT.write100KFiles(Zip64Mode.Always), false);
    }

    @Test
    public void write100KFilesFileModeNever() throws Throwable {
        Zip64SupportIT.withTemporaryArchive("write100KFilesFileModeNever", write100KFilesModeNever, true);
    }

    @Test
    public void write100KFilesStreamModeNever() throws Throwable {
        Zip64SupportIT.withTemporaryArchive("write100KFilesStreamModeNever", write100KFilesModeNever, false);
    }

    @Test
    public void readSelfGenerated100KFilesUsingZipFile() throws Throwable {
        Zip64SupportIT.withTemporaryArchive("readSelfGenerated100KFilesUsingZipFile()", new ZipOutputTest(){

            public void test(File f, ZipArchiveOutputStream zos) throws IOException {
                Zip64SupportIT.write100KFilesToStream(zos);
                Zip64SupportIT.read100KFilesUsingZipFileImpl(f);
            }
        }, true);
    }

    private static ZipOutputTest write3EntriesCreatingBigArchive() {
        return Zip64SupportIT.write3EntriesCreatingBigArchive(Zip64Mode.AsNeeded);
    }

    private static ZipOutputTest write3EntriesCreatingBigArchive(final Zip64Mode mode) {
        return new ZipOutputTest(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void test(File f, ZipArchiveOutputStream zos) throws IOException {
                if (mode != Zip64Mode.AsNeeded) {
                    zos.setUseZip64(mode);
                }
                Zip64SupportIT.write3EntriesCreatingBigArchiveToStream(zos);
                RandomAccessFile a = new RandomAccessFile(f, "r");
                try {
                    Zip64SupportIT.getLengthAndPositionAtCentralDirectory(a);
                    a.skipBytes(94 + 2 * (mode == Zip64Mode.Always ? 4 : 0));
                    byte[] header = new byte[12];
                    a.readFully(header);
                    Assert.assertArrayEquals((byte[])new byte[]{80, 75, 1, 2, 45, 0, 45, 0, 0, 8, 0, 0}, (byte[])header);
                    a.skipBytes(12);
                    byte[] rest = new byte[23];
                    a.readFully(rest);
                    Assert.assertArrayEquals((byte[])new byte[]{1, 0, 0, 0, 1, 0, 12, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -1, -1, -1, -1, 50}, (byte[])rest);
                    byte[] extra = new byte[4];
                    a.readFully(extra);
                    Assert.assertArrayEquals((byte[])new byte[]{1, 0, 8, 0}, (byte[])extra);
                    byte[] offset = new byte[8];
                    a.readFully(offset);
                    a.seek(ZipEightByteInteger.getLongValue((byte[])offset));
                    byte[] sig = new byte[4];
                    a.readFully(sig);
                    Assert.assertArrayEquals((byte[])new byte[]{80, 75, 3, 4}, (byte[])sig);
                }
                finally {
                    a.close();
                }
            }
        };
    }

    @Test
    public void write3EntriesCreatingBigArchiveFile() throws Throwable {
        Zip64SupportIT.withTemporaryArchive("write3EntriesCreatingBigArchiveFile", Zip64SupportIT.write3EntriesCreatingBigArchive(), true);
    }

    @Test
    public void write3EntriesCreatingBigArchiveStream() throws Throwable {
        Zip64SupportIT.withTemporaryArchive("write3EntriesCreatingBigArchiveStream", Zip64SupportIT.write3EntriesCreatingBigArchive(), false);
    }

    @Test
    public void write3EntriesCreatingBigArchiveFileModeAlways() throws Throwable {
        Zip64SupportIT.withTemporaryArchive("write3EntriesCreatingBigArchiveFileModeAlways", Zip64SupportIT.write3EntriesCreatingBigArchive(Zip64Mode.Always), true);
    }

    @Test
    public void write3EntriesCreatingBigArchiveStreamModeAlways() throws Throwable {
        Zip64SupportIT.withTemporaryArchive("write3EntriesCreatingBigArchiveStreamModeAlways", Zip64SupportIT.write3EntriesCreatingBigArchive(Zip64Mode.Always), false);
    }

    @Test
    public void write3EntriesCreatingBigArchiveFileModeNever() throws Throwable {
        Zip64SupportIT.withTemporaryArchive("write3EntriesCreatingBigArchiveFileModeNever", write3EntriesCreatingBigArchiveModeNever, true);
    }

    @Test
    public void write3EntriesCreatingBigArchiveStreamModeNever() throws Throwable {
        Zip64SupportIT.withTemporaryArchive("write3EntriesCreatingBigArchiveStreamModeNever", write3EntriesCreatingBigArchiveModeNever, false);
    }

    @Test
    public void read3EntriesCreatingBigArchiveFileUsingZipFile() throws Throwable {
        Zip64SupportIT.withTemporaryArchive("read3EntriesCreatingBigArchiveFileUsingZipFile", new ZipOutputTest(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void test(File f, ZipArchiveOutputStream zos) throws IOException {
                Zip64SupportIT.write3EntriesCreatingBigArchiveToStream(zos);
                ZipFile zf = null;
                try {
                    zf = new ZipFile(f);
                    int idx = 0;
                    Enumeration e = zf.getEntriesInPhysicalOrder();
                    while (e.hasMoreElements()) {
                        ZipArchiveEntry zae = (ZipArchiveEntry)e.nextElement();
                        Assert.assertEquals((Object)String.valueOf(idx), (Object)zae.getName());
                        if (idx++ < 2) {
                            Assert.assertEquals((long)2500000000L, (long)zae.getSize());
                            continue;
                        }
                        Assert.assertEquals((long)1L, (long)zae.getSize());
                        InputStream i = zf.getInputStream(zae);
                        try {
                            Assert.assertNotNull((Object)i);
                            Assert.assertEquals((long)42L, (long)i.read());
                        }
                        finally {
                            i.close();
                        }
                    }
                }
                catch (Throwable throwable) {
                    ZipFile.closeQuietly(zf);
                    throw throwable;
                }
                ZipFile.closeQuietly((ZipFile)zf);
            }
        }, true);
    }

    private static ZipOutputTest writeBigStoredEntry(boolean knownSize) {
        return Zip64SupportIT.writeBigStoredEntry(knownSize, Zip64Mode.AsNeeded);
    }

    private static ZipOutputTest writeBigStoredEntry(final boolean knownSize, final Zip64Mode mode) {
        return new ZipOutputTest(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void test(File f, ZipArchiveOutputStream zos) throws IOException {
                if (mode != Zip64Mode.AsNeeded) {
                    zos.setUseZip64(mode);
                }
                byte[] buf = new byte[1000000];
                ZipArchiveEntry zae = new ZipArchiveEntry("0");
                if (knownSize) {
                    zae.setSize(5000000000L);
                    zae.setCrc(1546743632L);
                }
                zae.setMethod(0);
                zos.putArchiveEntry((ArchiveEntry)zae);
                int j = 0;
                while ((long)j < 5000L) {
                    zos.write(buf);
                    ++j;
                }
                zos.closeArchiveEntry();
                zos.close();
                RandomAccessFile a = new RandomAccessFile(f, "r");
                try {
                    Zip64SupportIT.getLengthAndPositionAtCentralDirectory(a);
                    byte[] header = new byte[12];
                    a.readFully(header);
                    Assert.assertArrayEquals((byte[])new byte[]{80, 75, 1, 2, 45, 0, 45, 0, 0, 8, 0, 0}, (byte[])header);
                    a.skipBytes(4);
                    byte[] rest = new byte[31];
                    a.readFully(rest);
                    Assert.assertArrayEquals((byte[])new byte[]{80, 111, 49, 92, -1, -1, -1, -1, -1, -1, -1, -1, 1, 0, 20, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 48}, (byte[])rest);
                    byte[] extra = new byte[20];
                    a.readFully(extra);
                    Assert.assertArrayEquals((byte[])new byte[]{1, 0, 16, 0, 0, -14, 5, 42, 1, 0, 0, 0, 0, -14, 5, 42, 1, 0, 0, 0}, (byte[])extra);
                    a.seek(0L);
                    header = new byte[10];
                    a.readFully(header);
                    Assert.assertArrayEquals((byte[])new byte[]{80, 75, 3, 4, 45, 0, 0, 8, 0, 0}, (byte[])header);
                    a.skipBytes(4);
                    rest = new byte[17];
                    a.readFully(rest);
                    Assert.assertArrayEquals((byte[])new byte[]{80, 111, 49, 92, -1, -1, -1, -1, -1, -1, -1, -1, 1, 0, 20, 0, 48}, (byte[])rest);
                    a.readFully(extra);
                    Assert.assertArrayEquals((byte[])new byte[]{1, 0, 16, 0, 0, -14, 5, 42, 1, 0, 0, 0, 0, -14, 5, 42, 1, 0, 0, 0}, (byte[])extra);
                }
                finally {
                    a.close();
                }
            }
        };
    }

    @Test
    public void writeBigStoredEntryToStream() throws Throwable {
        Zip64SupportIT.withTemporaryArchive("writeBigStoredEntryToStream", Zip64SupportIT.writeBigStoredEntry(true), false);
    }

    @Test
    public void writeBigStoredEntryKnownSizeToFile() throws Throwable {
        Zip64SupportIT.withTemporaryArchive("writeBigStoredEntryKnownSizeToFile", Zip64SupportIT.writeBigStoredEntry(true), true);
    }

    @Test
    public void writeBigStoredEntryUnnownSizeToFile() throws Throwable {
        Zip64SupportIT.withTemporaryArchive("writeBigStoredEntryUnknownSizeToFile", Zip64SupportIT.writeBigStoredEntry(false), true);
    }

    @Test
    public void writeBigStoredEntryToStreamModeAlways() throws Throwable {
        Zip64SupportIT.withTemporaryArchive("writeBigStoredEntryToStreamModeAlways", Zip64SupportIT.writeBigStoredEntry(true, Zip64Mode.Always), false);
    }

    @Test
    public void writeBigStoredEntryKnownSizeToFileModeAlways() throws Throwable {
        Zip64SupportIT.withTemporaryArchive("writeBigStoredEntryKnownSizeToFileModeAlways", Zip64SupportIT.writeBigStoredEntry(true, Zip64Mode.Always), true);
    }

    @Test
    public void writeBigStoredEntryUnnownSizeToFileModeAlways() throws Throwable {
        Zip64SupportIT.withTemporaryArchive("writeBigStoredEntryUnknownSizeToFileModeAlways", Zip64SupportIT.writeBigStoredEntry(false, Zip64Mode.Always), true);
    }

    private static ZipOutputTest writeBigStoredEntryModeNever(final boolean knownSize) {
        return new ZipOutputTest(){

            public void test(File f, ZipArchiveOutputStream zos) throws IOException {
                zos.setUseZip64(Zip64Mode.Never);
                try {
                    byte[] buf = new byte[1000000];
                    ZipArchiveEntry zae = new ZipArchiveEntry("0");
                    if (knownSize) {
                        zae.setSize(5000000000L);
                        zae.setCrc(1546743632L);
                    }
                    zae.setMethod(0);
                    zos.putArchiveEntry((ArchiveEntry)zae);
                    int j = 0;
                    while ((long)j < 5000L) {
                        zos.write(buf);
                        ++j;
                    }
                    zos.closeArchiveEntry();
                    Assert.fail((String)"expected a Zip64RequiredException");
                }
                catch (Zip64RequiredException ex) {
                    Assert.assertTrue((boolean)ex.getMessage().startsWith("0's size"));
                }
            }
        };
    }

    @Test
    public void writeBigStoredEntryToStreamModeNever() throws Throwable {
        Zip64SupportIT.withTemporaryArchive("writeBigStoredEntryToStreamModeNever", Zip64SupportIT.writeBigStoredEntryModeNever(true), false);
    }

    @Test
    public void writeBigStoredEntryKnownSizeToFileModeNever() throws Throwable {
        Zip64SupportIT.withTemporaryArchive("writeBigStoredEntryKnownSizeToFileModeNever", Zip64SupportIT.writeBigStoredEntryModeNever(true), true);
    }

    @Test
    public void writeBigStoredEntryUnnownSizeToFileModeNever() throws Throwable {
        Zip64SupportIT.withTemporaryArchive("writeBigStoredEntryUnknownSizeToFileModeNever", Zip64SupportIT.writeBigStoredEntryModeNever(false), true);
    }

    private static ZipOutputTest writeBigDeflatedEntryToStream(final boolean knownSize, final Zip64Mode mode) {
        return new ZipOutputTest(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void test(File f, ZipArchiveOutputStream zos) throws IOException {
                if (mode != Zip64Mode.AsNeeded) {
                    zos.setUseZip64(mode);
                }
                byte[] buf = new byte[1000000];
                ZipArchiveEntry zae = new ZipArchiveEntry("0");
                if (knownSize) {
                    zae.setSize(5000000000L);
                }
                zae.setMethod(8);
                zos.putArchiveEntry((ArchiveEntry)zae);
                int j = 0;
                while ((long)j < 5000L) {
                    zos.write(buf);
                    ++j;
                }
                zos.closeArchiveEntry();
                zos.close();
                RandomAccessFile a = new RandomAccessFile(f, "r");
                try {
                    Zip64SupportIT.getLengthAndPositionAtCentralDirectory(a);
                    long cfhPos = a.getFilePointer();
                    byte[] header = new byte[12];
                    a.readFully(header);
                    Assert.assertArrayEquals((byte[])new byte[]{80, 75, 1, 2, 45, 0, 45, 0, 8, 8, 8, 0}, (byte[])header);
                    a.skipBytes(4);
                    byte[] rest = new byte[31];
                    a.readFully(rest);
                    Assert.assertArrayEquals((byte[])new byte[]{80, 111, 49, 92, -1, -1, -1, -1, -1, -1, -1, -1, 1, 0, 20, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 48}, (byte[])rest);
                    byte[] extra = new byte[20];
                    a.readFully(extra);
                    Assert.assertArrayEquals((byte[])new byte[]{1, 0, 16, 0, 0, -14, 5, 42, 1, 0, 0, 0, 104, 39, 74, 0, 0, 0, 0, 0}, (byte[])extra);
                    a.seek(cfhPos - 24L);
                    byte[] dd = new byte[8];
                    a.readFully(dd);
                    Assert.assertArrayEquals((byte[])new byte[]{80, 75, 7, 8, 80, 111, 49, 92}, (byte[])dd);
                    dd = new byte[16];
                    a.readFully(dd);
                    Assert.assertArrayEquals((byte[])new byte[]{104, 39, 74, 0, 0, 0, 0, 0, 0, -14, 5, 42, 1, 0, 0, 0}, (byte[])dd);
                    a.seek(0L);
                    header = new byte[10];
                    a.readFully(header);
                    Assert.assertArrayEquals((byte[])new byte[]{80, 75, 3, 4, 45, 0, 8, 8, 8, 0}, (byte[])header);
                    a.skipBytes(4);
                    rest = new byte[17];
                    a.readFully(rest);
                    Assert.assertArrayEquals((byte[])new byte[]{0, 0, 0, 0, -1, -1, -1, -1, -1, -1, -1, -1, 1, 0, 20, 0, 48}, (byte[])rest);
                    a.readFully(extra);
                    Assert.assertArrayEquals((byte[])new byte[]{1, 0, 16, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, (byte[])extra);
                }
                finally {
                    a.close();
                }
            }
        };
    }

    @Test
    public void writeBigDeflatedEntryKnownSizeToStream() throws Throwable {
        Zip64SupportIT.withTemporaryArchive("writeBigDeflatedEntryKnownSizeToStream", Zip64SupportIT.writeBigDeflatedEntryToStream(true, Zip64Mode.AsNeeded), false);
    }

    @Test
    public void writeBigDeflatedEntryKnownSizeToStreamModeAlways() throws Throwable {
        Zip64SupportIT.withTemporaryArchive("writeBigDeflatedEntryKnownSizeToStreamModeAlways", Zip64SupportIT.writeBigDeflatedEntryToStream(true, Zip64Mode.Always), false);
    }

    @Test
    public void writeBigDeflatedEntryUnknownSizeToStreamModeAlways() throws Throwable {
        Zip64SupportIT.withTemporaryArchive("writeBigDeflatedEntryUnknownSizeToStreamModeAlways", Zip64SupportIT.writeBigDeflatedEntryToStream(false, Zip64Mode.Always), false);
    }

    private static ZipOutputTest writeBigDeflatedEntryUnknownSizeToStream(final Zip64Mode mode) {
        return new ZipOutputTest(){

            public void test(File f, ZipArchiveOutputStream zos) throws IOException {
                try {
                    if (mode != Zip64Mode.AsNeeded) {
                        zos.setUseZip64(mode);
                    }
                    byte[] buf = new byte[1000000];
                    ZipArchiveEntry zae = new ZipArchiveEntry("0");
                    zae.setMethod(8);
                    zos.putArchiveEntry((ArchiveEntry)zae);
                    int j = 0;
                    while ((long)j < 5000L) {
                        zos.write(buf);
                        ++j;
                    }
                    zos.closeArchiveEntry();
                    Assert.fail((String)"expected a Zip64RequiredException");
                }
                catch (Zip64RequiredException ex) {
                    Assert.assertTrue((boolean)ex.getMessage().startsWith("0's size"));
                }
            }
        };
    }

    @Test
    public void writeBigDeflatedEntryUnknownSizeToStream() throws Throwable {
        Zip64SupportIT.withTemporaryArchive("writeBigDeflatedEntryUnknownSizeToStream", Zip64SupportIT.writeBigDeflatedEntryUnknownSizeToStream(Zip64Mode.AsNeeded), false);
    }

    @Test
    public void writeBigDeflatedEntryUnknownSizeToStreamModeNever() throws Throwable {
        Zip64SupportIT.withTemporaryArchive("writeBigDeflatedEntryUnknownSizeToStreamModeNever", Zip64SupportIT.writeBigDeflatedEntryUnknownSizeToStream(Zip64Mode.Never), false);
    }

    private static ZipOutputTest writeBigDeflatedEntryToFile(boolean knownSize) {
        return Zip64SupportIT.writeBigDeflatedEntryToFile(knownSize, Zip64Mode.AsNeeded);
    }

    private static ZipOutputTest writeBigDeflatedEntryToFile(final boolean knownSize, final Zip64Mode mode) {
        return new ZipOutputTest(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void test(File f, ZipArchiveOutputStream zos) throws IOException {
                if (mode != Zip64Mode.AsNeeded) {
                    zos.setUseZip64(mode);
                }
                byte[] buf = new byte[1000000];
                ZipArchiveEntry zae = new ZipArchiveEntry("0");
                if (knownSize) {
                    zae.setSize(5000000000L);
                }
                zae.setMethod(8);
                zos.putArchiveEntry((ArchiveEntry)zae);
                int j = 0;
                while ((long)j < 5000L) {
                    zos.write(buf);
                    ++j;
                }
                zos.closeArchiveEntry();
                zos.close();
                RandomAccessFile a = new RandomAccessFile(f, "r");
                try {
                    Zip64SupportIT.getLengthAndPositionAtCentralDirectory(a);
                    byte[] header = new byte[12];
                    a.readFully(header);
                    Assert.assertArrayEquals((byte[])new byte[]{80, 75, 1, 2, 45, 0, 45, 0, 0, 8, 8, 0}, (byte[])header);
                    a.skipBytes(4);
                    byte[] rest = new byte[31];
                    a.readFully(rest);
                    Assert.assertArrayEquals((byte[])new byte[]{80, 111, 49, 92, -1, -1, -1, -1, -1, -1, -1, -1, 1, 0, 20, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 48}, (byte[])rest);
                    byte[] extra = new byte[20];
                    a.readFully(extra);
                    Assert.assertArrayEquals((byte[])new byte[]{1, 0, 16, 0, 0, -14, 5, 42, 1, 0, 0, 0, 104, 39, 74, 0, 0, 0, 0, 0}, (byte[])extra);
                    a.seek(0L);
                    header = new byte[10];
                    a.readFully(header);
                    Assert.assertArrayEquals((byte[])new byte[]{80, 75, 3, 4, 45, 0, 0, 8, 8, 0}, (byte[])header);
                    a.skipBytes(4);
                    rest = new byte[17];
                    a.readFully(rest);
                    Assert.assertArrayEquals((byte[])new byte[]{80, 111, 49, 92, -1, -1, -1, -1, -1, -1, -1, -1, 1, 0, 20, 0, 48}, (byte[])rest);
                    extra = new byte[20];
                    a.readFully(extra);
                    Assert.assertArrayEquals((byte[])new byte[]{1, 0, 16, 0, 0, -14, 5, 42, 1, 0, 0, 0, 104, 39, 74, 0, 0, 0, 0, 0}, (byte[])extra);
                }
                finally {
                    a.close();
                }
            }
        };
    }

    @Test
    public void writeBigDeflatedEntryKnownSizeToFile() throws Throwable {
        Zip64SupportIT.withTemporaryArchive("writeBigDeflatedEntryKnownSizeToFile", Zip64SupportIT.writeBigDeflatedEntryToFile(true), true);
    }

    @Test
    public void writeBigDeflatedEntryUnknownSizeToFile() throws Throwable {
        Zip64SupportIT.withTemporaryArchive("writeBigDeflatedEntryUnknownSizeToFile", Zip64SupportIT.writeBigDeflatedEntryToFile(false), true);
    }

    @Test
    public void writeBigDeflatedEntryKnownSizeToFileModeAlways() throws Throwable {
        Zip64SupportIT.withTemporaryArchive("writeBigDeflatedEntryKnownSizeToFileModeAlways", Zip64SupportIT.writeBigDeflatedEntryToFile(true, Zip64Mode.Always), true);
    }

    @Test
    public void writeBigDeflatedEntryUnknownSizeToFileModeAlways() throws Throwable {
        Zip64SupportIT.withTemporaryArchive("writeBigDeflatedEntryUnknownSizeToFileModeAlways", Zip64SupportIT.writeBigDeflatedEntryToFile(false, Zip64Mode.Always), true);
    }

    @Test
    public void writeBigDeflatedEntryKnownSizeToStreamModeNever() throws Throwable {
        Zip64SupportIT.withTemporaryArchive("writeBigDeflatedEntryKnownSizeToStreamModeNever", new ZipOutputTest(){

            public void test(File f, ZipArchiveOutputStream zos) throws IOException {
                zos.setUseZip64(Zip64Mode.Never);
                try {
                    ZipArchiveEntry zae = new ZipArchiveEntry("0");
                    zae.setSize(5000000000L);
                    zae.setMethod(8);
                    zos.putArchiveEntry((ArchiveEntry)zae);
                    Assert.fail((String)"expected a Zip64RequiredException");
                }
                catch (Zip64RequiredException ex) {
                    Assert.assertTrue((boolean)ex.getMessage().startsWith("0's size"));
                }
            }
        }, false);
    }

    private static ZipOutputTest writeBigDeflatedEntryToFileModeNever(final boolean knownSize) {
        return new ZipOutputTest(){

            public void test(File f, ZipArchiveOutputStream zos) throws IOException {
                zos.setUseZip64(Zip64Mode.Never);
                try {
                    byte[] buf = new byte[1000000];
                    ZipArchiveEntry zae = new ZipArchiveEntry("0");
                    if (knownSize) {
                        zae.setSize(5000000000L);
                    }
                    zae.setMethod(8);
                    zos.putArchiveEntry((ArchiveEntry)zae);
                    int j = 0;
                    while ((long)j < 5000L) {
                        zos.write(buf);
                        ++j;
                    }
                    zos.closeArchiveEntry();
                    Assert.fail((String)"expected a Zip64RequiredException");
                }
                catch (Zip64RequiredException ex) {
                    Assert.assertTrue((boolean)ex.getMessage().startsWith("0's size"));
                }
            }
        };
    }

    @Test
    public void writeBigDeflatedEntryKnownSizeToFileModeNever() throws Throwable {
        Zip64SupportIT.withTemporaryArchive("writeBigDeflatedEntryKnownSizeToFileModeNever", Zip64SupportIT.writeBigDeflatedEntryToFileModeNever(true), true);
    }

    @Test
    public void writeBigDeflatedEntryUnknownSizeToFileModeNever() throws Throwable {
        Zip64SupportIT.withTemporaryArchive("writeBigDeflatedEntryUnknownSizeToFileModeNever", Zip64SupportIT.writeBigDeflatedEntryToFileModeNever(false), true);
    }

    private static ZipOutputTest writeSmallStoredEntry(boolean knownSize) {
        return Zip64SupportIT.writeSmallStoredEntry(knownSize, Zip64Mode.AsNeeded);
    }

    private static ZipOutputTest writeSmallStoredEntry(final boolean knownSize, final Zip64Mode mode) {
        return new ZipOutputTest(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void test(File f, ZipArchiveOutputStream zos) throws IOException {
                if (mode != Zip64Mode.AsNeeded) {
                    zos.setUseZip64(mode);
                }
                byte[] buf = new byte[1000000];
                ZipArchiveEntry zae = new ZipArchiveEntry("0");
                if (knownSize) {
                    zae.setSize(1000000L);
                    zae.setCrc(309971870L);
                }
                zae.setMethod(0);
                zos.putArchiveEntry((ArchiveEntry)zae);
                zos.write(buf);
                zos.closeArchiveEntry();
                zos.close();
                RandomAccessFile a = new RandomAccessFile(f, "r");
                try {
                    Zip64SupportIT.getLengthAndPositionAtCentralDirectory(a);
                    byte[] header = new byte[12];
                    a.readFully(header);
                    Assert.assertArrayEquals((byte[])new byte[]{80, 75, 1, 2, 20, 0, 10, 0, 0, 8, 0, 0}, (byte[])header);
                    a.skipBytes(4);
                    byte[] rest = new byte[31];
                    a.readFully(rest);
                    Assert.assertArrayEquals((byte[])new byte[]{-98, -53, 121, 18, 64, 66, 15, 0, 64, 66, 15, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 48}, (byte[])rest);
                    boolean hasExtra = mode == Zip64Mode.Always || mode == Zip64Mode.AsNeeded && !knownSize;
                    a.seek(0L);
                    header = new byte[10];
                    a.readFully(header);
                    Assert.assertArrayEquals((byte[])new byte[]{80, 75, 3, 4, 10, 0, 0, 8, 0, 0}, (byte[])header);
                    a.skipBytes(4);
                    rest = new byte[17];
                    a.readFully(rest);
                    Assert.assertArrayEquals((byte[])new byte[]{-98, -53, 121, 18, 64, 66, 15, 0, 64, 66, 15, 0, 1, 0, (byte)(!hasExtra ? 0 : 20), 0, 48}, (byte[])rest);
                    if (hasExtra) {
                        byte[] extra = new byte[20];
                        a.readFully(extra);
                        Assert.assertArrayEquals((byte[])new byte[]{1, 0, 16, 0, 64, 66, 15, 0, 0, 0, 0, 0, 64, 66, 15, 0, 0, 0, 0, 0}, (byte[])extra);
                    }
                }
                finally {
                    a.close();
                }
            }
        };
    }

    @Test
    public void writeSmallStoredEntryToStream() throws Throwable {
        Zip64SupportIT.withTemporaryArchive("writeSmallStoredEntryToStream", Zip64SupportIT.writeSmallStoredEntry(true), false);
    }

    @Test
    public void writeSmallStoredEntryKnownSizeToFile() throws Throwable {
        Zip64SupportIT.withTemporaryArchive("writeSmallStoredEntryKnownSizeToFile", Zip64SupportIT.writeSmallStoredEntry(true), true);
    }

    @Test
    public void writeSmallStoredEntryUnnownSizeToFile() throws Throwable {
        Zip64SupportIT.withTemporaryArchive("writeSmallStoredEntryUnknownSizeToFile", Zip64SupportIT.writeSmallStoredEntry(false), true);
    }

    @Test
    public void writeSmallStoredEntryToStreamModeNever() throws Throwable {
        Zip64SupportIT.withTemporaryArchive("writeSmallStoredEntryToStreamModeNever", Zip64SupportIT.writeSmallStoredEntry(true, Zip64Mode.Never), false);
    }

    @Test
    public void writeSmallStoredEntryKnownSizeToFileModeNever() throws Throwable {
        Zip64SupportIT.withTemporaryArchive("writeSmallStoredEntryKnownSizeToFileModeNever", Zip64SupportIT.writeSmallStoredEntry(true, Zip64Mode.Never), true);
    }

    @Test
    public void writeSmallStoredEntryUnnownSizeToFileModeNever() throws Throwable {
        Zip64SupportIT.withTemporaryArchive("writeSmallStoredEntryUnknownSizeToFileModeNever", Zip64SupportIT.writeSmallStoredEntry(false, Zip64Mode.Never), true);
    }

    private static ZipOutputTest writeSmallStoredEntryModeAlways(final boolean knownSize) {
        return new ZipOutputTest(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void test(File f, ZipArchiveOutputStream zos) throws IOException {
                zos.setUseZip64(Zip64Mode.Always);
                byte[] buf = new byte[1000000];
                ZipArchiveEntry zae = new ZipArchiveEntry("0");
                if (knownSize) {
                    zae.setSize(1000000L);
                    zae.setCrc(309971870L);
                }
                zae.setMethod(0);
                zos.putArchiveEntry((ArchiveEntry)zae);
                zos.write(buf);
                zos.closeArchiveEntry();
                zos.close();
                RandomAccessFile a = new RandomAccessFile(f, "r");
                try {
                    Zip64SupportIT.getLengthAndPositionAtCentralDirectory(a);
                    byte[] header = new byte[12];
                    a.readFully(header);
                    Assert.assertArrayEquals((byte[])new byte[]{80, 75, 1, 2, 45, 0, 45, 0, 0, 8, 0, 0}, (byte[])header);
                    a.skipBytes(4);
                    byte[] rest = new byte[31];
                    a.readFully(rest);
                    Assert.assertArrayEquals((byte[])new byte[]{-98, -53, 121, 18, 64, 66, 15, 0, 64, 66, 15, 0, 1, 0, 4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 48}, (byte[])rest);
                    byte[] extra = new byte[4];
                    a.readFully(extra);
                    Assert.assertArrayEquals((byte[])new byte[]{1, 0, 0, 0}, (byte[])extra);
                    a.seek(0L);
                    header = new byte[10];
                    a.readFully(header);
                    Assert.assertArrayEquals((byte[])new byte[]{80, 75, 3, 4, 45, 0, 0, 8, 0, 0}, (byte[])header);
                    a.skipBytes(4);
                    rest = new byte[17];
                    a.readFully(rest);
                    Assert.assertArrayEquals((byte[])new byte[]{-98, -53, 121, 18, -1, -1, -1, -1, -1, -1, -1, -1, 1, 0, 20, 0, 48}, (byte[])rest);
                    extra = new byte[20];
                    a.readFully(extra);
                    Assert.assertArrayEquals((byte[])new byte[]{1, 0, 16, 0, 64, 66, 15, 0, 0, 0, 0, 0, 64, 66, 15, 0, 0, 0, 0, 0}, (byte[])extra);
                }
                finally {
                    a.close();
                }
            }
        };
    }

    @Test
    public void writeSmallStoredEntryToStreamModeAlways() throws Throwable {
        Zip64SupportIT.withTemporaryArchive("writeSmallStoredEntryToStreamModeAlways", Zip64SupportIT.writeSmallStoredEntryModeAlways(true), false);
    }

    @Test
    public void writeSmallStoredEntryKnownSizeToFileModeAlways() throws Throwable {
        Zip64SupportIT.withTemporaryArchive("writeSmallStoredEntryKnownSizeToFileModeAlways", Zip64SupportIT.writeSmallStoredEntryModeAlways(true), true);
    }

    @Test
    public void writeSmallStoredEntryUnnownSizeToFileModeAlways() throws Throwable {
        Zip64SupportIT.withTemporaryArchive("writeSmallStoredEntryUnknownSizeToFileModeAlways", Zip64SupportIT.writeSmallStoredEntryModeAlways(false), true);
    }

    private static ZipOutputTest writeSmallDeflatedEntryToStream(final boolean knownSize, final Zip64Mode mode) {
        return new ZipOutputTest(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void test(File f, ZipArchiveOutputStream zos) throws IOException {
                if (mode != Zip64Mode.AsNeeded) {
                    zos.setUseZip64(mode);
                }
                byte[] buf = new byte[1000000];
                ZipArchiveEntry zae = new ZipArchiveEntry("0");
                if (knownSize) {
                    zae.setSize(1000000L);
                }
                zae.setMethod(8);
                zos.putArchiveEntry((ArchiveEntry)zae);
                zos.write(buf);
                zos.closeArchiveEntry();
                zos.close();
                RandomAccessFile a = new RandomAccessFile(f, "r");
                try {
                    Zip64SupportIT.getLengthAndPositionAtCentralDirectory(a);
                    long cfhPos = a.getFilePointer();
                    byte[] header = new byte[12];
                    a.readFully(header);
                    Assert.assertArrayEquals((byte[])new byte[]{80, 75, 1, 2, 20, 0, 20, 0, 8, 8, 8, 0}, (byte[])header);
                    a.skipBytes(4);
                    byte[] crc = new byte[4];
                    a.readFully(crc);
                    Assert.assertArrayEquals((byte[])new byte[]{-98, -53, 121, 18}, (byte[])crc);
                    a.skipBytes(4);
                    byte[] rest = new byte[23];
                    a.readFully(rest);
                    Assert.assertArrayEquals((byte[])new byte[]{64, 66, 15, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 48}, (byte[])rest);
                    a.seek(cfhPos - 16L);
                    byte[] dd = new byte[8];
                    a.readFully(dd);
                    Assert.assertArrayEquals((byte[])new byte[]{80, 75, 7, 8, -98, -53, 121, 18}, (byte[])dd);
                    a.skipBytes(4);
                    dd = new byte[4];
                    a.readFully(dd);
                    Assert.assertArrayEquals((byte[])new byte[]{64, 66, 15, 0}, (byte[])dd);
                    a.seek(0L);
                    header = new byte[10];
                    a.readFully(header);
                    Assert.assertArrayEquals((byte[])new byte[]{80, 75, 3, 4, 20, 0, 8, 8, 8, 0}, (byte[])header);
                    a.skipBytes(4);
                    rest = new byte[17];
                    a.readFully(rest);
                    Assert.assertArrayEquals((byte[])new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 48}, (byte[])rest);
                }
                finally {
                    a.close();
                }
            }
        };
    }

    @Test
    public void writeSmallDeflatedEntryKnownSizeToStream() throws Throwable {
        Zip64SupportIT.withTemporaryArchive("writeSmallDeflatedEntryKnownSizeToStream", Zip64SupportIT.writeSmallDeflatedEntryToStream(true, Zip64Mode.AsNeeded), false);
    }

    @Test
    public void writeSmallDeflatedEntryKnownSizeToStreamModeNever() throws Throwable {
        Zip64SupportIT.withTemporaryArchive("writeSmallDeflatedEntryKnownSizeToStreamModeNever", Zip64SupportIT.writeSmallDeflatedEntryToStream(true, Zip64Mode.Never), false);
    }

    @Test
    public void writeSmallDeflatedEntryUnknownSizeToStream() throws Throwable {
        Zip64SupportIT.withTemporaryArchive("writeSmallDeflatedEntryUnknownSizeToStream", Zip64SupportIT.writeSmallDeflatedEntryToStream(false, Zip64Mode.AsNeeded), false);
    }

    @Test
    public void writeSmallDeflatedEntryUnknownSizeToStreamModeNever() throws Throwable {
        Zip64SupportIT.withTemporaryArchive("writeSmallDeflatedEntryUnknownSizeToStreamModeNever", Zip64SupportIT.writeSmallDeflatedEntryToStream(false, Zip64Mode.Never), false);
    }

    private static ZipOutputTest writeSmallDeflatedEntryToStreamModeAlways(final boolean knownSize) {
        return new ZipOutputTest(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void test(File f, ZipArchiveOutputStream zos) throws IOException {
                zos.setUseZip64(Zip64Mode.Always);
                byte[] buf = new byte[1000000];
                ZipArchiveEntry zae = new ZipArchiveEntry("0");
                if (knownSize) {
                    zae.setSize(1000000L);
                }
                zae.setMethod(8);
                zos.putArchiveEntry((ArchiveEntry)zae);
                zos.write(buf);
                zos.closeArchiveEntry();
                zos.close();
                RandomAccessFile a = new RandomAccessFile(f, "r");
                try {
                    Zip64SupportIT.getLengthAndPositionAtCentralDirectory(a);
                    long cfhPos = a.getFilePointer();
                    byte[] header = new byte[12];
                    a.readFully(header);
                    Assert.assertArrayEquals((byte[])new byte[]{80, 75, 1, 2, 45, 0, 45, 0, 8, 8, 8, 0}, (byte[])header);
                    a.skipBytes(4);
                    byte[] crc = new byte[4];
                    a.readFully(crc);
                    Assert.assertArrayEquals((byte[])new byte[]{-98, -53, 121, 18}, (byte[])crc);
                    a.skipBytes(4);
                    byte[] rest = new byte[23];
                    a.readFully(rest);
                    Assert.assertArrayEquals((byte[])new byte[]{64, 66, 15, 0, 1, 0, 4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 48}, (byte[])rest);
                    byte[] extra = new byte[4];
                    a.readFully(extra);
                    Assert.assertArrayEquals((byte[])new byte[]{1, 0, 0, 0}, (byte[])extra);
                    a.seek(cfhPos - 24L);
                    byte[] dd = new byte[8];
                    a.readFully(dd);
                    Assert.assertArrayEquals((byte[])new byte[]{80, 75, 7, 8, -98, -53, 121, 18}, (byte[])dd);
                    a.skipBytes(8);
                    dd = new byte[8];
                    a.readFully(dd);
                    Assert.assertArrayEquals((byte[])new byte[]{64, 66, 15, 0, 0, 0, 0, 0}, (byte[])dd);
                    a.seek(0L);
                    header = new byte[10];
                    a.readFully(header);
                    Assert.assertArrayEquals((byte[])new byte[]{80, 75, 3, 4, 45, 0, 8, 8, 8, 0}, (byte[])header);
                    a.skipBytes(4);
                    rest = new byte[17];
                    a.readFully(rest);
                    Assert.assertArrayEquals((byte[])new byte[]{0, 0, 0, 0, -1, -1, -1, -1, -1, -1, -1, -1, 1, 0, 20, 0, 48}, (byte[])rest);
                    extra = new byte[20];
                    a.readFully(extra);
                    Assert.assertArrayEquals((byte[])new byte[]{1, 0, 16, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, (byte[])extra);
                }
                finally {
                    a.close();
                }
            }
        };
    }

    @Test
    public void writeSmallDeflatedEntryKnownSizeToStreamModeAlways() throws Throwable {
        Zip64SupportIT.withTemporaryArchive("writeSmallDeflatedEntryKnownSizeToStreamModeAlways", Zip64SupportIT.writeSmallDeflatedEntryToStreamModeAlways(true), false);
    }

    @Test
    public void writeSmallDeflatedEntryUnknownSizeToStreamModeAlways() throws Throwable {
        Zip64SupportIT.withTemporaryArchive("writeSmallDeflatedEntryUnknownSizeToStreamModeAlways", Zip64SupportIT.writeSmallDeflatedEntryToStreamModeAlways(false), false);
    }

    private static ZipOutputTest writeSmallDeflatedEntryToFile(boolean knownSize) {
        return Zip64SupportIT.writeSmallDeflatedEntryToFile(knownSize, Zip64Mode.AsNeeded);
    }

    private static ZipOutputTest writeSmallDeflatedEntryToFile(final boolean knownSize, final Zip64Mode mode) {
        return new ZipOutputTest(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void test(File f, ZipArchiveOutputStream zos) throws IOException {
                if (mode != Zip64Mode.AsNeeded) {
                    zos.setUseZip64(mode);
                }
                byte[] buf = new byte[1000000];
                ZipArchiveEntry zae = new ZipArchiveEntry("0");
                if (knownSize) {
                    zae.setSize(1000000L);
                }
                zae.setMethod(8);
                zos.putArchiveEntry((ArchiveEntry)zae);
                zos.write(buf);
                zos.closeArchiveEntry();
                zos.close();
                RandomAccessFile a = new RandomAccessFile(f, "r");
                try {
                    Zip64SupportIT.getLengthAndPositionAtCentralDirectory(a);
                    byte[] header = new byte[12];
                    a.readFully(header);
                    Assert.assertArrayEquals((byte[])new byte[]{80, 75, 1, 2, 20, 0, 10, 0, 0, 8, 8, 0}, (byte[])header);
                    a.skipBytes(4);
                    byte[] crc = new byte[4];
                    a.readFully(crc);
                    Assert.assertArrayEquals((byte[])new byte[]{-98, -53, 121, 18}, (byte[])crc);
                    a.skipBytes(4);
                    byte[] rest = new byte[23];
                    a.readFully(rest);
                    Assert.assertArrayEquals((byte[])new byte[]{64, 66, 15, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 48}, (byte[])rest);
                    a.seek(0L);
                    header = new byte[10];
                    a.readFully(header);
                    Assert.assertArrayEquals((byte[])new byte[]{80, 75, 3, 4, 10, 0, 0, 8, 8, 0}, (byte[])header);
                    a.skipBytes(4);
                    crc = new byte[4];
                    a.readFully(crc);
                    Assert.assertArrayEquals((byte[])new byte[]{-98, -53, 121, 18}, (byte[])crc);
                    a.skipBytes(4);
                    rest = new byte[9];
                    a.readFully(rest);
                    boolean hasExtra = mode == Zip64Mode.AsNeeded && !knownSize;
                    Assert.assertArrayEquals((byte[])new byte[]{64, 66, 15, 0, 1, 0, (byte)(!hasExtra ? 0 : 20), 0, 48}, (byte[])rest);
                    if (hasExtra) {
                        byte[] extra = new byte[12];
                        a.readFully(extra);
                        Assert.assertArrayEquals((byte[])new byte[]{1, 0, 16, 0, 64, 66, 15, 0, 0, 0, 0, 0}, (byte[])extra);
                    }
                }
                finally {
                    a.close();
                }
            }
        };
    }

    @Test
    public void writeSmallDeflatedEntryKnownSizeToFile() throws Throwable {
        Zip64SupportIT.withTemporaryArchive("writeSmallDeflatedEntryKnownSizeToFile", Zip64SupportIT.writeSmallDeflatedEntryToFile(true), true);
    }

    @Test
    public void writeSmallDeflatedEntryUnknownSizeToFile() throws Throwable {
        Zip64SupportIT.withTemporaryArchive("writeSmallDeflatedEntryUnknownSizeToFile", Zip64SupportIT.writeSmallDeflatedEntryToFile(false), true);
    }

    @Test
    public void writeSmallDeflatedEntryKnownSizeToFileModeNever() throws Throwable {
        Zip64SupportIT.withTemporaryArchive("writeSmallDeflatedEntryKnownSizeToFileModeNever", Zip64SupportIT.writeSmallDeflatedEntryToFile(true, Zip64Mode.Never), true);
    }

    @Test
    public void writeSmallDeflatedEntryUnknownSizeToFileModeNever() throws Throwable {
        Zip64SupportIT.withTemporaryArchive("writeSmallDeflatedEntryUnknownSizeToFileModeNever", Zip64SupportIT.writeSmallDeflatedEntryToFile(false, Zip64Mode.Never), true);
    }

    private static ZipOutputTest writeSmallDeflatedEntryToFileModeAlways(final boolean knownSize) {
        return new ZipOutputTest(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void test(File f, ZipArchiveOutputStream zos) throws IOException {
                zos.setUseZip64(Zip64Mode.Always);
                byte[] buf = new byte[1000000];
                ZipArchiveEntry zae = new ZipArchiveEntry("0");
                if (knownSize) {
                    zae.setSize(1000000L);
                }
                zae.setMethod(8);
                zos.putArchiveEntry((ArchiveEntry)zae);
                zos.write(buf);
                zos.closeArchiveEntry();
                zos.close();
                RandomAccessFile a = new RandomAccessFile(f, "r");
                try {
                    Zip64SupportIT.getLengthAndPositionAtCentralDirectory(a);
                    byte[] header = new byte[12];
                    a.readFully(header);
                    Assert.assertArrayEquals((byte[])new byte[]{80, 75, 1, 2, 45, 0, 45, 0, 0, 8, 8, 0}, (byte[])header);
                    a.skipBytes(4);
                    byte[] crc = new byte[4];
                    a.readFully(crc);
                    Assert.assertArrayEquals((byte[])new byte[]{-98, -53, 121, 18}, (byte[])crc);
                    a.skipBytes(4);
                    byte[] rest = new byte[23];
                    a.readFully(rest);
                    Assert.assertArrayEquals((byte[])new byte[]{64, 66, 15, 0, 1, 0, 4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 48}, (byte[])rest);
                    byte[] extra = new byte[4];
                    a.readFully(extra);
                    Assert.assertArrayEquals((byte[])new byte[]{1, 0, 0, 0}, (byte[])extra);
                    a.seek(0L);
                    header = new byte[10];
                    a.readFully(header);
                    Assert.assertArrayEquals((byte[])new byte[]{80, 75, 3, 4, 45, 0, 0, 8, 8, 0}, (byte[])header);
                    a.skipBytes(4);
                    crc = new byte[4];
                    a.readFully(crc);
                    Assert.assertArrayEquals((byte[])new byte[]{-98, -53, 121, 18}, (byte[])crc);
                    rest = new byte[13];
                    a.readFully(rest);
                    Assert.assertArrayEquals((byte[])new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, 1, 0, 20, 0, 48}, (byte[])rest);
                    extra = new byte[12];
                    a.readFully(extra);
                    Assert.assertArrayEquals((byte[])new byte[]{1, 0, 16, 0, 64, 66, 15, 0, 0, 0, 0, 0}, (byte[])extra);
                }
                finally {
                    a.close();
                }
            }
        };
    }

    @Test
    public void writeSmallDeflatedEntryKnownSizeToFileModeAlways() throws Throwable {
        Zip64SupportIT.withTemporaryArchive("writeSmallDeflatedEntryKnownSizeToFileModeAlways", Zip64SupportIT.writeSmallDeflatedEntryToFileModeAlways(true), true);
    }

    @Test
    public void writeSmallDeflatedEntryUnknownSizeToFileModeAlways() throws Throwable {
        Zip64SupportIT.withTemporaryArchive("writeSmallDeflatedEntryUnknownSizeToFileModeAlways", Zip64SupportIT.writeSmallDeflatedEntryToFileModeAlways(false), true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void withTemporaryArchive(String testName, ZipOutputTest test, boolean useRandomAccessFile) throws Throwable {
        ZipArchiveOutputStream zipArchiveOutputStream;
        File f = Zip64SupportIT.getTempFile(testName);
        BufferedOutputStream os = null;
        if (useRandomAccessFile) {
            zipArchiveOutputStream = new ZipArchiveOutputStream(f);
        } else {
            os = new BufferedOutputStream(new FileOutputStream(f));
            ZipArchiveOutputStream zipArchiveOutputStream2 = new ZipArchiveOutputStream((OutputStream)os);
            zipArchiveOutputStream = zipArchiveOutputStream2;
        }
        ZipArchiveOutputStream zos = zipArchiveOutputStream;
        try {
            test.test(f, zos);
        }
        catch (IOException ex) {
            System.err.println("Failed to write archive because of: " + ex.getMessage() + " - likely not enough disk space.");
            Assume.assumeTrue((boolean)false);
        }
        finally {
            try {
                zos.destroy();
            }
            finally {
                if (os != null) {
                    os.close();
                }
                AbstractTestCase.tryHardToDelete(f);
            }
        }
    }

    private static File get5GBZerosFile() throws Throwable {
        return AbstractTestCase.getFile("5GB_of_Zeros.zip");
    }

    private static File get5GBZerosFileGeneratedBy7ZIP() throws Throwable {
        return AbstractTestCase.getFile("5GB_of_Zeros_7ZIP.zip");
    }

    private static File get5GBZerosFileGeneratedByJava7Jar() throws Throwable {
        return AbstractTestCase.getFile("5GB_of_Zeros_jar.zip");
    }

    private static File get5GBZerosFileGeneratedByWinZIP() throws Throwable {
        return AbstractTestCase.getFile("5GB_of_Zeros_WinZip.zip");
    }

    private static File get5GBZerosFileGeneratedByPKZip() throws Throwable {
        return AbstractTestCase.getFile("5GB_of_Zeros_PKZip.zip");
    }

    private static File get100KFileFile() throws Throwable {
        return AbstractTestCase.getFile("100k_Files.zip");
    }

    private static File get100KFileFileGeneratedBy7ZIP() throws Throwable {
        return AbstractTestCase.getFile("100k_Files_7ZIP.zip");
    }

    private static File get100KFileFileGeneratedByWinCF() throws Throwable {
        return AbstractTestCase.getFile("100k_Files_WindowsCompressedFolders.zip");
    }

    private static File get100KFileFileGeneratedByJava7Jar() throws Throwable {
        return AbstractTestCase.getFile("100k_Files_jar.zip");
    }

    private static File get100KFileFileGeneratedByWinZIP() throws Throwable {
        return AbstractTestCase.getFile("100k_Files_WinZIP.zip");
    }

    private static File get100KFileFileGeneratedByPKZip() throws Throwable {
        return AbstractTestCase.getFile("100k_Files_PKZip.zip");
    }

    private static File getTempFile(String testName) throws Throwable {
        File f = File.createTempFile("commons-compress-" + testName, ".zip");
        f.deleteOnExit();
        return f;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void read5GBOfZerosImpl(File f, String expectedName) throws IOException {
        FileInputStream fin = new FileInputStream(f);
        ZipArchiveInputStream zin = null;
        try {
            int readNow;
            zin = new ZipArchiveInputStream((InputStream)fin);
            ZipArchiveEntry zae = zin.getNextZipEntry();
            while (zae.isDirectory()) {
                zae = zin.getNextZipEntry();
            }
            Assert.assertEquals((Object)expectedName, (Object)zae.getName());
            byte[] buf = new byte[0x100000];
            long read = 0L;
            Random r = new Random(System.currentTimeMillis());
            while ((readNow = zin.read(buf, 0, buf.length)) > 0) {
                for (int i = 0; i < 1024; ++i) {
                    int idx = r.nextInt(readNow);
                    Assert.assertEquals((String)("testing byte " + (read + (long)idx)), (long)0L, (long)buf[idx]);
                }
                read += (long)readNow;
            }
            Assert.assertEquals((long)5000000000L, (long)read);
            Assert.assertNull((Object)zin.getNextZipEntry());
            Assert.assertEquals((long)5000000000L, (long)zae.getSize());
        }
        finally {
            if (zin != null) {
                zin.close();
            }
            fin.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void read5GBOfZerosUsingZipFileImpl(File f, String expectedName) throws IOException {
        ZipFile zf = null;
        try {
            zf = new ZipFile(f);
            Enumeration e = zf.getEntries();
            Assert.assertTrue((boolean)e.hasMoreElements());
            ZipArchiveEntry zae = (ZipArchiveEntry)e.nextElement();
            while (zae.isDirectory()) {
                zae = (ZipArchiveEntry)e.nextElement();
            }
            Assert.assertEquals((Object)expectedName, (Object)zae.getName());
            Assert.assertEquals((long)5000000000L, (long)zae.getSize());
            byte[] buf = new byte[0x100000];
            long read = 0L;
            Random r = new Random(System.currentTimeMillis());
            InputStream zin = zf.getInputStream(zae);
            try {
                int readNow;
                while ((readNow = zin.read(buf, 0, buf.length)) > 0) {
                    for (int i = 0; i < 1024; ++i) {
                        int idx = r.nextInt(readNow);
                        Assert.assertEquals((String)("testing byte " + (read + (long)idx)), (long)0L, (long)buf[idx]);
                    }
                    read += (long)readNow;
                }
            }
            finally {
                zin.close();
            }
            Assert.assertEquals((long)5000000000L, (long)read);
            Assert.assertFalse((boolean)e.hasMoreElements());
        }
        catch (Throwable throwable) {
            ZipFile.closeQuietly(zf);
            throw throwable;
        }
        ZipFile.closeQuietly((ZipFile)zf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void read100KFilesImpl(File f) throws IOException {
        FileInputStream fin = new FileInputStream(f);
        ZipArchiveInputStream zin = null;
        try {
            zin = new ZipArchiveInputStream((InputStream)fin);
            int files = 0;
            ZipArchiveEntry zae = null;
            while ((zae = zin.getNextZipEntry()) != null) {
                if (zae.isDirectory()) continue;
                ++files;
                Assert.assertEquals((long)0L, (long)zae.getSize());
            }
            Assert.assertEquals((long)100000L, (long)files);
        }
        finally {
            if (zin != null) {
                zin.close();
            }
            fin.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void read100KFilesUsingZipFileImpl(File f) throws IOException {
        ZipFile zf = null;
        try {
            zf = new ZipFile(f);
            int files = 0;
            Enumeration e = zf.getEntries();
            while (e.hasMoreElements()) {
                ZipArchiveEntry zae = (ZipArchiveEntry)e.nextElement();
                if (zae.isDirectory()) continue;
                ++files;
                Assert.assertEquals((long)0L, (long)zae.getSize());
            }
            Assert.assertEquals((long)100000L, (long)files);
        }
        catch (Throwable throwable) {
            ZipFile.closeQuietly(zf);
            throw throwable;
        }
        ZipFile.closeQuietly((ZipFile)zf);
    }

    private static long getLengthAndPositionAtCentralDirectory(RandomAccessFile a) throws IOException {
        long end = a.length();
        a.seek(end - 22L - 20L);
        byte[] sig = new byte[4];
        a.readFully(sig);
        if (sig[0] != 80 || sig[1] != 75 || sig[2] != 6 || sig[3] != 7) {
            return Zip64SupportIT.getLengthAndPositionAtCentralDirectory32(a, end);
        }
        long cdOffsetLoc = end - 22L - 20L - 56L + 48L;
        a.seek(cdOffsetLoc);
        byte[] cdOffset = new byte[8];
        a.readFully(cdOffset);
        a.seek(ZipEightByteInteger.getLongValue((byte[])cdOffset));
        return end;
    }

    private static long getLengthAndPositionAtCentralDirectory32(RandomAccessFile a, long end) throws IOException {
        a.seek(end - 22L + 16L);
        byte[] cdOffset = new byte[4];
        a.readFully(cdOffset);
        a.seek(ZipLong.getValue((byte[])cdOffset));
        return end;
    }

    private static void write100KFilesToStream(ZipArchiveOutputStream zos) throws IOException {
        for (int i = 0; i < 100000; ++i) {
            ZipArchiveEntry zae = new ZipArchiveEntry(String.valueOf(i));
            zae.setSize(0L);
            zos.putArchiveEntry((ArchiveEntry)zae);
            zos.closeArchiveEntry();
        }
        zos.close();
    }

    private static void write3EntriesCreatingBigArchiveToStream(ZipArchiveOutputStream zos) throws IOException {
        byte[] buf = new byte[1000000];
        ZipArchiveEntry zae = null;
        for (int i = 0; i < 2; ++i) {
            zae = new ZipArchiveEntry(String.valueOf(i));
            zae.setSize(2500000000L);
            zae.setMethod(0);
            zae.setCrc(2319486742L);
            zos.putArchiveEntry((ArchiveEntry)zae);
            int j = 0;
            while ((long)j < 2500L) {
                zos.write(buf);
                ++j;
            }
            zos.closeArchiveEntry();
        }
        zae = new ZipArchiveEntry(String.valueOf(2));
        zae.setSize(1L);
        zae.setMethod(0);
        zae.setCrc(163128923L);
        zos.putArchiveEntry((ArchiveEntry)zae);
        zos.write(new byte[]{42});
        zos.closeArchiveEntry();
        zos.close();
    }

    static interface ZipOutputTest {
        public void test(File var1, ZipArchiveOutputStream var2) throws IOException;
    }
}

