/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.archivers.zip;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.NoSuchElementException;
import junit.framework.TestCase;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.zip.AsiExtraField;
import org.apache.commons.compress.archivers.zip.ExtraFieldUtilsTest;
import org.apache.commons.compress.archivers.zip.UnrecognizedExtraField;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveOutputStream;
import org.apache.commons.compress.archivers.zip.ZipExtraField;
import org.apache.commons.compress.archivers.zip.ZipShort;

public class ZipArchiveEntryTest
extends TestCase {
    public ZipArchiveEntryTest(String name) {
        super(name);
    }

    public void testExtraFields() {
        AsiExtraField a = new AsiExtraField();
        a.setDirectory(true);
        a.setMode(493);
        UnrecognizedExtraField u = new UnrecognizedExtraField();
        u.setHeaderId(ExtraFieldUtilsTest.UNRECOGNIZED_HEADER);
        u.setLocalFileDataData(new byte[0]);
        ZipArchiveEntry ze = new ZipArchiveEntry("test/");
        ze.setExtraFields(new ZipExtraField[]{a, u});
        byte[] data1 = ze.getExtra();
        ZipExtraField[] result = ze.getExtraFields();
        ZipArchiveEntryTest.assertEquals((String)"first pass", (int)2, (int)result.length);
        ZipArchiveEntryTest.assertSame((Object)a, (Object)result[0]);
        ZipArchiveEntryTest.assertSame((Object)u, (Object)result[1]);
        UnrecognizedExtraField u2 = new UnrecognizedExtraField();
        u2.setHeaderId(ExtraFieldUtilsTest.UNRECOGNIZED_HEADER);
        u2.setLocalFileDataData(new byte[]{1});
        ze.addExtraField((ZipExtraField)u2);
        byte[] data2 = ze.getExtra();
        result = ze.getExtraFields();
        ZipArchiveEntryTest.assertEquals((String)"second pass", (int)2, (int)result.length);
        ZipArchiveEntryTest.assertSame((Object)a, (Object)result[0]);
        ZipArchiveEntryTest.assertSame((Object)u2, (Object)result[1]);
        ZipArchiveEntryTest.assertEquals((String)"length second pass", (int)(data1.length + 1), (int)data2.length);
        UnrecognizedExtraField u3 = new UnrecognizedExtraField();
        u3.setHeaderId(new ZipShort(2));
        u3.setLocalFileDataData(new byte[]{1});
        ze.addExtraField((ZipExtraField)u3);
        result = ze.getExtraFields();
        ZipArchiveEntryTest.assertEquals((String)"third pass", (int)3, (int)result.length);
        ze.removeExtraField(ExtraFieldUtilsTest.UNRECOGNIZED_HEADER);
        byte[] data3 = ze.getExtra();
        result = ze.getExtraFields();
        ZipArchiveEntryTest.assertEquals((String)"fourth pass", (int)2, (int)result.length);
        ZipArchiveEntryTest.assertSame((Object)a, (Object)result[0]);
        ZipArchiveEntryTest.assertSame((Object)u3, (Object)result[1]);
        ZipArchiveEntryTest.assertEquals((String)"length fourth pass", (int)data2.length, (int)data3.length);
        try {
            ze.removeExtraField(ExtraFieldUtilsTest.UNRECOGNIZED_HEADER);
            ZipArchiveEntryTest.fail((String)"should be no such element");
        }
        catch (NoSuchElementException nse) {
            // empty catch block
        }
    }

    public void testExtraFieldMerging() {
        AsiExtraField a = new AsiExtraField();
        a.setDirectory(true);
        a.setMode(493);
        UnrecognizedExtraField u = new UnrecognizedExtraField();
        u.setHeaderId(ExtraFieldUtilsTest.UNRECOGNIZED_HEADER);
        u.setLocalFileDataData(new byte[0]);
        ZipArchiveEntry ze = new ZipArchiveEntry("test/");
        ze.setExtraFields(new ZipExtraField[]{a, u});
        byte[] b = ExtraFieldUtilsTest.UNRECOGNIZED_HEADER.getBytes();
        ze.setCentralDirectoryExtra(new byte[]{b[0], b[1], 1, 0, 127});
        ZipExtraField[] result = ze.getExtraFields();
        ZipArchiveEntryTest.assertEquals((String)"first pass", (int)2, (int)result.length);
        ZipArchiveEntryTest.assertSame((Object)a, (Object)result[0]);
        ZipArchiveEntryTest.assertEquals((Object)ExtraFieldUtilsTest.UNRECOGNIZED_HEADER, (Object)result[1].getHeaderId());
        ZipArchiveEntryTest.assertEquals((Object)new ZipShort(0), (Object)result[1].getLocalFileDataLength());
        ZipArchiveEntryTest.assertEquals((Object)new ZipShort(1), (Object)result[1].getCentralDirectoryLength());
        ze.setCentralDirectoryExtra(new byte[]{2, 0, 0, 0});
        result = ze.getExtraFields();
        ZipArchiveEntryTest.assertEquals((String)"second pass", (int)3, (int)result.length);
        ze.setExtra(new byte[]{2, 0, 1, 0, 127});
        result = ze.getExtraFields();
        ZipArchiveEntryTest.assertEquals((String)"third pass", (int)3, (int)result.length);
        ZipArchiveEntryTest.assertSame((Object)a, (Object)result[0]);
        ZipArchiveEntryTest.assertEquals((Object)new ZipShort(2), (Object)result[2].getHeaderId());
        ZipArchiveEntryTest.assertEquals((Object)new ZipShort(1), (Object)result[2].getLocalFileDataLength());
        ZipArchiveEntryTest.assertEquals((Object)new ZipShort(0), (Object)result[2].getCentralDirectoryLength());
    }

    public void testAddAsFirstExtraField() {
        AsiExtraField a = new AsiExtraField();
        a.setDirectory(true);
        a.setMode(493);
        UnrecognizedExtraField u = new UnrecognizedExtraField();
        u.setHeaderId(ExtraFieldUtilsTest.UNRECOGNIZED_HEADER);
        u.setLocalFileDataData(new byte[0]);
        ZipArchiveEntry ze = new ZipArchiveEntry("test/");
        ze.setExtraFields(new ZipExtraField[]{a, u});
        byte[] data1 = ze.getExtra();
        UnrecognizedExtraField u2 = new UnrecognizedExtraField();
        u2.setHeaderId(ExtraFieldUtilsTest.UNRECOGNIZED_HEADER);
        u2.setLocalFileDataData(new byte[]{1});
        ze.addAsFirstExtraField((ZipExtraField)u2);
        byte[] data2 = ze.getExtra();
        ZipExtraField[] result = ze.getExtraFields();
        ZipArchiveEntryTest.assertEquals((String)"second pass", (int)2, (int)result.length);
        ZipArchiveEntryTest.assertSame((Object)u2, (Object)result[0]);
        ZipArchiveEntryTest.assertSame((Object)a, (Object)result[1]);
        ZipArchiveEntryTest.assertEquals((String)"length second pass", (int)(data1.length + 1), (int)data2.length);
        UnrecognizedExtraField u3 = new UnrecognizedExtraField();
        u3.setHeaderId(new ZipShort(2));
        u3.setLocalFileDataData(new byte[]{1});
        ze.addAsFirstExtraField((ZipExtraField)u3);
        result = ze.getExtraFields();
        ZipArchiveEntryTest.assertEquals((String)"third pass", (int)3, (int)result.length);
        ZipArchiveEntryTest.assertSame((Object)u3, (Object)result[0]);
        ZipArchiveEntryTest.assertSame((Object)u2, (Object)result[1]);
        ZipArchiveEntryTest.assertSame((Object)a, (Object)result[2]);
    }

    public void testUnixMode() {
        ZipArchiveEntry ze = new ZipArchiveEntry("foo");
        ZipArchiveEntryTest.assertEquals((int)0, (int)ze.getPlatform());
        ze.setUnixMode(493);
        ZipArchiveEntryTest.assertEquals((int)3, (int)ze.getPlatform());
        ZipArchiveEntryTest.assertEquals((long)493L, (long)(ze.getExternalAttributes() >> 16 & 0xFFFFL));
        ZipArchiveEntryTest.assertEquals((long)0L, (long)(ze.getExternalAttributes() & 0xFFFFL));
        ze.setUnixMode(292);
        ZipArchiveEntryTest.assertEquals((int)3, (int)ze.getPlatform());
        ZipArchiveEntryTest.assertEquals((long)292L, (long)(ze.getExternalAttributes() >> 16 & 0xFFFFL));
        ZipArchiveEntryTest.assertEquals((long)1L, (long)(ze.getExternalAttributes() & 0xFFFFL));
        ze = new ZipArchiveEntry("foo/");
        ZipArchiveEntryTest.assertEquals((int)0, (int)ze.getPlatform());
        ze.setUnixMode(511);
        ZipArchiveEntryTest.assertEquals((int)3, (int)ze.getPlatform());
        ZipArchiveEntryTest.assertEquals((long)511L, (long)(ze.getExternalAttributes() >> 16 & 0xFFFFL));
        ZipArchiveEntryTest.assertEquals((long)16L, (long)(ze.getExternalAttributes() & 0xFFFFL));
        ze.setUnixMode(383);
        ZipArchiveEntryTest.assertEquals((int)3, (int)ze.getPlatform());
        ZipArchiveEntryTest.assertEquals((long)383L, (long)(ze.getExternalAttributes() >> 16 & 0xFFFFL));
        ZipArchiveEntryTest.assertEquals((long)17L, (long)(ze.getExternalAttributes() & 0xFFFFL));
    }

    public void testCompressionMethod() throws Exception {
        ZipArchiveOutputStream zos = new ZipArchiveOutputStream((OutputStream)new ByteArrayOutputStream());
        ZipArchiveEntry entry = new ZipArchiveEntry("foo");
        ZipArchiveEntryTest.assertEquals((int)-1, (int)entry.getMethod());
        ZipArchiveEntryTest.assertFalse((boolean)zos.canWriteEntryData((ArchiveEntry)entry));
        entry.setMethod(0);
        ZipArchiveEntryTest.assertEquals((int)0, (int)entry.getMethod());
        ZipArchiveEntryTest.assertTrue((boolean)zos.canWriteEntryData((ArchiveEntry)entry));
        entry.setMethod(8);
        ZipArchiveEntryTest.assertEquals((int)8, (int)entry.getMethod());
        ZipArchiveEntryTest.assertTrue((boolean)zos.canWriteEntryData((ArchiveEntry)entry));
        entry.setMethod(6);
        ZipArchiveEntryTest.assertEquals((int)6, (int)entry.getMethod());
        ZipArchiveEntryTest.assertFalse((boolean)zos.canWriteEntryData((ArchiveEntry)entry));
        zos.close();
    }

    public void testNotEquals() {
        ZipArchiveEntry entry1 = new ZipArchiveEntry("foo");
        ZipArchiveEntry entry2 = new ZipArchiveEntry("bar");
        ZipArchiveEntryTest.assertFalse((boolean)entry1.equals((Object)entry2));
    }

    public void testNullCommentEqualsEmptyComment() {
        ZipArchiveEntry entry1 = new ZipArchiveEntry("foo");
        ZipArchiveEntry entry2 = new ZipArchiveEntry("foo");
        ZipArchiveEntry entry3 = new ZipArchiveEntry("foo");
        entry1.setComment(null);
        entry2.setComment("");
        entry3.setComment("bar");
        ZipArchiveEntryTest.assertEquals((Object)entry1, (Object)entry2);
        ZipArchiveEntryTest.assertFalse((boolean)entry1.equals((Object)entry3));
        ZipArchiveEntryTest.assertFalse((boolean)entry2.equals((Object)entry3));
    }
}

