/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.archivers.zip;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.compress.AbstractTestCase;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveInputStream;
import org.apache.commons.compress.archivers.zip.ZipFile;
import org.apache.commons.compress.archivers.zip.ZipMethod;
import org.apache.commons.compress.utils.IOUtils;
import org.junit.Assert;
import org.junit.Test;

public class ZipArchiveInputStreamTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void winzipBackSlashWorkaround() throws Exception {
        ZipArchiveInputStream in = null;
        try {
            in = new ZipArchiveInputStream((InputStream)new FileInputStream(AbstractTestCase.getFile("test-winzip.zip")));
            ZipArchiveEntry zae = in.getNextZipEntry();
            zae = in.getNextZipEntry();
            zae = in.getNextZipEntry();
            Assert.assertEquals((Object)"\u00e4/", (Object)zae.getName());
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void properUseOfInflater() throws Exception {
        ZipFile zf = null;
        ZipArchiveInputStream in = null;
        try {
            ZipArchiveEntry innerEntry;
            zf = new ZipFile(AbstractTestCase.getFile("COMPRESS-189.zip"));
            ZipArchiveEntry zae = zf.getEntry("USD0558682-20080101.ZIP");
            in = new ZipArchiveInputStream((InputStream)new BufferedInputStream(zf.getInputStream(zae)));
            while ((innerEntry = in.getNextZipEntry()) != null) {
                if (!innerEntry.getName().endsWith("XML")) continue;
                Assert.assertTrue((0 < in.read() ? 1 : 0) != 0);
            }
        }
        finally {
            if (zf != null) {
                zf.close();
            }
            if (in != null) {
                in.close();
            }
        }
    }

    @Test
    public void shouldConsumeArchiveCompletely() throws Exception {
        InputStream is = ZipArchiveInputStreamTest.class.getResourceAsStream("/archive_with_trailer.zip");
        ZipArchiveInputStream zip = new ZipArchiveInputStream(is);
        while (zip.getNextZipEntry() != null) {
        }
        byte[] expected = new byte[]{72, 101, 108, 108, 111, 44, 32, 119, 111, 114, 108, 100, 33, 10};
        byte[] actual = new byte[expected.length];
        is.read(actual);
        Assert.assertArrayEquals((byte[])expected, (byte[])actual);
        zip.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldReadNestedZip() throws IOException {
        ZipArchiveInputStream in = null;
        try {
            in = new ZipArchiveInputStream((InputStream)new FileInputStream(AbstractTestCase.getFile("COMPRESS-219.zip")));
            this.extractZipInputStream(in);
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
    }

    private void extractZipInputStream(ZipArchiveInputStream in) throws IOException {
        ZipArchiveEntry zae = in.getNextZipEntry();
        while (zae != null) {
            if (zae.getName().endsWith(".zip")) {
                this.extractZipInputStream(new ZipArchiveInputStream((InputStream)in));
            }
            zae = in.getNextZipEntry();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testUnshrinkEntry() throws Exception {
        ZipArchiveInputStream in = new ZipArchiveInputStream((InputStream)new FileInputStream(AbstractTestCase.getFile("SHRUNK.ZIP")));
        ZipArchiveEntry entry = in.getNextZipEntry();
        Assert.assertEquals((String)"method", (long)ZipMethod.UNSHRINKING.getCode(), (long)entry.getMethod());
        Assert.assertTrue((boolean)in.canReadEntryData((ArchiveEntry)entry));
        FileInputStream original = new FileInputStream(AbstractTestCase.getFile("test1.xml"));
        try {
            Assert.assertArrayEquals((byte[])IOUtils.toByteArray((InputStream)original), (byte[])IOUtils.toByteArray((InputStream)in));
        }
        finally {
            original.close();
        }
        entry = in.getNextZipEntry();
        Assert.assertEquals((String)"method", (long)ZipMethod.UNSHRINKING.getCode(), (long)entry.getMethod());
        Assert.assertTrue((boolean)in.canReadEntryData((ArchiveEntry)entry));
        original = new FileInputStream(AbstractTestCase.getFile("test2.xml"));
        try {
            Assert.assertArrayEquals((byte[])IOUtils.toByteArray((InputStream)original), (byte[])IOUtils.toByteArray((InputStream)in));
        }
        finally {
            original.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testReadingOfFirstStoredEntry() throws Exception {
        ZipArchiveInputStream in = new ZipArchiveInputStream((InputStream)new FileInputStream(AbstractTestCase.getFile("COMPRESS-264.zip")));
        try {
            ZipArchiveEntry ze = in.getNextZipEntry();
            Assert.assertEquals((long)5L, (long)ze.getSize());
            Assert.assertArrayEquals((byte[])new byte[]{100, 97, 116, 97, 10}, (byte[])IOUtils.toByteArray((InputStream)in));
        }
        finally {
            in.close();
        }
    }
}

