/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.archivers.zip;

import java.math.BigInteger;
import junit.framework.TestCase;
import org.apache.commons.compress.archivers.zip.ZipEightByteInteger;

public class ZipEightByteIntegerTest
extends TestCase {
    public ZipEightByteIntegerTest(String name) {
        super(name);
    }

    public void testLongToBytes() {
        ZipEightByteInteger zl = new ZipEightByteInteger(734744827512L);
        byte[] result = zl.getBytes();
        ZipEightByteIntegerTest.assertEquals((String)"length getBytes", (int)8, (int)result.length);
        ZipEightByteIntegerTest.assertEquals((String)"first byte getBytes", (int)120, (int)result[0]);
        ZipEightByteIntegerTest.assertEquals((String)"second byte getBytes", (int)86, (int)result[1]);
        ZipEightByteIntegerTest.assertEquals((String)"third byte getBytes", (int)52, (int)result[2]);
        ZipEightByteIntegerTest.assertEquals((String)"fourth byte getBytes", (int)18, (int)result[3]);
        ZipEightByteIntegerTest.assertEquals((String)"fifth byte getBytes", (byte)-85, (byte)result[4]);
        ZipEightByteIntegerTest.assertEquals((String)"sixth byte getBytes", (int)0, (int)result[5]);
        ZipEightByteIntegerTest.assertEquals((String)"seventh byte getBytes", (int)0, (int)result[6]);
        ZipEightByteIntegerTest.assertEquals((String)"eighth byte getBytes", (int)0, (int)result[7]);
    }

    public void testLongFromBytes() {
        byte[] val = new byte[]{120, 86, 52, 18, -85, 0, 0, 0};
        ZipEightByteInteger zl = new ZipEightByteInteger(val);
        ZipEightByteIntegerTest.assertEquals((String)"longValue from bytes", (long)734744827512L, (long)zl.getLongValue());
    }

    public void testBIToBytes() {
        ZipEightByteInteger zl = new ZipEightByteInteger(BigInteger.valueOf(Long.MAX_VALUE).shiftLeft(1));
        byte[] result = zl.getBytes();
        ZipEightByteIntegerTest.assertEquals((String)"length getBytes", (int)8, (int)result.length);
        ZipEightByteIntegerTest.assertEquals((String)"first byte getBytes", (byte)-2, (byte)result[0]);
        ZipEightByteIntegerTest.assertEquals((String)"second byte getBytes", (byte)-1, (byte)result[1]);
        ZipEightByteIntegerTest.assertEquals((String)"third byte getBytes", (byte)-1, (byte)result[2]);
        ZipEightByteIntegerTest.assertEquals((String)"fourth byte getBytes", (byte)-1, (byte)result[3]);
        ZipEightByteIntegerTest.assertEquals((String)"fifth byte getBytes", (byte)-1, (byte)result[4]);
        ZipEightByteIntegerTest.assertEquals((String)"sixth byte getBytes", (byte)-1, (byte)result[5]);
        ZipEightByteIntegerTest.assertEquals((String)"seventh byte getBytes", (byte)-1, (byte)result[6]);
        ZipEightByteIntegerTest.assertEquals((String)"eighth byte getBytes", (byte)-1, (byte)result[7]);
    }

    public void testBIFromBytes() {
        byte[] val = new byte[]{-2, -1, -1, -1, -1, -1, -1, -1};
        ZipEightByteInteger zl = new ZipEightByteInteger(val);
        ZipEightByteIntegerTest.assertEquals((String)"value from bytes", (Object)BigInteger.valueOf(Long.MAX_VALUE).shiftLeft(1), (Object)zl.getValue());
    }

    public void testEquals() {
        ZipEightByteInteger zl = new ZipEightByteInteger(305419896L);
        ZipEightByteInteger zl2 = new ZipEightByteInteger(305419896L);
        ZipEightByteInteger zl3 = new ZipEightByteInteger(-2023406815L);
        ZipEightByteIntegerTest.assertTrue((String)"reflexive", (boolean)zl.equals((Object)zl));
        ZipEightByteIntegerTest.assertTrue((String)"works", (boolean)zl.equals((Object)zl2));
        ZipEightByteIntegerTest.assertTrue((String)"works, part two", (!zl.equals((Object)zl3) ? 1 : 0) != 0);
        ZipEightByteIntegerTest.assertTrue((String)"symmetric", (boolean)zl2.equals((Object)zl));
        ZipEightByteIntegerTest.assertTrue((String)"null handling", (!zl.equals(null) ? 1 : 0) != 0);
        ZipEightByteIntegerTest.assertTrue((String)"non ZipEightByteInteger handling", (!zl.equals((Object)new Integer(4660)) ? 1 : 0) != 0);
    }

    public void testSign() {
        ZipEightByteInteger zl = new ZipEightByteInteger(new byte[]{-1, -1, -1, -1, -1, -1, -1, -1});
        ZipEightByteIntegerTest.assertEquals((Object)BigInteger.valueOf(Long.MAX_VALUE).shiftLeft(1).setBit(0), (Object)zl.getValue());
    }
}

